/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.processing;

import fr.profi.ms.algo.IsotopePatternEstimator;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.model.SpectrumData;
import fr.proline.mzscope.processing.Scorer;
import fr.proline.mzscope.processing.SpectrumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class WeightedDotProductScorer
implements Scorer {
    private static final Logger logger = LoggerFactory.getLogger(WeightedDotProductScorer.class);
    private static final int MAX_SCORED_ISOTOPES = 8;

    @Override
    public Tuple2<Double, TheoreticalIsotopePattern> score(SpectrumData currentSpectrum, double intialMz, int shift, int charge, double ppmTol) {
        double score = 0.0;
        double mz = intialMz - (double)shift * IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
        TheoreticalIsotopePattern pattern = IsotopePatternEstimator.getTheoreticalPattern((double)mz, (int)charge);
        Double ipMoz = mz;
        double[] observed = new double[pattern.mzAbundancePairs().length];
        double[] expected = new double[pattern.mzAbundancePairs().length];
        int observations = 0;
        for (int rank = 0; rank < pattern.mzAbundancePairs().length; ++rank) {
            ipMoz = rank == 0 ? ipMoz : ipMoz + IsotopePatternEstimator.avgIsoMassDiff() / (double)charge;
            int nearestPeakIdx = SpectrumUtils.getNearestPeakIndex(currentSpectrum.getMzList(), ipMoz);
            if (1000000.0 * Math.abs(currentSpectrum.getMzList()[nearestPeakIdx] - ipMoz) / ipMoz < ppmTol) {
                observed[rank] = currentSpectrum.getIntensityList()[nearestPeakIdx];
                ++observations;
            } else {
                observed[rank] = 0.0;
            }
            expected[rank] = ((Float)pattern.mzAbundancePairs()[rank]._2).floatValue();
        }
        score = WeightedDotProductScorer.dotProduct(observed, expected);
        score = (1.0 - score) / (double)observations;
        return new Tuple2((Object)score, (Object)pattern);
    }

    public static double dotProduct(double[] observed, double[] expected) {
        double sumObserved = 0.0;
        double sumExpected = 0.0;
        double dotProduct = 0.0;
        for (int k = 0; k < Math.min(observed.length, 8); ++k) {
            dotProduct += observed[k] * expected[k];
            sumExpected += expected[k] * expected[k];
            sumObserved += observed[k] * observed[k];
        }
        return sumExpected == 0.0 || sumObserved == 0.0 ? 0.0 : dotProduct / (Math.sqrt(sumExpected) * Math.sqrt(sumObserved));
    }
}

