/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.IRawFile;
import fr.proline.mzscope.mzdb.ThreadedMzdbRawFile;
import fr.proline.mzscope.mzml.MzMLRawFile;
import fr.proline.mzscope.timstof.TimstofRawFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileManager {
    private static final Logger logger = LoggerFactory.getLogger(RawFileManager.class);
    private Map<String, IRawFile> files = new HashMap<String, IRawFile>();
    private IRawFile currentFile;
    private static RawFileManager instance;

    public static RawFileManager getInstance() {
        if (instance == null) {
            instance = new RawFileManager();
        }
        return instance;
    }

    private RawFileManager() {
    }

    public IRawFile addRawFile(IRawFile rawFile) {
        this.currentFile = rawFile;
        this.files.put(rawFile.getName(), this.currentFile);
        logger.info("Rawfile {} added to RawFileManager", (Object)rawFile.getFile().getAbsolutePath());
        return rawFile;
    }

    public IRawFile addRawFile(File file) {
        if (file.getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
            this.currentFile = new ThreadedMzdbRawFile(file);
            this.files.put(file.getName(), this.currentFile);
            logger.info("mzDB Rawfile {} added to RawFileManager", (Object)file.getAbsolutePath());
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".mzml")) {
            this.currentFile = new MzMLRawFile(file);
            this.files.put(file.getName(), this.currentFile);
            logger.info("mzML Rawfile {} added to RawFileManager", (Object)file.getAbsolutePath());
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".d")) {
            this.currentFile = new TimstofRawFile(file);
            this.files.put(file.getName(), this.currentFile);
            logger.info("TimsTof Rawfile {} added to RawFileManager", (Object)file.getAbsolutePath());
        }
        return this.currentFile;
    }

    public IRawFile getLastFile() {
        return this.currentFile;
    }

    public IRawFile getFile(String filename) {
        if (this.files.containsKey(filename)) {
            logger.info("RawFileManager will give access to {}", (Object)filename);
            return this.files.get(filename);
        }
        logger.warn("RawFile {} not found", (Object)filename);
        return null;
    }

    public List<IRawFile> getAllFiles() {
        return new ArrayList<IRawFile>(this.files.values());
    }

    public void removeFile(IRawFile rawFile) {
        if (this.files.containsValue(rawFile)) {
            for (Map.Entry<String, IRawFile> e : this.files.entrySet()) {
                if (!e.getValue().equals(rawFile)) continue;
                rawFile.closeIRawFile();
                this.files.remove(e.getKey());
                break;
            }
        }
    }

    public void removeAllFiles() {
        for (IRawFile rFile : this.files.values()) {
            rFile.closeIRawFile();
        }
        this.files = new HashMap<String, IRawFile>();
    }

    public boolean removeRawFile(IRawFile rawFile) {
        IRawFile removedFile = this.files.remove(rawFile.getName());
        return removedFile != null;
    }
}

