/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.proline.mzscope.model.Spectrum;
import fr.proline.mzscope.ui.event.ScanHeaderListener;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanHeaderPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(ScanHeaderPanel.class);
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("0.00");
    private static final DecimalFormat MASS_FORMATTER = new DecimalFormat("0.####");
    private JPanel mainPanel;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel precursorPanel;
    private JLabel precursorLabel;
    private JPanel scanIndexPanel;
    private JLabel scanIndexLabel;
    private JSpinner scansSpinner;
    private SpinnerModel scansSpinnerModel;
    private JPanel retentionTimePanel;
    private JLabel retentionTimeLabel;
    private JTextField retentionTimeTF;
    private JPanel msLevelPanel;
    private JLabel msLevelLabel;
    private JTextField msLevelTF;
    private JToggleButton keepSameMsLevelTB;
    private String mzdbFileName;
    private Spectrum scan;
    private EventListenerList listenerList = new EventListenerList();

    public ScanHeaderPanel(Spectrum scan, SpinnerModel model) {
        this.scan = scan;
        this.scansSpinnerModel = model;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
        this.updateScan();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setName("mainPanel");
            this.mainPanel.setLayout(new FlowLayout(3, 0, 0));
            this.mainPanel.add(this.getPanelScanIndex());
            this.mainPanel.add(this.getPanelRetentionTime());
            this.mainPanel.add(this.getPanelMsLevel());
            this.mainPanel.add(this.getPanelPrecursor());
            this.mainPanel.add(this.getPanelTitle());
        }
        return this.mainPanel;
    }

    private JPanel getPanelTitle() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setName("panelTitle");
            this.titlePanel.setLayout(new FlowLayout(3, 2, 0));
            this.titlePanel.add(this.getTitleLabel());
        }
        return this.titlePanel;
    }

    private JPanel getPanelPrecursor() {
        if (this.precursorPanel == null) {
            this.precursorPanel = new JPanel();
            this.precursorPanel.setName("panelPrecursor");
            this.precursorPanel.setLayout(new FlowLayout(3, 2, 0));
            this.precursorPanel.add(this.getPrecursorLabel());
        }
        return this.precursorPanel;
    }

    private JPanel getPanelScanIndex() {
        if (this.scanIndexPanel == null) {
            this.scanIndexPanel = new JPanel();
            this.scanIndexPanel.setName("panelScanIndex");
            this.scanIndexPanel.setLayout(new FlowLayout(3, 2, 0));
            this.scanIndexPanel.add(this.getScanIndexLabel());
            this.scanIndexPanel.add(this.getScansSpinner());
        }
        return this.scanIndexPanel;
    }

    private JPanel getPanelRetentionTime() {
        if (this.retentionTimePanel == null) {
            this.retentionTimePanel = new JPanel();
            this.retentionTimePanel.setName("panelRetentionTime");
            this.retentionTimePanel.setLayout(new FlowLayout(3, 2, 0));
            this.retentionTimePanel.add(this.getRetentionTimeLabel());
            this.retentionTimePanel.add(this.getTextFieldRetentionTime());
        }
        return this.retentionTimePanel;
    }

    private JPanel getPanelMsLevel() {
        if (this.msLevelPanel == null) {
            this.msLevelPanel = new JPanel();
            this.msLevelPanel.setName("panelMsLevel");
            this.msLevelPanel.setLayout(new FlowLayout(3, 2, 0));
            this.msLevelPanel.add(this.getLabelMsLevel());
            this.msLevelPanel.add(this.getTextFieldMsLevel());
            this.msLevelPanel.add(this.getKeepSameMsLevelBtn());
        }
        return this.msLevelPanel;
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new JLabel(this.mzdbFileName);
            this.titleLabel.setName("labelTitle");
        }
        return this.titleLabel;
    }

    private JLabel getPrecursorLabel() {
        if (this.precursorLabel == null) {
            this.precursorLabel = new JLabel("");
            this.precursorLabel.setName("labelPrecursor");
        }
        return this.precursorLabel;
    }

    private JLabel getScanIndexLabel() {
        if (this.scanIndexLabel == null) {
            this.scanIndexLabel = new JLabel("Scan :");
            this.scanIndexLabel.setName("labelScanIndex");
        }
        return this.scanIndexLabel;
    }

    private JLabel getRetentionTimeLabel() {
        if (this.retentionTimeLabel == null) {
            this.retentionTimeLabel = new JLabel("rt:");
            this.retentionTimeLabel.setName("labelRetentionTime");
        }
        return this.retentionTimeLabel;
    }

    private JLabel getLabelMsLevel() {
        if (this.msLevelLabel == null) {
            this.msLevelLabel = new JLabel("ms:");
            this.msLevelLabel.setName("labelMsLevel");
        }
        return this.msLevelLabel;
    }

    private JSpinner getScansSpinner() {
        if (this.scansSpinner == null) {
            this.scansSpinner = new JSpinner(this.scansSpinnerModel);
            ((JSpinner.DefaultEditor)this.scansSpinner.getEditor()).getTextField().setEditable(true);
            ((JSpinner.DefaultEditor)this.scansSpinner.getEditor()).getTextField().setColumns(5);
            this.scansSpinner.setName("spinnerScanIndex");
        }
        return this.scansSpinner;
    }

    private JTextField getTextFieldRetentionTime() {
        if (this.retentionTimeTF == null) {
            this.retentionTimeTF = new JTextField();
            this.retentionTimeTF.setToolTipText("retention time in min");
            this.retentionTimeTF.setColumns(6);
            this.retentionTimeTF.setName("textFieldRetentionTime");
            this.retentionTimeTF.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ScanHeaderPanel.this.retentionTimeActionPerformed(evt);
                }
            });
        }
        return this.retentionTimeTF;
    }

    private JTextField getTextFieldMsLevel() {
        if (this.msLevelTF == null) {
            this.msLevelTF = new JTextField();
            this.msLevelTF.setEditable(false);
            this.msLevelTF.setColumns(3);
            this.msLevelTF.setName("textFieldMsLevel");
            this.msLevelTF.setToolTipText("msLevel");
        }
        return this.msLevelTF;
    }

    private JToggleButton getKeepSameMsLevelBtn() {
        if (this.keepSameMsLevelTB == null) {
            this.keepSameMsLevelTB = new JToggleButton(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(24, 24);
                }
            };
            this.keepSameMsLevelTB.setBorderPainted(false);
            this.keepSameMsLevelTB.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SAME_MS_LEVEL));
            this.keepSameMsLevelTB.setSelected(true);
            this.keepSameMsLevelTB.setName("cbKeepMsLevel");
            this.keepSameMsLevelTB.setToolTipText("Stay on the same previous MS level while navigating. This can also be done by using the keyboard's arrows (or Ctrl+arrows to keep the same ms level)");
            this.keepSameMsLevelTB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScanHeaderPanel.this.msLevelActionPerformed(e);
                }
            });
        }
        return this.keepSameMsLevelTB;
    }

    private void updateScan() {
        if (this.scan == null) {
            this.clearValues();
        } else {
            if (this.scan.getPrecursorMz() == null) {
                this.precursorLabel.setText("");
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append(MASS_FORMATTER.format(this.scan.getPrecursorMz())).append(" (");
                builder.append(this.scan.getPrecursorCharge()).append("+)");
                this.precursorLabel.setText(builder.toString());
            }
            this.retentionTimeTF.setText(TIME_FORMATTER.format((double)this.scan.getRetentionTime() / 60.0));
            this.msLevelTF.setText(Integer.toString(this.scan.getMsLevel()));
            if (this.scan.getTitle() != null && !this.scan.getTitle().isEmpty()) {
                this.titleLabel.setText(this.scan.getTitle());
            }
        }
    }

    private void clearValues() {
        this.titleLabel.setText("");
        this.precursorLabel.setText("");
        this.retentionTimeTF.setText("");
        this.msLevelTF.setText("");
    }

    public void setScan(Spectrum scan) {
        this.scan = scan;
        this.updateScan();
    }

    public void setMzdbFileName(String fileName) {
        this.mzdbFileName = fileName;
        this.titleLabel.setText(fileName);
    }

    public void addScanHeaderListener(ScanHeaderListener listener) {
        this.listenerList.add(ScanHeaderListener.class, listener);
    }

    public void removeScanHeaderListener(ScanHeaderListener listener) {
        this.listenerList.remove(ScanHeaderListener.class, listener);
    }

    private void fireUpdateScanIndex(Integer scanIndex) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ScanHeaderListener.class) continue;
            ((ScanHeaderListener)listeners[i + 1]).updateScanIndex(scanIndex);
        }
    }

    private void fireUpdateRetentionTime(float retentionTime) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ScanHeaderListener.class) continue;
            ((ScanHeaderListener)listeners[i + 1]).updateRetentionTime(retentionTime);
        }
    }

    private void fireKeepMsLevel(boolean keepMsLevel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ScanHeaderListener.class) continue;
            ((ScanHeaderListener)listeners[i + 1]).keepMsLevel(keepMsLevel);
        }
    }

    public void retentionTimeActionPerformed(ActionEvent evt) {
        float retentionTimeMin;
        if (this.scan == null) {
            return;
        }
        String value = this.retentionTimeTF.getText();
        if (value == null || value.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "The retention time could not be empty!");
            this.updateScan();
            return;
        }
        try {
            retentionTimeMin = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "The format of the retention time is incorrect!");
            this.updateScan();
            return;
        }
        float retentionTime = (float)((double)retentionTimeMin * 60.0);
        this.fireUpdateRetentionTime(retentionTime);
    }

    public void scanIndexChanged(ChangeEvent e) {
        if (this.scan == null) {
            return;
        }
        int scanIndex = (Integer)this.scansSpinner.getValue();
        this.fireUpdateScanIndex(scanIndex);
    }

    public void msLevelActionPerformed(ActionEvent evt) {
        if (this.scan == null) {
            return;
        }
        this.fireKeepMsLevel(this.keepSameMsLevelTB.isSelected());
    }
}

