/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui;

import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover;
import fr.profi.mzdb.algo.signal.filtering.ISignalSmoother;
import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.proline.mzscope.model.Signal;
import fr.proline.mzscope.ui.SignalPanel;
import fr.proline.mzscope.ui.SignalWrapper;
import fr.proline.mzscope.ui.dialog.SmoothingParamDialog;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotLinear;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.LineMarker;
import fr.proline.studio.graphics.marker.PointMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import fr.proline.studio.graphics.marker.coordinates.DataCoordinates;
import fr.proline.studio.utils.CyclicColorPalette;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SignalEditorPanel
extends SignalPanel {
    private static final Logger logger = LoggerFactory.getLogger(SignalEditorPanel.class);
    private Map<Signal, PlotLinear> m_smoothedSignals = new HashMap<Signal, PlotLinear>();
    private JButton minmaxBtn;
    private JButton maxBtn;
    private JButton baseLineBtn;

    public SignalEditorPanel(Signal signal) {
        super(signal);
    }

    @Override
    protected JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        JButton smoothBtn = new JButton("Smooth");
        smoothBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalEditorPanel.this.runSmoothing();
            }
        });
        toolbar.add(smoothBtn);
        this.minmaxBtn = new JButton("Min/Max");
        this.minmaxBtn.setEnabled(false);
        this.minmaxBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("detect significant min max");
                SignalEditorPanel.this.detectSignificantMinMax();
            }
        });
        toolbar.add(this.minmaxBtn);
        this.maxBtn = new JButton("Max");
        this.maxBtn.setEnabled(false);
        this.maxBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info("detect max");
                SignalEditorPanel.this.detectMax();
            }
        });
        toolbar.add(this.maxBtn);
        this.baseLineBtn = new JButton("Baseline");
        this.baseLineBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Tuple2> input = SignalEditorPanel.this.m_signal.toScalaArrayTuple(false);
                Tuple2[] rtIntPairs = input.toArray(new Tuple2[input.size()]);
                BaselineRemover baselineRemover = new BaselineRemover(1, 3);
                double threshold = baselineRemover.calcNoiseThreshold(rtIntPairs);
                logger.info("detected baseline at threshold " + threshold);
                LineMarker positionMarker = new LineMarker(SignalEditorPanel.this.m_plotPanel.getBasePlotPanel(), threshold, 0, Color.BLUE, true);
                SignalEditorPanel.this.m_linear.addMarker((AbstractMarker)positionMarker);
                SmartPeakelFinder peakelFinder = new SmartPeakelFinder(5, 3, 0.66f, false, 10, false, false, true);
                Tuple2[] indices = peakelFinder.findPeakelsIndices(rtIntPairs);
            }
        });
        toolbar.add(this.baseLineBtn);
        return toolbar;
    }

    private void runSmoothing() {
        SmoothingParamDialog dialog = new SmoothingParamDialog(WindowManager.getDefault().getMainWindow());
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String smoothMethod;
            List<Tuple2> input = this.m_signal.toScalaArrayTuple(false);
            int nbrPoints = dialog.getNbrPoint();
            if (nbrPoints == 0) {
                nbrPoints = Math.min(input.size() / 4, 9);
            }
            switch (smoothMethod = dialog.getMethod()) {
                case "Savitzky-Golay Smoother": {
                    logger.info("display smoothed signal, SG nb smoothing points = " + nbrPoints);
                    SavitzkyGolaySmoother sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    this.smooth(input, (ISignalSmoother)sgSmoother, "SG");
                    break;
                }
                case "Partial Savitzky-Golay Smoother": {
                    logger.info("display smoothed signal, Partial SG nb smoothing points = " + nbrPoints);
                    PartialSavitzkyGolaySmoother psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                    this.smooth(input, (ISignalSmoother)psgSmoother, "Partial SG");
                    break;
                }
                case "All Smoothers": {
                    logger.info("display smoothed signal, SG nb smoothing points = " + nbrPoints);
                    SavitzkyGolaySmoother sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 2, 1));
                    this.smooth(input, (ISignalSmoother)sgSmoother, "SG");
                    logger.info("display smoothed signal, Partial SG nb smoothing points = " + nbrPoints);
                    PartialSavitzkyGolaySmoother psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(nbrPoints, 4, 1));
                    this.smooth(input, (ISignalSmoother)psgSmoother, "Partial SG");
                }
            }
        }
    }

    private void addSmoothedSignal(Signal s, String title) {
        this.minmaxBtn.setEnabled(true);
        this.maxBtn.setEnabled(true);
        BasePlotPanel basePlot = this.m_plotPanel.getBasePlotPanel();
        SignalWrapper wrappedSignal = new SignalWrapper(s, "smoothed signal : " + title, CyclicColorPalette.getColor((int)((this.m_smoothedSignals.size() + 1) * 2)));
        PlotLinear linear = new PlotLinear(basePlot, (ExtendedTableModelInterface)wrappedSignal, null, 0, 1);
        linear.setPlotInformation(wrappedSignal.getPlotInformation());
        linear.setStrokeFixed(true);
        linear.setAntiAliasing(true);
        basePlot.addPlot((PlotXYAbstract)linear, true);
        basePlot.repaintUpdateDoubleBuffer();
        this.m_smoothedSignals.put(s, linear);
    }

    private void detectMax() {
        for (Map.Entry<Signal, PlotLinear> e : this.m_smoothedSignals.entrySet()) {
            Signal s = e.getKey();
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findMiniMaxi((double[])s.getYSeries());
            PlotLinear plot = e.getValue();
            for (int k = 0; k < mm.length; ++k) {
                if (!mm[k].isMaximum()) continue;
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(s.getXSeries()[mm[k].index()], s.getYSeries()[mm[k].index()]), plot.getPlotInformation().getPlotColor()));
            }
        }
        this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
    }

    private void detectSignificantMinMax() {
        for (Map.Entry<Signal, PlotLinear> e : this.m_smoothedSignals.entrySet()) {
            Signal s = e.getKey();
            DerivativeAnalysis.ILocalDerivativeChange[] mm = DerivativeAnalysis.findSignificantMiniMaxi((double[])s.getYSeries(), (int)3, (float)0.75f);
            for (int k = 0; k < mm.length; ++k) {
                PlotLinear plot = e.getValue();
                plot.addMarker((AbstractMarker)new PointMarker(this.m_plotPanel.getBasePlotPanel(), (AbstractCoordinates)new DataCoordinates(s.getXSeries()[mm[k].index()], s.getYSeries()[mm[k].index()]), plot.getPlotInformation().getPlotColor()));
            }
        }
        this.m_plotPanel.getBasePlotPanel().repaintUpdateDoubleBuffer();
    }

    private void smooth(List<Tuple2> xyPairs, ISignalSmoother smoother, String title) {
        logger.info("signal length before smoothing = " + xyPairs.size());
        Tuple2[] result = smoother.smoothTimeIntensityPairs(xyPairs.toArray(new Tuple2[xyPairs.size()]));
        logger.info("signal length after smoothing = " + result.length);
        double[] x = new double[result.length];
        double[] y = new double[result.length];
        for (int k = 0; k < result.length; ++k) {
            x[k] = (Double)result[k]._1;
            y[k] = (Double)result[k]._2;
        }
        Signal s = new Signal(x, y);
        this.addSmoothedSignal(s, title);
    }
}

