/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.IPrecursorComputation;
import fr.profi.mzdb.io.writer.mgf.IsolationWindowPrecursorExtractor;
import fr.profi.mzdb.io.writer.mgf.PrecursorMzComputationEnum;
import fr.proline.mzscope.model.IExportParameters;
import fr.proline.mzscope.ui.MgfExportParameters;
import fr.proline.mzscope.ui.ScanHeaderExportParameters;
import fr.proline.mzscope.ui.ScanHeaderType;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import fr.proline.studio.export.ExportDialog;
import fr.proline.studio.export.ExporterFactory;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportRawFileDialog
extends DefaultDialog {
    private static final String ISOLATION_WINDOW_PRECURSOR = "Proline refined precursor mz";
    private static ExportRawFileDialog singletonExportDialog = null;
    private IExportParameters.ExportType selectedExportType;
    private final JFileChooser fchooser;
    private JTextField fileTextField;
    private final List<FileNameExtensionFilter> filterList = new ArrayList<FileNameExtensionFilter>();
    private JComboBox exportTypeCombobox;
    private JPanel panelExportParams;
    private JPanel panelMgfParam;
    private JPanel panelScanHeaderParam;
    private JTextField mzTolField;
    private JComboBox precursorCombobox;
    private JTextField intensityCutoffField;
    private JCheckBox cbExportProlineTitle;
    private final String[] precursorList;
    private JComboBox scanHeaderCombobox;
    private final String[] scanHeaderList;
    private final Map<Integer, ScanHeaderType> mapScanHeader;
    private DefaultDialog.ProgressTask m_task;
    private float mzTolPPM = 10.0f;
    private IPrecursorComputation precComp = null;
    private float intensityCutoff = 0.0f;
    private boolean exportProlineTitle = false;
    private ScanHeaderType scanHeaderType = ScanHeaderType.MS2;
    private String outputFileName;

    public static ExportRawFileDialog getDialog(Window parent, String title) {
        if (singletonExportDialog == null) {
            singletonExportDialog = new ExportRawFileDialog(parent, title);
        }
        return singletonExportDialog;
    }

    private ExportRawFileDialog(Window parent, String title) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Export " + title);
        this.setDocumentationSuffix("id.nmf14n");
        EnumSet<PrecursorMzComputationEnum> precursorSet = EnumSet.allOf(PrecursorMzComputationEnum.class);
        this.precursorList = new String[precursorSet.size() + 1];
        int i = 0;
        for (PrecursorMzComputationEnum p : precursorSet) {
            this.precursorList[i] = p.getUserParamName();
            ++i;
        }
        this.precursorList[i] = ISOLATION_WINDOW_PRECURSOR;
        EnumSet<ScanHeaderType> scanHeaderSet = EnumSet.allOf(ScanHeaderType.class);
        this.scanHeaderList = new String[scanHeaderSet.size()];
        this.mapScanHeader = new HashMap<Integer, ScanHeaderType>();
        i = 0;
        for (ScanHeaderType s : scanHeaderSet) {
            this.scanHeaderList[i] = s.getName();
            this.mapScanHeader.put(i, s);
            ++i;
        }
        this.setInternalComponent(this.createExportPanel());
        this.setButtonName(0, "Export");
        this.fchooser = new JFileChooser();
        this.fchooser.setMultiSelectionEnabled(false);
        this.setExportParamsPanel();
    }

    private JPanel createExportPanel() {
        JPanel exportPanel = new JPanel();
        exportPanel.setLayout(new BorderLayout());
        JPanel panelType = new JPanel(new GridBagLayout());
        this.panelExportParams = new JPanel(new BorderLayout());
        this.panelMgfParam = this.createMgfParamPanel();
        this.panelScanHeaderParam = this.createScanHeaderParamPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.fileTextField = new JTextField(30);
        panelType.add((Component)this.fileTextField, c);
        final JButton addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        addFileButton.setMargin(new Insets(2, 2, 2, 2));
        addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                String textFile;
                ExporterFactory.ExporterInfo exporterInfo = (ExporterFactory.ExporterInfo)ExportRawFileDialog.this.exportTypeCombobox.getSelectedItem();
                if (exporterInfo != null) {
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(exporterInfo.getName(), exporterInfo.getFileExtension());
                    FileNameExtensionFilter existFilter = ExportDialog.getFilterWithSameExtensions((FileNameExtensionFilter)filter, (List)ExportRawFileDialog.this.filterList);
                    if (existFilter == null) {
                        ExportRawFileDialog.this.fchooser.addChoosableFileFilter(filter);
                        ExportRawFileDialog.this.filterList.add(filter);
                        ExportRawFileDialog.this.fchooser.setFileFilter(filter);
                    } else {
                        ExportRawFileDialog.this.fchooser.setFileFilter(existFilter);
                    }
                }
                if ((textFile = ExportRawFileDialog.this.fileTextField.getText().trim()).length() > 0) {
                    File currentFile = new File(textFile);
                    if (currentFile.isDirectory()) {
                        ExportRawFileDialog.this.fchooser.setCurrentDirectory(currentFile);
                    } else {
                        ExportRawFileDialog.this.fchooser.setSelectedFile(currentFile);
                    }
                }
                if ((result = ExportRawFileDialog.this.fchooser.showOpenDialog(addFileButton)) == 0) {
                    String fileName;
                    File file = ExportRawFileDialog.this.fchooser.getSelectedFile();
                    String absolutePath = file.getAbsolutePath();
                    if (!file.isDirectory() && (fileName = file.getName()).lastIndexOf(46) == -1) {
                        absolutePath = absolutePath + "." + exporterInfo.getFileExtension();
                    }
                    ExportRawFileDialog.this.fileTextField.setText(absolutePath);
                }
            }
        });
        c.gridx += 2;
        c.gridwidth = 1;
        panelType.add((Component)addFileButton, c);
        this.exportTypeCombobox = new JComboBox<Object>(ExporterFactory.getList((int)5).toArray());
        this.exportTypeCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExporterFactory.ExporterInfo exporterInfo = (ExporterFactory.ExporterInfo)ExportRawFileDialog.this.exportTypeCombobox.getSelectedItem();
                ExporterFactory.ExporterType type = exporterInfo.geType();
                if (type.equals((Object)ExporterFactory.ExporterType.MGF)) {
                    ExportRawFileDialog.this.selectedExportType = IExportParameters.ExportType.MGF;
                } else if (type.equals((Object)ExporterFactory.ExporterType.TSV)) {
                    ExportRawFileDialog.this.selectedExportType = IExportParameters.ExportType.SCAN_HEADER;
                }
                ExportRawFileDialog.this.setExportParamsPanel();
            }
        });
        this.exportTypeCombobox.setSelectedIndex(0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelType.add((Component)new JLabel("Export Type:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        panelType.add((Component)this.exportTypeCombobox, c);
        exportPanel.add((Component)panelType, "North");
        exportPanel.add((Component)this.panelExportParams, "Center");
        return exportPanel;
    }

    public void setSelectionMode(int mode) {
        File f;
        this.fchooser.setFileSelectionMode(mode);
        if (mode == 1 && !this.fileTextField.getText().trim().isEmpty() && !(f = new File(this.fileTextField.getText().trim())).isDirectory()) {
            this.fileTextField.setText(f.getParentFile().getAbsolutePath());
        }
    }

    public String getFileExtension() {
        ExporterFactory.ExporterInfo exporterInfo = (ExporterFactory.ExporterInfo)this.exportTypeCombobox.getSelectedItem();
        return exporterInfo.getFileExtension();
    }

    private void setExportParamsPanel() {
        this.panelExportParams.removeAll();
        String extension = "";
        ArrayList info = ExporterFactory.getList((int)5);
        ExporterFactory.ExporterInfo mgfInfo = null;
        ExporterFactory.ExporterInfo scanHeaderInfo = null;
        for (ExporterFactory.ExporterInfo i : info) {
            if (i.geType().equals((Object)ExporterFactory.ExporterType.MGF)) {
                mgfInfo = i;
                continue;
            }
            if (!i.geType().equals((Object)ExporterFactory.ExporterType.TSV)) continue;
            scanHeaderInfo = i;
        }
        switch (this.selectedExportType) {
            case MGF: {
                this.panelExportParams.add((Component)this.panelMgfParam, "Center");
                if (mgfInfo == null) break;
                extension = mgfInfo.getFileExtension();
                break;
            }
            case SCAN_HEADER: {
                this.panelExportParams.add((Component)this.panelScanHeaderParam, "Center");
                if (scanHeaderInfo == null) break;
                extension = scanHeaderInfo.getFileExtension();
                break;
            }
        }
        if (!this.fileTextField.getText().trim().isEmpty() && this.fchooser.getFileSelectionMode() != 1 && !this.fileTextField.getText().trim().endsWith("." + extension)) {
            String partialPath = this.fileTextField.getText().trim().substring(0, this.fileTextField.getText().trim().lastIndexOf(46));
            this.fileTextField.setText(partialPath + "." + extension);
        }
        this.panelExportParams.revalidate();
        this.panelExportParams.repaint();
    }

    private JPanel createMgfParamPanel() {
        JPanel panelMgf = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        panelMgf.add((Component)new JLabel("m/z tolerance (ppm):"), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.mzTolField = new JTextField();
        this.mzTolField.setText(Float.toString(MzScopePreferences.getInstance().getMzPPMTolerance()));
        panelMgf.add((Component)this.mzTolField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelMgf.add((Component)new JLabel("Precursor m/z computation:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.precursorCombobox = new JComboBox<String>(this.precursorList);
        this.precursorCombobox.setSelectedIndex(1);
        panelMgf.add((Component)this.precursorCombobox, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        panelMgf.add((Component)new JLabel("Intensity Cutoff:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.intensityCutoffField = new JTextField();
        this.intensityCutoffField.setText("0.0");
        panelMgf.add((Component)this.intensityCutoffField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.cbExportProlineTitle = new JCheckBox("Export Proline Title");
        this.cbExportProlineTitle.setSelected(false);
        panelMgf.add((Component)this.cbExportProlineTitle, c);
        return panelMgf;
    }

    private JPanel createScanHeaderParamPanel() {
        JPanel panelScanHeader = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        panelScanHeader.add((Component)new JLabel("Spectrum Header Level:"), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.scanHeaderCombobox = new JComboBox<String>(this.scanHeaderList);
        this.scanHeaderCombobox.setSelectedIndex(1);
        panelScanHeader.add((Component)this.scanHeaderCombobox, c);
        return panelScanHeader;
    }

    public void setTask(DefaultDialog.ProgressTask task) {
        this.m_task = task;
    }

    protected boolean cancelCalled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean okCalled() {
        String fileName = this.fileTextField.getText().trim();
        if (fileName.length() == 0) {
            this.setStatus(true, "You must fill the file name.");
            this.highlight(this.fileTextField);
            return false;
        }
        if (this.fchooser.getFileSelectionMode() != 1) {
            File mgfFile = new File(fileName);
            if (mgfFile.exists()) {
                String message = "The file already exists. Do you want to overwrite it ?";
                String title = "Overwrite ?";
                Object[] options = new String[]{"Yes", "No"};
                int reply = JOptionPane.showOptionDialog((Component)((Object)this), message, title, 0, 1, null, options, "Yes");
                if (reply != 0) {
                    this.setStatus(true, "File already exists.");
                    return false;
                }
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(mgfFile);
                fw.write("t");
            }
            catch (Exception e) {
                this.setStatus(true, fileName + " is not writable.");
                this.highlight(this.fileTextField);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    mgfFile.delete();
                }
                catch (Exception exception) {}
            }
        }
        File directory = new File(fileName);
        if (!directory.canWrite()) {
            this.setStatus(true, fileName + " is not writable.");
            this.highlight(this.fileTextField);
            return false;
        }
        this.outputFileName = fileName;
        boolean isOk = true;
        switch (this.selectedExportType) {
            case MGF: {
                isOk = this.checkMgfParams();
                break;
            }
            case SCAN_HEADER: {
                isOk = this.checkScanHeaderParams();
                break;
            }
        }
        if (!isOk) {
            return false;
        }
        this.startTask(this.m_task);
        return false;
    }

    private boolean checkMgfParams() {
        try {
            this.mzTolPPM = Float.parseFloat(this.mzTolField.getText());
        }
        catch (NumberFormatException e) {
            this.highlight(this.mzTolField);
            return false;
        }
        try {
            this.precComp = this.buildPrecursorComputer();
        }
        catch (Exception e) {
            this.highlight(this.precursorCombobox);
            return false;
        }
        try {
            this.intensityCutoff = Float.parseFloat(this.intensityCutoffField.getText());
        }
        catch (NumberFormatException e) {
            this.highlight(this.intensityCutoffField);
            return false;
        }
        this.exportProlineTitle = this.cbExportProlineTitle.isSelected();
        return true;
    }

    private IPrecursorComputation buildPrecursorComputer() {
        Object precComp = null;
        String item = (String)this.precursorCombobox.getSelectedItem();
        if (item.equals(ISOLATION_WINDOW_PRECURSOR)) {
            precComp = new IsolationWindowPrecursorExtractor(this.mzTolPPM);
        }
        EnumSet<PrecursorMzComputationEnum> precursorSet = EnumSet.allOf(PrecursorMzComputationEnum.class);
        for (PrecursorMzComputationEnum p : precursorSet) {
            if (!item.equals(p.getUserParamName())) continue;
            precComp = new DefaultPrecursorComputer(p, this.mzTolPPM);
            break;
        }
        return precComp;
    }

    private boolean checkScanHeaderParams() {
        try {
            this.scanHeaderType = this.mapScanHeader.get(this.scanHeaderCombobox.getSelectedIndex());
        }
        catch (Exception e) {
            this.highlight(this.scanHeaderCombobox);
            return false;
        }
        return true;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public IExportParameters getExportParams() {
        switch (this.selectedExportType) {
            case MGF: {
                MgfExportParameters mgfExport = new MgfExportParameters(this.precComp, this.mzTolPPM, this.intensityCutoff, this.exportProlineTitle);
                return mgfExport;
            }
            case SCAN_HEADER: {
                ScanHeaderExportParameters scanHeaderExport = new ScanHeaderExportParameters(this.scanHeaderType);
                return scanHeaderExport;
            }
        }
        return null;
    }
}

