/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.ui.dialog.MS1MzBoundsPanel;
import fr.proline.mzscope.ui.dialog.MS2MzBoundsPanel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;

public class ExtractionParamsDialog
extends JDialog {
    private static final String MS2 = "MS2";
    private static final String MS1 = "MS1";
    private FeaturesExtractionRequest.Builder extractionParams;
    private boolean showMS2Option;
    private JScrollPane scrollPane;
    private JPanel mainPanel;
    private JPanel mzBoundsCardPanel;
    private MS1MzBoundsPanel ms1MzBoundsPanel;
    private MS2MzBoundsPanel ms2MzBoundsPanel;
    private JComboBox msLevelCB;
    private JCheckBox removeBaselineCB;
    private JCheckBox useSmoothingCB;
    private JTextField intensityPercentileTF;
    private JTextField minPeaksCountTF;
    private JTextField minMaxDistanceTF;
    private JTextField minMaxRatioTF;
    private JTextField maxConsecutiveGapsTF;

    public ExtractionParamsDialog(Frame parent, boolean modal) {
        this(parent, modal, true);
    }

    public ExtractionParamsDialog(Frame parent, boolean modal, boolean showMS2Option) {
        super(parent, modal);
        this.showMS2Option = showMS2Option;
        this.initComponents();
        this.ms1MzBoundsPanel.getToleranceTF().setText(Float.toString(MzScopePreferences.getInstance().getMzPPMTolerance()));
        this.removeBaselineCB.setSelected(false);
        this.useSmoothingCB.setSelected(true);
        this.intensityPercentileTF.setText(Float.toString(0.9f));
        this.minMaxRatioTF.setText(Float.toString(0.75f));
        this.minMaxDistanceTF.setText(Integer.toString(3));
        this.minPeaksCountTF.setText(Integer.toString(5));
        this.maxConsecutiveGapsTF.setText(Integer.toString(3));
        this.pack();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrollPane(), "Center");
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getMainPanel());
            this.scrollPane.createVerticalScrollBar();
        }
        return this.scrollPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            if (this.showMS2Option) {
                this.mainPanel.add(this.getMsLevelPanel());
            }
            this.mainPanel.add(this.getConfigurationPanel());
            this.mainPanel.add(this.getMzBoundsPanel());
            this.mainPanel.add(this.getButtonPanel());
        }
        return this.mainPanel;
    }

    private JPanel getMsLevelPanel() {
        JPanel msLevelPanel = new JPanel();
        msLevelPanel.setLayout(new FlowLayout(3, 5, 5));
        JLabel label = new JLabel();
        label.setText("MS level: ");
        msLevelPanel.add(label);
        msLevelPanel.add(this.getMsLevelCB());
        return msLevelPanel;
    }

    private JComboBox getMsLevelCB() {
        if (this.msLevelCB == null) {
            String[] items = new String[]{MS1, MS2};
            this.msLevelCB = new JComboBox<String>(items);
            this.msLevelCB.addItemListener(e -> {
                CardLayout layout = (CardLayout)this.mzBoundsCardPanel.getLayout();
                layout.show(this.mzBoundsCardPanel, (String)e.getItem());
            });
        }
        return this.msLevelCB;
    }

    private JPanel getMzBoundsPanel() {
        if (this.mzBoundsCardPanel == null) {
            this.mzBoundsCardPanel = new JPanel();
            this.mzBoundsCardPanel.setLayout(new CardLayout());
            this.ms1MzBoundsPanel = new MS1MzBoundsPanel("Precursor mz");
            this.mzBoundsCardPanel.add(MS1, this.ms1MzBoundsPanel);
            this.ms2MzBoundsPanel = new MS2MzBoundsPanel();
            this.mzBoundsCardPanel.add(MS2, this.ms2MzBoundsPanel);
        }
        return this.mzBoundsCardPanel;
    }

    private JPanel getConfigurationPanel() {
        JPanel configurationPanel = new JPanel();
        configurationPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        JLabel label = new JLabel("Intensity percentile:");
        configurationPanel.add((Component)label, c);
        ++c.gridx;
        this.intensityPercentileTF = new JTextField(10);
        configurationPanel.add((Component)this.intensityPercentileTF, c);
        c.gridx = 0;
        ++c.gridy;
        label = new JLabel("min peaks count:");
        configurationPanel.add((Component)label, c);
        ++c.gridx;
        this.minPeaksCountTF = new JTextField(10);
        configurationPanel.add((Component)this.minPeaksCountTF, c);
        c.gridx = 0;
        ++c.gridy;
        label = new JLabel("max consecutive gaps:");
        configurationPanel.add((Component)label, c);
        ++c.gridx;
        this.maxConsecutiveGapsTF = new JTextField(10);
        configurationPanel.add((Component)this.maxConsecutiveGapsTF, c);
        c.gridx = 0;
        ++c.gridy;
        label = new JLabel("min/max distance (count):");
        configurationPanel.add((Component)label, c);
        ++c.gridx;
        this.minMaxDistanceTF = new JTextField(10);
        configurationPanel.add((Component)this.minMaxDistanceTF, c);
        c.gridx = 0;
        ++c.gridy;
        label = new JLabel("min/max ratio (0-1):");
        configurationPanel.add((Component)label, c);
        ++c.gridx;
        this.minMaxRatioTF = new JTextField(10);
        configurationPanel.add((Component)this.minMaxRatioTF, c);
        c.gridx = 0;
        ++c.gridy;
        this.removeBaselineCB = new JCheckBox();
        this.removeBaselineCB.setToolTipText("Remove peakels baseline during peakel detection");
        this.removeBaselineCB.setText("remove baseline");
        configurationPanel.add((Component)this.removeBaselineCB, c);
        ++c.gridx;
        this.useSmoothingCB = new JCheckBox();
        this.useSmoothingCB.setToolTipText("Use smoothing to find peakel local min/min");
        this.useSmoothingCB.setText("smooth peakels");
        configurationPanel.add((Component)this.useSmoothingCB, c);
        configurationPanel.setBorder(new TitledBorder("Processing Parameters"));
        return configurationPanel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1));
        JButton okBtn = new JButton();
        okBtn.setText("Ok");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionParamsDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.getRootPane().setDefaultButton(okBtn);
        buttonsPanel.add(okBtn);
        JButton cancelBtn = new JButton();
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtractionParamsDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        buttonsPanel.add(cancelBtn);
        return buttonsPanel;
    }

    public void setExtractionParamsTitle(String title) {
        this.setTitle(title);
    }

    public FeaturesExtractionRequest.Builder getExtractionParams() {
        return this.extractionParams;
    }

    public void showExtractionParamsDialog() {
        this.setVisible(true);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.extractionParams = FeaturesExtractionRequest.builder();
        if (!this.showMS2Option || this.getMsLevelCB().getSelectedItem().equals(MS1)) {
            try {
                this.extractionParams.setMzTolPPM(Float.parseFloat(this.ms1MzBoundsPanel.getToleranceTF().getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "tolerance value is incorrect: " + this.ms1MzBoundsPanel.getToleranceTF().getText());
                return;
            }
            try {
                this.extractionParams.setIntensityPercentile(Float.parseFloat(this.intensityPercentileTF.getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Intensity percentile value is incorrect: " + this.intensityPercentileTF.getText());
                return;
            }
            try {
                this.extractionParams.setMinPeaksCount(Integer.parseInt(this.minPeaksCountTF.getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Min peaks count value is incorrect: " + this.minPeaksCountTF.getText());
                return;
            }
            try {
                this.extractionParams.setMaxConsecutiveGaps(Integer.parseInt(this.maxConsecutiveGapsTF.getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Max consecutive gaps value is incorrect: " + this.maxConsecutiveGapsTF.getText());
                return;
            }
            try {
                this.extractionParams.setMinmaxDistanceThreshold(Integer.parseInt(this.minMaxDistanceTF.getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Min/max distance value is incorrect: " + this.minMaxDistanceTF.getText());
                return;
            }
            try {
                this.extractionParams.setMaxIntensityRelativeThreshold(Float.parseFloat(this.minMaxRatioTF.getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Min/max relative intensities ratio value is incorrect: " + this.minMaxRatioTF.getText());
                return;
            }
            try {
                this.extractionParams.setMinMz(this.ms1MzBoundsPanel.getMzBoundsRB().isSelected() ? Double.parseDouble(this.ms1MzBoundsPanel.getMinMzTF().getText()) : 0.0);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "min m/z value is incorrect: " + this.ms1MzBoundsPanel.getMinMzTF().getText());
                return;
            }
            try {
                this.extractionParams.setMaxMz(this.ms1MzBoundsPanel.getMzBoundsRB().isSelected() ? Double.parseDouble(this.ms1MzBoundsPanel.getMaxMzTF().getText()) : 0.0);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "max m/z value is incorrect: " + this.ms1MzBoundsPanel.getMaxMzTF().getText());
                return;
            }
            if (this.ms1MzBoundsPanel.getMzBoundsRB().isSelected() && this.extractionParams.getMinMz() > this.extractionParams.getMaxMz()) {
                JOptionPane.showMessageDialog(this, "The min m/z value must be lower than max m/z");
                return;
            }
            if (this.ms1MzBoundsPanel.getMzRB().isSelected()) {
                try {
                    double m = Double.parseDouble(this.ms1MzBoundsPanel.getMzTF().getText());
                    this.extractionParams.setMz(m);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "m/z value is incorrect: " + this.ms1MzBoundsPanel.getMzTF().getText());
                    return;
                }
            }
        }
        this.extractionParams.setRemoveBaseline(this.removeBaselineCB.isSelected());
        this.extractionParams.setUseSmoothing(this.useSmoothingCB.isSelected());
        this.extractionParams.setMsLevel(this.getMsLevelCB().getSelectedIndex() + 1);
        if (this.showMS2Option && this.getMsLevelCB().getSelectedItem().equals(MS2)) {
            this.ms2MzBoundsPanel.getExtractionParameters(this.extractionParams);
        }
        this.setVisible(false);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.extractionParams = null;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ExtractionParamsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final ExtractionParamsDialog dialog = new ExtractionParamsDialog((Frame)new JFrame(), true);
                dialog.setExtractionParamsTitle("Extraction Parameters");
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
                        if (builder != null) {
                            FeaturesExtractionRequest params = builder.build();
                            System.out.println(params.toString());
                        }
                        System.exit(0);
                    }
                });
                dialog.showExtractionParamsDialog();
                FeaturesExtractionRequest.Builder builder = dialog.getExtractionParams();
                if (builder != null) {
                    FeaturesExtractionRequest params = builder.build();
                    System.out.println(params.toString());
                }
                System.exit(0);
            }
        });
    }
}

