/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.mzscope.model.FeaturesExtractionRequest;
import fr.proline.mzscope.ui.dialog.MS1MzBoundsPanel;
import fr.proline.mzscope.ui.model.MzScopePreferences;
import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class MS2MzBoundsPanel
extends JPanel {
    private JTextField mzTF;
    private MS1MzBoundsPanel fragmentMzBoundsPanel;
    private JPanel tolerancePanel;
    private JTextField toleranceTF;

    public MS2MzBoundsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel innerPanel = new JPanel();
        innerPanel.setBorder(new TitledBorder("Precursor mz"));
        innerPanel.setLayout(new BoxLayout(innerPanel, 1));
        JPanel innerPanel2 = new JPanel();
        innerPanel2.setLayout(new FlowLayout(3));
        innerPanel2.add(new JLabel("Detect at m/z"));
        innerPanel2.add(this.getMzTF());
        innerPanel.add(this.getTolerancePanel());
        innerPanel.add(innerPanel2);
        this.add(innerPanel);
        this.fragmentMzBoundsPanel = new MS1MzBoundsPanel("Fragment mz");
        this.add(this.fragmentMzBoundsPanel);
        this.fragmentMzBoundsPanel.getToleranceTF().setText(Float.toString(MzScopePreferences.getInstance().getFragmentMzPPMTolerance()));
    }

    JTextField getMzTF() {
        if (this.mzTF == null) {
            this.mzTF = new JTextField();
            this.mzTF.setText("0.0");
            this.mzTF.setColumns(5);
        }
        return this.mzTF;
    }

    private JPanel getTolerancePanel() {
        if (this.tolerancePanel == null) {
            this.tolerancePanel = new JPanel();
            this.tolerancePanel.setLayout(new FlowLayout(0));
            JLabel toleranceLabel = new JLabel();
            toleranceLabel.setText("m/z tolerance (ppm):");
            this.tolerancePanel.add(toleranceLabel);
            this.tolerancePanel.add(this.getToleranceTF());
        }
        return this.tolerancePanel;
    }

    JTextField getToleranceTF() {
        if (this.toleranceTF == null) {
            this.toleranceTF = new JTextField();
            this.toleranceTF.setColumns(5);
            this.toleranceTF.setToolTipText("Tolerance in ppm");
            this.toleranceTF.setText(Float.toString(MzScopePreferences.getInstance().getMzPPMTolerance()));
        }
        return this.toleranceTF;
    }

    void getExtractionParameters(FeaturesExtractionRequest.Builder extractionParams) {
        try {
            extractionParams.setMzTolPPM(Float.parseFloat(this.getToleranceTF().getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "tolerance value is incorrect: " + this.getToleranceTF().getText());
            return;
        }
        try {
            extractionParams.setMz(Double.parseDouble(this.getMzTF().getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "m/z value is incorrect: " + this.getMzTF().getText());
            return;
        }
        try {
            extractionParams.setFragmentMzTolPPM(Float.parseFloat(this.fragmentMzBoundsPanel.getToleranceTF().getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "tolerance value is incorrect: " + this.fragmentMzBoundsPanel.getToleranceTF().getText());
            return;
        }
        try {
            extractionParams.setFragmentMinMz(this.fragmentMzBoundsPanel.getMzBoundsRB().isSelected() ? Double.parseDouble(this.fragmentMzBoundsPanel.getMinMzTF().getText()) : 0.0);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "min m/z value is incorrect: " + this.fragmentMzBoundsPanel.getMinMzTF().getText());
            return;
        }
        try {
            extractionParams.setFragmentMaxMz(this.fragmentMzBoundsPanel.getMzBoundsRB().isSelected() ? Double.parseDouble(this.fragmentMzBoundsPanel.getMaxMzTF().getText()) : 0.0);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "max m/z value is incorrect: " + this.fragmentMzBoundsPanel.getMaxMzTF().getText());
            return;
        }
        if (this.fragmentMzBoundsPanel.getMzBoundsRB().isSelected() && extractionParams.getFragmentMinMz() > extractionParams.getFragmentMaxMz()) {
            JOptionPane.showMessageDialog(this, "The min m/z value must be lower than max m/z");
            return;
        }
        if (this.fragmentMzBoundsPanel.getMzRB().isSelected()) {
            try {
                extractionParams.setFragmentMz(Double.parseDouble(this.fragmentMzBoundsPanel.getMzTF().getText()));
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "m/z value is incorrect: " + this.fragmentMzBoundsPanel.getMzTF().getText());
                return;
            }
        }
    }
}

