/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.dialog;

import fr.proline.studio.gui.DefaultDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.swingx.JXComboBox;

public class SmoothingParamDialog
extends DefaultDialog {
    JTextField m_nbrPoint;
    JComboBox m_smoothingMethods;
    public static final String PARTIAL_SG_SMOOTHER = "Partial Savitzky-Golay Smoother";
    public static final String SG_SMOOTHER = "Savitzky-Golay Smoother";
    public static final String BOTH_SMOOTHER = "All Smoothers";
    String[] methods = new String[]{"Partial Savitzky-Golay Smoother", "Savitzky-Golay Smoother", "All Smoothers"};

    public SmoothingParamDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Smooting parameters ");
        this.setInternalComponent(this.createInternalPanel());
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel nbrPointLabel = new JLabel("Number of points ");
        internalPanel.add((Component)nbrPointLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_nbrPoint = new JTextField(10);
        this.m_nbrPoint.setText("5");
        this.m_nbrPoint.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '\b' && c != '\u007f') {
                    SmoothingParamDialog.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        internalPanel.add((Component)this.m_nbrPoint, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        JLabel methodsLabel = new JLabel("Smoothing method ");
        internalPanel.add((Component)methodsLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.m_smoothingMethods = new JXComboBox((Object[])this.methods);
        this.m_smoothingMethods.setSelectedItem(SG_SMOOTHER);
        internalPanel.add((Component)this.m_smoothingMethods, c);
        return internalPanel;
    }

    public int getNbrPoint() {
        return Integer.valueOf(this.m_nbrPoint.getText());
    }

    public String getMethod() {
        return this.m_smoothingMethods.getSelectedItem().toString();
    }
}

