/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.mzscope.ui.peakels;

import fr.proline.mzscope.model.IFeature;
import fr.proline.mzscope.ui.IMzScopeController;
import fr.proline.mzscope.ui.peakels.FeaturesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DetectedFeaturesPanel
extends JPanel {
    private FeaturesPanel featuresPanel;
    private FeaturesPanel invalidFeaturesPanel;

    public DetectedFeaturesPanel(IMzScopeController controller) {
        this.featuresPanel = new FeaturesPanel(controller);
        this.invalidFeaturesPanel = new FeaturesPanel(controller);
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane(3);
        tabbedPane.add("Detected features", this.featuresPanel);
        tabbedPane.add("Invalid features", this.invalidFeaturesPanel);
        this.add((Component)tabbedPane, "Center");
    }

    public void addFeatures(List<IFeature> features) {
        Map<Boolean, List<IFeature>> list = features.stream().collect(Collectors.partitioningBy(f -> f.getPeakelsCount() > 1));
        this.featuresPanel.addFeatures(list.get(Boolean.TRUE));
        this.invalidFeaturesPanel.addFeatures(list.get(Boolean.FALSE));
    }

    public void setFeatures(List<IFeature> features, boolean displayRawFileColumn) {
        Map<Boolean, List<IFeature>> list = features.stream().collect(Collectors.partitioningBy(f -> f.getPeakelsCount() > 1));
        this.featuresPanel.setFeatures(list.get(Boolean.TRUE), displayRawFileColumn);
        this.invalidFeaturesPanel.setFeatures(list.get(Boolean.FALSE), displayRawFileColumn);
    }
}

