/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.installer;

import fr.proline.studio.dam.taskinfo.TaskInfoManager;
import fr.proline.studio.dpm.ServerConnectionManager;
import fr.proline.studio.dpm.task.util.JMSConnectionManager;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.installer.VersionInstaller;
import fr.proline.studio.rserver.RServerManager;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.openide.windows.WindowManager;

public class Installer
extends VersionInstaller {
    public void restored() {
        boolean isSnapshot;
        String s = System.getProperty("netbeans.user");
        StringBuilder sb = new StringBuilder(s);
        if (s != null && !s.isEmpty()) {
            sb.append(File.separator).append("/var/cache");
        }
        File f = new File(sb.toString());
        try {
            boolean clean = false;
            if (f.exists() && f.isDirectory()) {
                FileUtils.cleanDirectory(f);
                clean = true;
            }
        }
        catch (IOException clean) {
            // empty catch block
        }
        this.forceMetalUIForMac();
        String productVersion = "2.1.2";
        int snapIndex = "2.1.2".toLowerCase().indexOf("-snapshot");
        boolean bl = isSnapshot = snapIndex > 0;
        if (snapIndex > 0) {
            productVersion = "2.1.2".substring(0, snapIndex);
        }
        String buildnumber = isSnapshot ? productVersion + " Milestone 2 (" + "2021-06-29T08:47:46Z_jenkins" + ")" : productVersion;
        System.setProperty("netbeans.buildnumber", buildnumber);
        ServerConnectionManager.getServerConnectionManager();
    }

    private void forceMetalUIForMac() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.contains("mac")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        Frame f = WindowManager.getDefault().getMainWindow();
                        if (f == null) {
                            Installer.this.forceMetalUIForMac();
                        } else {
                            SwingUtilities.updateComponentTreeUI(f);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public boolean closing() {
        if (TaskInfoManager.getTaskInfoManager().askBeforeExitingApp()) {
            InfoDialog exitDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Warning", "You should not exit. Important tasks are being done.\nAre you sure you want to exit ?");
            exitDialog.setButtonName(0, "Yes");
            exitDialog.setButtonName(1, "No");
            exitDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
            exitDialog.setVisible(true);
            if (exitDialog.getButtonClicked() == 1) {
                return false;
            }
        }
        RServerManager.getRServerManager().stopRProcess();
        JMSConnectionManager.getJMSConnectionManager().closeConnection();
        return true;
    }
}

