/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtility {
    private static final Logger logger = LoggerFactory.getLogger((String)"FileUtil");

    public static boolean deleteFile(File f) {
        try {
            Files.delete(f.toPath());
        }
        catch (NoSuchFileException x) {
            logger.error("Trying to delete file " + f.getAbsolutePath() + ", which does not exist!", (Throwable)x);
            return false;
        }
        catch (DirectoryNotEmptyException x) {
            logger.error("Directory " + f.getAbsolutePath() + " is not empty!", (Throwable)x);
            return false;
        }
        catch (IOException x) {
            logger.error("You do not have the right to delete: " + f.toPath().toString() + "!", (Throwable)x);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompletelyWritten(File file) {
        RandomAccessFile stream = null;
        try {
            stream = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.debug("Skipping file " + file.getName() + " for this iteration due it's not completely written");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.error("Exception during closing file " + file.getName());
                }
            }
        }
        return false;
    }
}

