/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.msfiles.FileToTransfer;
import fr.proline.studio.msfiles.MzdbDownloadBatch;
import fr.proline.studio.rsmexplorer.MzdbFilesTopComponent;
import fr.proline.studio.rsmexplorer.gui.LocalFileSystemTransferHandler;
import fr.proline.studio.rsmexplorer.gui.LocalFileSystemView;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserPanel;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTransferHandler;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;

public class MsFilesExplorer
extends JPanel {
    private final TreeFileChooserPanel m_tree;
    private final TreeFileChooserTransferHandler m_transferHandler;
    private final LocalFileSystemView m_localFileSystemView;
    private boolean m_downAllowed = false;
    private boolean m_upAllowed = false;

    public MsFilesExplorer() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_localFileSystemView = new LocalFileSystemView(new LocalFileSystemTransferHandler(), true);
        this.add((Component)this.m_localFileSystemView, c);
        TransferFileButtonsPanel transferPanel = new TransferFileButtonsPanel();
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)transferPanel, c);
        this.m_transferHandler = new TreeFileChooserTransferHandler();
        this.m_transferHandler.addComponent(this.m_localFileSystemView);
        this.m_tree = new TreeFileChooserPanel((FileSystemView)ServerFileSystemView.getServerFileSystemView(), this.m_transferHandler, true);
        this.m_tree.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Proline Server File System"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ++c.gridy;
        c.weighty = 1.0;
        this.add((Component)this.m_tree, c);
        this.m_tree.setFileSelectionListener(transferPanel);
        this.m_localFileSystemView.setFileSelectionListener(transferPanel);
    }

    public TreeFileChooserPanel getTreeFileChooserPanel() {
        return this.m_tree;
    }

    public LocalFileSystemView getLocalFileSystemView() {
        return this.m_localFileSystemView;
    }

    public class TransferFileButtonsPanel
    extends JPanel
    implements FileSelectionInterface {
        private final JButton m_downButton;
        private final JButton m_upButton;
        private ArrayList<FileToTransfer> m_filesUp = null;
        private ArrayList<FileToTransfer> m_directoriesUp = null;
        private ArrayList<FileToTransfer> m_parentDirectoriesUp = null;
        private ArrayList<FileToTransfer> m_filesDown = null;
        private ArrayList<FileToTransfer> m_directoriesDown = null;
        private ArrayList<FileToTransfer> m_parentDirectoriesDown = null;

        public TransferFileButtonsPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            this.add(Box.createHorizontalGlue(), c);
            this.m_downButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_DOWN_BIG));
            this.m_downButton.setMargin(new Insets(2, 2, 2, 2));
            ++c.gridx;
            c.weightx = 0.0;
            this.add((Component)this.m_downButton, c);
            ++c.gridx;
            this.add(Box.createHorizontalStrut(10));
            this.m_upButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_MOVE_UP_BIG));
            this.m_upButton.setMargin(new Insets(2, 2, 2, 2));
            ++c.gridx;
            this.add((Component)this.m_upButton, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.add(Box.createHorizontalGlue(), c);
            this.m_upButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TransferFileButtonsPanel.this.m_filesDown == null) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_upButton, "You must select from the Proline Server File System to download them to the Local File System.", "Upload Error", 2);
                        return;
                    }
                    if (!TransferFileButtonsPanel.this.m_directoriesDown.isEmpty()) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_upButton, "Downloading a directory from the Proline Server File System to the Local File System is not allowed.", "Upload Error", 2);
                        return;
                    }
                    if (TransferFileButtonsPanel.this.m_filesDown.isEmpty()) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_upButton, "You must select files from the Proline Server File System to download to the Local File System.", "Upload Error", 2);
                        return;
                    }
                    if (TransferFileButtonsPanel.this.m_directoriesUp == null || (TransferFileButtonsPanel.this.m_directoriesUp.size() != 1 || !TransferFileButtonsPanel.this.m_filesUp.isEmpty()) && TransferFileButtonsPanel.this.m_parentDirectoriesUp.size() != 1) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_upButton, "You must select a directory of the Local File System where the files will be downloaded.", "Upload Error", 2);
                        return;
                    }
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (FileToTransfer f : TransferFileButtonsPanel.this.m_filesDown) {
                        fileList.add(f.getFile());
                    }
                    TreePath path = !TransferFileButtonsPanel.this.m_parentDirectoriesUp.isEmpty() ? ((FileToTransfer)TransferFileButtonsPanel.this.m_parentDirectoriesUp.get(0)).getPath() : ((FileToTransfer)TransferFileButtonsPanel.this.m_directoriesUp.get(0)).getPath();
                    MzdbDownloadBatch downloadBatch = new MzdbDownloadBatch(fileList, path, MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().getSelectedRoot());
                    Thread downloadThread = new Thread(downloadBatch);
                    downloadThread.start();
                }
            });
            this.m_downButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path;
                    if (TransferFileButtonsPanel.this.m_filesUp == null) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_downButton, "You must select .dat .mzdb .raw or .wiff files from the Local File System to upload them to the Server.", "Upload Error", 2);
                        return;
                    }
                    if (!TransferFileButtonsPanel.this.m_directoriesUp.isEmpty()) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_downButton, "Uploading a directory from the Local File System to the Server is not allowed.", "Upload Error", 2);
                        return;
                    }
                    if (TransferFileButtonsPanel.this.m_filesUp.isEmpty()) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_downButton, "You must select .dat .mzdb .raw or .wiff files from the Local File System to upload to the Server.", "Upload Error", 2);
                        return;
                    }
                    if (TransferFileButtonsPanel.this.m_directoriesDown == null || (TransferFileButtonsPanel.this.m_directoriesDown.size() != 1 || !TransferFileButtonsPanel.this.m_filesDown.isEmpty()) && TransferFileButtonsPanel.this.m_parentDirectoriesDown.size() != 1) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_downButton, "You must select a directory of the Proline Server File System where the files will be uploaded.", "Upload Error", 2);
                        return;
                    }
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (FileToTransfer f : TransferFileButtonsPanel.this.m_filesUp) {
                        fileList.add(f.getFile());
                    }
                    TreePath treePath = path = !TransferFileButtonsPanel.this.m_parentDirectoriesDown.isEmpty() ? ((FileToTransfer)TransferFileButtonsPanel.this.m_parentDirectoriesDown.get(0)).getPath() : ((FileToTransfer)TransferFileButtonsPanel.this.m_directoriesDown.get(0)).getPath();
                    if (!MsFilesExplorer.this.m_transferHandler.treeTransfer(fileList, path)) {
                        JOptionPane.showMessageDialog(TransferFileButtonsPanel.this.m_downButton, "You can not transfer selected file(s) to the selected directory.");
                    }
                }
            });
        }

        @Override
        public void upSelectionChanged(ArrayList<FileToTransfer> files, ArrayList<FileToTransfer> directories, ArrayList<FileToTransfer> parentDirectory) {
            this.m_filesUp = files;
            this.m_directoriesUp = directories;
            this.m_parentDirectoriesUp = parentDirectory;
        }

        @Override
        public void downSelectionChanged(ArrayList<FileToTransfer> files, ArrayList<FileToTransfer> directories, ArrayList<FileToTransfer> parentDirectory) {
            this.m_filesDown = files;
            this.m_directoriesDown = directories;
            this.m_parentDirectoriesDown = parentDirectory;
        }
    }

    public static interface FileSelectionInterface {
        public void upSelectionChanged(ArrayList<FileToTransfer> var1, ArrayList<FileToTransfer> var2, ArrayList<FileToTransfer> var3);

        public void downSelectionChanged(ArrayList<FileToTransfer> var1, ArrayList<FileToTransfer> var2, ArrayList<FileToTransfer> var3);
    }
}

