/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.openide.util.Exceptions;

public class WorkingSetUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJSON() {
        File baseLocationFile = new File(".");
        String canonicalPath = null;
        try {
            canonicalPath = baseLocationFile.getCanonicalPath();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        File jsonFile = new File(canonicalPath + File.separator + "working_sets.json");
        if (jsonFile.exists()) {
            JSONObject jsonObject = null;
            InputStreamReader reader = null;
            try {
                reader = new FileReader(canonicalPath + File.separator + "working_sets.json");
                JSONParser jsonParser = new JSONParser();
                jsonObject = (JSONObject)jsonParser.parse((Reader)reader);
            }
            catch (FileNotFoundException ex) {
                JSONObject jSONObject = WorkingSetUtil.saveJSON(null);
                return jSONObject;
            }
            catch (IOException | ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                JSONObject jSONObject = WorkingSetUtil.saveJSON(null);
                return jSONObject;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return jsonObject;
        }
        return WorkingSetUtil.saveJSON(null);
    }

    public static JSONObject saveJSON(JSONArray array) {
        File baseLocationFile = new File(".");
        String canonicalPath = null;
        try {
            canonicalPath = baseLocationFile.getCanonicalPath();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        JSONObject obj = new JSONObject();
        if (array != null) {
            obj.put((Object)"working_sets", (Object)array);
        } else {
            obj.put((Object)"working_sets", (Object)new JSONArray());
        }
        try (FileWriter file = new FileWriter(canonicalPath + File.separator + File.separator + "working_sets.json");){
            file.write(obj.toJSONString());
            file.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static File getTempDirectory() {
        File baseLocationFile = new File(".");
        String canonicalPath = null;
        try {
            canonicalPath = baseLocationFile.getCanonicalPath();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        File tempDir = new File(canonicalPath + File.separator + "mzdb_temp");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        return tempDir;
    }
}

