/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataParameter;
import fr.proline.studio.pattern.ParameterList;
import java.util.ArrayList;
import java.util.HashMap;

public class AvailableParameters {
    private HashMap<DataParameter, Integer> m_availableParametersMap;

    public AvailableParameters(AbstractDataBox box) {
        this.initAvailableParameters(box);
    }

    public HashMap<DataParameter, Integer> getParametersMap() {
        return this.m_availableParametersMap;
    }

    private void initAvailableParameters(AbstractDataBox box) {
        this.m_availableParametersMap = new HashMap();
        this.initAvailableParameters(box, 0);
    }

    private void initAvailableParameters(AbstractDataBox box, Integer depth) {
        ParameterList outParameters = box.getOutParameters();
        ArrayList<DataParameter> parameterList = outParameters.getParameterList();
        for (int j = 0; j < parameterList.size(); ++j) {
            this.m_availableParametersMap.put(parameterList.get(j), depth);
        }
        AbstractDataBox previousDataBox = box.m_previousDataBox;
        if (previousDataBox != null) {
            this.initAvailableParameters(previousDataBox, depth + 1);
        }
    }

    public double calculateParameterCompatibilityDistance(AbstractDataBox box, Class compulsoryInParameterClass) {
        ParameterList inParameters = box.getInParameters();
        boolean foundCompulsoryInParameter = compulsoryInParameterClass == null;
        double minAverageDistance = -1.0;
        ArrayList<DataParameter> parameterList = inParameters.getParameterList();
        int distanceCur = 0;
        for (int i = 0; i < parameterList.size(); ++i) {
            DataParameter parameter = parameterList.get(i);
            if (!foundCompulsoryInParameter && compulsoryInParameterClass != null) {
                Class parameterClass = parameter.getParameterClass();
                foundCompulsoryInParameter = parameterClass.equals(compulsoryInParameterClass);
            }
            if (!parameter.isCompulsory()) continue;
            Integer distanceCurI = this.m_availableParametersMap.get(parameter);
            if (distanceCurI == null) {
                distanceCur = -1;
                break;
            }
            distanceCur += distanceCurI.intValue();
        }
        if (distanceCur >= 0) {
            double averageDistanceCur = (double)distanceCur / (double)parameterList.size();
            if (minAverageDistance < 0.0) {
                minAverageDistance = averageDistanceCur;
            } else if (minAverageDistance > averageDistanceCur) {
                minAverageDistance = averageDistanceCur;
            }
        }
        if (!foundCompulsoryInParameter) {
            return -1.0;
        }
        return minAverageDistance;
    }
}

