/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.id.ProjectId;
import fr.proline.studio.pattern.DataboxDataAnalyzer;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.gui.calc.DataAnalyzerPanel;
import fr.proline.studio.table.TableInfo;

public class DataAnalyzerWindowBoxManager {
    private static WindowBox m_windowBox = null;
    private static DataBoxViewerTopComponent m_win = null;

    public static void addTableInfo(TableInfo tableInfo) {
        if (m_windowBox == null) {
            m_windowBox = WindowBoxFactory.getDataAnalyzerWindowBox();
            if (tableInfo != null) {
                GlobalTableModelInterface model = tableInfo.getModel();
                ProjectId projectId = (ProjectId)model.getSingleValue(ProjectId.class);
                long id = projectId != null ? projectId.getId() : -1L;
                m_windowBox.setEntryData(id, tableInfo);
            }
            m_win = new DataBoxViewerTopComponent(m_windowBox);
            m_win.open();
            m_win.requestActive();
        } else {
            DataboxDataAnalyzer analyzer;
            if (m_windowBox.getEntryBox() instanceof DataboxDataAnalyzer && (analyzer = (DataboxDataAnalyzer)m_windowBox.getEntryBox()).getPanel() instanceof DataAnalyzerPanel) {
                DataAnalyzerPanel panel = (DataAnalyzerPanel)analyzer.getPanel();
                panel.resetViewpoint();
            }
            if (tableInfo != null) {
                GlobalTableModelInterface model = tableInfo.getModel();
                ProjectId projectId = (ProjectId)model.getSingleValue(ProjectId.class);
                long id = projectId != null ? projectId.getId() : -1L;
                m_windowBox.setEntryData(id, tableInfo);
            }
            if (m_win.isOpened()) {
                m_win.requestActive();
            } else {
                m_win = new DataBoxViewerTopComponent(m_windowBox);
                m_win.open();
                m_win.requestActive();
            }
        }
    }

    public static void openDataAnalyzer() {
        DataAnalyzerWindowBoxManager.addTableInfo(null);
    }

    public static void updateToFreeMemory() {
        DataboxDataAnalyzer analyzer;
        if (m_windowBox == null) {
            return;
        }
        if (m_windowBox.getEntryBox() instanceof DataboxDataAnalyzer && (analyzer = (DataboxDataAnalyzer)m_windowBox.getEntryBox()).getPanel() instanceof DataAnalyzerPanel) {
            DataAnalyzerPanel panel = (DataAnalyzerPanel)analyzer.getPanel();
            panel.getDataAnalyzerTree().updataDataNodes();
        }
    }
}

