/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DPeptideSet;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinsAndPeptidesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.LightPeptideMatch;
import fr.proline.studio.dam.tasks.data.LightProteinMatch;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.Component;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.DrawVisualization;
import fr.proline.studio.rsmexplorer.adjacencymatrix.visualize.MatrixPanel;
import java.util.ArrayList;
import java.util.HashMap;

public class DataBoxAdjacencyMatrix
extends AbstractDataBox {
    public static final String DESCRIPTION = "Proteins Adjacency Matrix";
    private Long m_previousTaskId = null;

    public DataBoxAdjacencyMatrix() {
        super(AbstractDataBox.DataboxType.DataBoxAdjacencyMatrix, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = DESCRIPTION;
        this.m_description = DESCRIPTION;
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        inParameter.addParameter(DrawVisualization.class);
        inParameter.addParameter(Component.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(DPeptideInstance.class);
        outParameter.addParameter(DProteinMatch.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        MatrixPanel p = new MatrixPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSummary _rsm = (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)_rsm);
        final Component component = (Component)this.getData(Component.class);
        final DrawVisualization drawVisualization = (DrawVisualization)this.getData(DrawVisualization.class);
        ArrayList<LightProteinMatch> proteinMatchArray = component.getProteinArray(true);
        ArrayList<LightPeptideMatch> peptideMatchArray = component.getPeptideArray();
        int nbProteins = proteinMatchArray.size();
        ArrayList<Long> proteinMatchIdArray = new ArrayList<Long>(nbProteins);
        for (int i = 0; i < nbProteins; ++i) {
            proteinMatchIdArray.add(proteinMatchArray.get(i).getId());
        }
        int nbPeptides = peptideMatchArray.size();
        ArrayList<Long> peptideMatchIdArray = new ArrayList<Long>(nbPeptides);
        for (int i = 0; i < nbPeptides; ++i) {
            peptideMatchIdArray.add(peptideMatchArray.get(i).getId());
        }
        final HashMap proteinMap = new HashMap();
        final HashMap peptideMap = new HashMap();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ((MatrixPanel)DataBoxAdjacencyMatrix.this.getDataBoxPanelInterface()).setData(component, drawVisualization, proteinMap, peptideMap, _rsm.getId());
                DataBoxAdjacencyMatrix.this.unregisterTask(taskId);
            }
        };
        DatabaseProteinsAndPeptidesTask task = new DatabaseProteinsAndPeptidesTask(callback, this.getProjectId(), _rsm, proteinMatchIdArray, peptideMatchIdArray, proteinMap, peptideMap);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((MatrixPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(DProteinMatch.class)) {
                return ((MatrixPanel)this.getDataBoxPanelInterface()).getSelectedProteinMatch();
            }
            if (parameterType.equals(DPeptideInstance.class)) {
                DPeptideSet peptideSet;
                DPeptideInstance[] peptideInstances;
                ResultSummary rsm;
                DPeptideMatch peptideMatch = ((MatrixPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
                DProteinMatch pm = ((MatrixPanel)this.getDataBoxPanelInterface()).getSelectedProteinMatch();
                if (pm != null && peptideMatch != null && (rsm = (ResultSummary)this.getData(ResultSummary.class)) != null && (peptideInstances = (peptideSet = pm.getPeptideSet(Long.valueOf(rsm.getId()))).getPeptideInstances()) != null) {
                    for (DPeptideInstance peptideInstance : peptideInstances) {
                        if (peptideInstance.getPeptideId() != peptideMatch.getPeptide().getId()) continue;
                        return peptideInstance;
                    }
                }
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

