/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.msfiles.WorkingSetView;
import fr.proline.studio.mzscope.MzScopeInterface;
import fr.proline.studio.mzscope.MzdbInfo;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.StudioMzScopePanel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class DataBoxMzScope
extends AbstractDataBox {
    public static final String MZDB_DIRECTORY_KEY = "mzdbDirectory";
    private MzScopeInterface mzScope = null;
    private String m_mzdbDir;

    public DataBoxMzScope() {
        super(AbstractDataBox.DataboxType.DataBoxMzScope, AbstractDataBox.DataboxStyle.STYLE_UNKNOWN);
        this.m_typeName = "MzScope";
        this.m_description = "MzScope";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(File.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        StudioMzScopePanel p = new StudioMzScopePanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.mzScope = (MzScopeInterface)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            // empty if block
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        return this.m_typeName;
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask != null) {
                    ((StudioMzScopePanel)DataBoxMzScope.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxMzScope.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxMzScope.this.unregisterTask(taskId);
                    DataBoxMzScope.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxMzScope.this.propagateDataChanged();
                }
            }
        };
        List mzdbInfos = this.mzScope.getMzdbInfo();
        ArrayList<MzdbInfo> infos = new ArrayList<MzdbInfo>();
        for (MzdbInfo mzdbInfo : mzdbInfos) {
            String f = mzdbInfo.getFileName();
            if (f != null) {
                File file = this.findFile(f);
                if (!file.exists()) continue;
                mzdbInfo.setFile(file);
                infos.add(mzdbInfo);
                continue;
            }
            infos.add(mzdbInfo);
        }
        ((StudioMzScopePanel)this.getDataBoxPanelInterface()).setData(-1L, infos, true);
        this.setLoaded(loadingId);
    }

    private File findFile(String f) {
        HashMap<String, JSONObject> map = WorkingSetView.getWorkingSetView().getModel().getEntiesObjects();
        for (Map.Entry entry : map.entrySet()) {
            String filename = (String)((JSONObject)entry.getValue()).get((Object)"filename");
            String location = (String)((JSONObject)entry.getValue()).get((Object)"location");
            if (!filename.equalsIgnoreCase(f) || !location.equalsIgnoreCase("LOCAL")) continue;
            String path = (String)((JSONObject)entry.getValue()).get((Object)"path");
            return new File(path);
        }
        return new File(this.m_mzdbDir + File.separator + f);
    }
}

