/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseRsetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.actions.identification.ImportSearchResultAsRsetJMSAction;
import fr.proline.studio.rsmexplorer.gui.RsetAllPanel;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;

public class DataBoxRsetAll
extends AbstractDataBox {
    private Project m_project = null;

    public DataBoxRsetAll() {
        super(AbstractDataBox.DataboxType.DataBoxRsetAll, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Search Results";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(Project.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ResultSet.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsetAllPanel p = new RsetAllPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        Project p = this.m_project != null ? this.m_project : (Project)this.getData(Project.class);
        final ArrayList resultSetArrayList = new ArrayList();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ((RsetAllPanel)DataBoxRsetAll.this.getDataBoxPanelInterface()).setData(taskId, resultSetArrayList);
                DataBoxRsetAll.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsetAll.this.unregisterTask(taskId);
                }
            }
        };
        DatabaseRsetTask task = new DatabaseRsetTask(callback, p.getId(), resultSetArrayList);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA && parameterType.equals(ResultSet.class)) {
            return ((RsetAllPanel)this.getDataBoxPanelInterface()).getSelectedResultSet();
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_project = (Project)data;
        this.dataChanged();
        ImportSearchResultAsRsetJMSAction.addEventListener(this.m_project.getId(), this);
    }

    @Override
    public void windowClosed() {
        ImportSearchResultAsRsetJMSAction.removeEventListener(this.m_project.getId(), this);
        super.windowClosed();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.dataChanged();
    }
}

