/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.GenerateMSDiagReportTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBoxRsetMSDiag
extends AbstractDataBox {
    public HashMap<String, String> m_message_back = null;
    public ArrayList<Object> m_messages_back = new ArrayList(2);
    private ResultSet m_rset = null;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public DataBoxRsetMSDiag(HashMap<String, String> resultMessageHashMap) {
        super(AbstractDataBox.DataboxType.DataboxRsetMSDiag, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Statistics";
        this.m_description = "Statistical results";
        this.m_messages_back.add(resultMessageHashMap);
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSet.class);
        this.registerInParameter(inParameter);
    }

    @Override
    public void createPanel() {
        RsetMSDiagPanel p = new RsetMSDiagPanel("please wait, retreiving data from server...");
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final int loadingId = this.setLoading(true);
        ResultSet _rset = this.m_rset != null ? this.m_rset : (ResultSet)this.getData(ResultSet.class);
        this.linkCache((TransientDataInterface)_rset);
        long rSetId = _rset.getId();
        HashMap<String, String> parameters = new HashMap<String, String>();
        String scoreWindow = (String)((HashMap)this.m_messages_back.get(0)).get("score.windows");
        parameters.put("Score window", scoreWindow);
        String maxRank = (String)((HashMap)this.m_messages_back.get(0)).get("max.rank");
        parameters.put("Max rank", maxRank);
        String scanGroupSize = "1";
        if (((HashMap)this.m_messages_back.get(0)).containsKey("scan.groups.size")) {
            ((HashMap)this.m_messages_back.get(0)).get("scan.groups.size");
        }
        parameters.put("Scan groups size", scanGroupSize);
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                m_logger.debug("  get MSDiag data");
                if (success) {
                    ((RsetMSDiagPanel)DataBoxRsetMSDiag.this.getDataBoxPanelInterface()).setData((String)DataBoxRsetMSDiag.this.m_messages_back.get(1));
                } else {
                    ((RsetMSDiagPanel)DataBoxRsetMSDiag.this.getDataBoxPanelInterface()).setData(null);
                }
                DataBoxRsetMSDiag.this.setLoaded(loadingId);
            }
        };
        GenerateMSDiagReportTask task = new GenerateMSDiagReportTask(callback, Long.valueOf(this.getProjectId()), Long.valueOf(rSetId), parameters, this.m_messages_back);
        ((RsetMSDiagPanel)this.getDataBoxPanelInterface()).setData("task running...please wait.(or come back later)");
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSet) {
            this.m_rset = (ResultSet)data;
            this.dataChanged();
        } else if (data instanceof ResultSummary) {
            this.m_rset = ((ResultSummary)data).getResultSet();
        }
    }
}

