/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadPeptideMatchTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PeptideMatchPanel;

public class DataBoxRsmPSM
extends AbstractDataBox {
    private ResultSummary m_rsm = null;
    private boolean m_mergedData;

    public DataBoxRsmPSM() {
        this(false);
    }

    public DataBoxRsmPSM(boolean mergedData) {
        super(AbstractDataBox.DataboxType.DataBoxRsmPSM, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_mergedData = mergedData;
        this.m_typeName = "PSMs";
        this.m_description = "All PSMs of an Identification Summary or corresponding to a Peptide Instance";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(ResultSet.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PeptideMatchPanel p = new PeptideMatchPanel(true, this.m_mergedData, true, true, false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        final ResultSummary _rsm = this.m_rsm != null ? this.m_rsm : (ResultSummary)this.getData(ResultSummary.class);
        this.linkCache((TransientDataInterface)_rsm);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DPeptideMatch[] peptideMatchArray = _rsm.getTransientData(null).getPeptideMatches();
                    long[] peptideMatchIdArray = _rsm.getTransientData(null).getPeptideMatchesId();
                    ((PeptideMatchPanel)DataBoxRsmPSM.this.getDataBoxPanelInterface()).setData(taskId, peptideMatchArray, peptideMatchIdArray, finished);
                } else {
                    ((PeptideMatchPanel)DataBoxRsmPSM.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                if (finished) {
                    DataBoxRsmPSM.this.unregisterTask(taskId);
                    DataBoxRsmPSM.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmPSM.this.propagateDataChanged();
                }
            }
        };
        this.registerTask((AbstractDatabaseTask)new DatabaseLoadPeptideMatchTask(callback, this.getProjectId(), _rsm));
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            ResultSet rset;
            if (parameterType.equals(DPeptideMatch.class)) {
                return ((PeptideMatchPanel)this.getDataBoxPanelInterface()).getSelectedPeptideMatch();
            }
            if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                return this.m_rsm;
            }
            if (parameterType.equals(ResultSet.class) && this.m_rsm != null && (rset = this.m_rsm.getResultSet()) != null) {
                return rset;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSummary) {
            this.m_rsm = (ResultSummary)data;
            this.getDataBoxPanelInterface().addSingleValue(data);
            this.dataChanged();
        }
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        Peptide peptide;
        DPeptideMatch p = (DPeptideMatch)this.getData(DPeptideMatch.class);
        if (p != null && (peptide = p.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

