/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseProteinSetsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.RsmProteinSetPanel;

public class DataBoxRsmProteinSetOfPeptides
extends AbstractDataBox {
    private ResultSummary m_rsm = null;
    private long m_peptideCurId = -1L;
    private Long m_previousTaskId = null;

    public DataBoxRsmProteinSetOfPeptides() {
        super(AbstractDataBox.DataboxType.DataBoxRsmProteinSetOfPeptides, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "Protein Set";
        this.m_description = "All Protein Sets coresponding to a Peptide Instance";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(PeptideInstance.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        RsmProteinSetPanel p = new RsmProteinSetPanel(false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        this.linkCache((TransientDataInterface)this.m_rsm);
        final PeptideInstance _peptideInstance = (PeptideInstance)this.getData(PeptideInstance.class);
        if (_peptideInstance == null) {
            ((RsmProteinSetPanel)this.getDataBoxPanelInterface()).setData(null, null, true);
            this.m_peptideCurId = -1L;
            return;
        }
        if (this.m_peptideCurId != -1L && _peptideInstance.getId() == this.m_peptideCurId) {
            return;
        }
        this.m_peptideCurId = _peptideInstance.getId();
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    DProteinSet[] proteinSetArray = _peptideInstance.getTransientData().getProteinSetArray();
                    ((RsmProteinSetPanel)DataBoxRsmProteinSetOfPeptides.this.getDataBoxPanelInterface()).setData(taskId, proteinSetArray, finished);
                } else {
                    ((RsmProteinSetPanel)DataBoxRsmProteinSetOfPeptides.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxRsmProteinSetOfPeptides.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxRsmProteinSetOfPeptides.this.unregisterTask(taskId);
                    DataBoxRsmProteinSetOfPeptides.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataBoxRsmProteinSetOfPeptides.this.propagateDataChanged();
                }
            }
        };
        DatabaseProteinSetsTask task = new DatabaseProteinSetsTask(callback);
        task.initLoadProteinSetForPeptideInstance(this.getProjectId(), _peptideInstance);
        Long taskId = task.getId();
        if (this.m_previousTaskId != null) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
        }
        this.m_previousTaskId = taskId;
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DProteinSet.class)) {
                return ((RsmProteinSetPanel)this.getDataBoxPanelInterface()).getSelectedProteinSet();
            }
            if (parameterType.equals(ResultSummary.class) && this.m_rsm != null) {
                return this.m_rsm;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_rsm = (ResultSummary)data;
        this.dataChanged();
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DProteinSet.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        DProteinMatch pm;
        DProteinSet p = (DProteinSet)this.getData(DProteinSet.class);
        if (p != null && (pm = p.getTypicalProteinMatch()) != null) {
            return pm.getAccession();
        }
        return null;
    }
}

