/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.AvailableParameters;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrix;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrixChoice;
import fr.proline.studio.pattern.DataBoxMSQueriesForRSM;
import fr.proline.studio.pattern.DataBoxMSQueriesForRset;
import fr.proline.studio.pattern.DataBoxPTMClusters;
import fr.proline.studio.pattern.DataBoxPTMPeptides;
import fr.proline.studio.pattern.DataBoxPTMPeptidesGraphic;
import fr.proline.studio.pattern.DataBoxRsetAll;
import fr.proline.studio.pattern.DataBoxRsetAllProteinMatch;
import fr.proline.studio.pattern.DataBoxRsetPSM;
import fr.proline.studio.pattern.DataBoxRsetPeptideFragmentation;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrum;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumError;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumValues;
import fr.proline.studio.pattern.DataBoxRsetProteinsForPeptideMatch;
import fr.proline.studio.pattern.DataBoxRsmAllProteinSet;
import fr.proline.studio.pattern.DataBoxRsmPSM;
import fr.proline.studio.pattern.DataBoxRsmPSMForMsQuery;
import fr.proline.studio.pattern.DataBoxRsmPeptideInstances;
import fr.proline.studio.pattern.DataBoxRsmPeptidesOfProtein;
import fr.proline.studio.pattern.DataBoxRsmProteinAndPeptideSequence;
import fr.proline.studio.pattern.DataBoxRsmProteinSetOfPeptides;
import fr.proline.studio.pattern.DataBoxRsmProteinsOfProteinSet;
import fr.proline.studio.pattern.DataBoxTaskDescription;
import fr.proline.studio.pattern.DataboxGraphics;
import fr.proline.studio.pattern.DataboxMultiGraphics;
import fr.proline.studio.pattern.DataboxRsetPSMForMsQuery;
import fr.proline.studio.pattern.DataboxRsetPeptidesOfProtein;
import fr.proline.studio.pattern.DataboxRsmPSMOfPeptide;
import fr.proline.studio.pattern.DataboxRsmPSMOfProteinSet;
import fr.proline.studio.pattern.ParameterDistance;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.xic.DataboxChildFeature;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.pattern.xic.DataboxPSMOfMasterQuantPeptide;
import fr.proline.studio.pattern.xic.DataboxXicPeptideIon;
import fr.proline.studio.pattern.xic.DataboxXicPeptideSet;
import fr.proline.studio.pattern.xic.DataboxXicProteinSet;
import java.util.ArrayList;
import java.util.TreeMap;

public class DataboxManager {
    private static DataboxManager m_databoxManager = null;
    private final AbstractDataBox[] m_dataBoxStartingArray = new AbstractDataBox[]{new DataBoxRsetAll(), new DataBoxRsetPSM(), new DataBoxRsetAllProteinMatch(), new DataBoxRsmPSM(), new DataBoxRsmPeptideInstances(), new DataBoxAdjacencyMatrixChoice(), new DataBoxRsmAllProteinSet(), new DataboxXicPeptideSet(), new DataboxXicPeptideIon(), new DataboxXicProteinSet(), new DataBoxMSQueriesForRSM(), new DataBoxMSQueriesForRset(), new DataBoxPTMClusters()};
    private final AbstractDataBox[] m_dataBoxContinuingArray = new AbstractDataBox[]{new DataBoxRsetPeptideSpectrum(), new DataBoxRsetPeptideSpectrumValues(), new DataBoxRsetProteinsForPeptideMatch(), new DataboxRsetPeptidesOfProtein(), new DataBoxRsmPeptidesOfProtein(), new DataBoxRsmProteinAndPeptideSequence(), new DataBoxRsmProteinSetOfPeptides(), new DataBoxRsmProteinsOfProteinSet(), new DataBoxTaskDescription(), new DataBoxRsetPeptideFragmentation(), new DataBoxRsetPeptideSpectrumError(), new DataboxRsmPSMOfProteinSet(), new DataboxRsmPSMOfPeptide(), new DataboxGraphics(false), new DataboxPSMOfMasterQuantPeptide(), new DataboxXicPeptideSet(), new DataboxXicPeptideIon(), new DataboxChildFeature(), new DataboxMultiGraphics(false, false, true), new DataboxMultiGraphics(false, false), new DataboxMapAlignment(), new DataBoxAdjacencyMatrixChoice(), new DataBoxAdjacencyMatrix(), new DataBoxRsmPSMForMsQuery(), new DataboxRsetPSMForMsQuery(), new DataBoxPTMPeptides(false, false), new DataBoxPTMPeptides(true, false), new DataBoxPTMPeptides(false, true), new DataBoxPTMPeptides(true, true), new DataBoxPTMPeptidesGraphic()};

    private DataboxManager() {
    }

    public static DataboxManager getDataboxManager() {
        if (m_databoxManager == null) {
            m_databoxManager = new DataboxManager();
        }
        return m_databoxManager;
    }

    public TreeMap<ParameterDistance, AbstractDataBox> findCompatibleStartingDataboxList(ArrayList<ParameterList> outParameters) {
        TreeMap<ParameterDistance, AbstractDataBox> compatibilityList = new TreeMap<ParameterDistance, AbstractDataBox>();
        for (int i = 0; i < this.m_dataBoxStartingArray.length; ++i) {
            double averageDistance = this.m_dataBoxStartingArray[i].calculateParameterCompatibilityDistance(outParameters);
            if (!(averageDistance >= 0.0)) continue;
            compatibilityList.put(new ParameterDistance(averageDistance), this.m_dataBoxStartingArray[i]);
        }
        return compatibilityList;
    }

    public TreeMap<ParameterDistance, AbstractDataBox> findCompatibleDataboxList(AbstractDataBox previousDatabox, Class[] importantInParameter) {
        AvailableParameters avalaibleParameters = new AvailableParameters(previousDatabox);
        TreeMap<ParameterDistance, AbstractDataBox> compatibilityList = new TreeMap<ParameterDistance, AbstractDataBox>();
        if (importantInParameter != null) {
            for (int j = 0; j < importantInParameter.length; ++j) {
                for (int i = 0; i < this.m_dataBoxContinuingArray.length; ++i) {
                    double averageDistance;
                    AbstractDataBox databox = this.m_dataBoxContinuingArray[i];
                    if (databox.m_type.equals((Object)previousDatabox.m_type) || !((averageDistance = previousDatabox.calculateParameterCompatibilityDistance(avalaibleParameters, databox, importantInParameter[j])) >= 0.0)) continue;
                    compatibilityList.put(new ParameterDistance(averageDistance), databox);
                }
            }
        } else {
            for (int i = 0; i < this.m_dataBoxContinuingArray.length; ++i) {
                double averageDistance;
                AbstractDataBox databox = this.m_dataBoxContinuingArray[i];
                if (databox.m_type.equals((Object)previousDatabox.m_type) || !((averageDistance = previousDatabox.calculateParameterCompatibilityDistance(avalaibleParameters, databox, null)) >= 0.0)) continue;
                compatibilityList.put(new ParameterDistance(averageDistance), databox);
            }
        }
        return compatibilityList;
    }
}

