/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.pattern.DataParameter;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import java.util.ArrayList;

public class ParameterList {
    private final ArrayList<DataParameter> m_parameterList = new ArrayList(1);

    public void addParameter(Class type) {
        this.m_parameterList.add(new DataParameter(type, ParameterSubtypeEnum.SINGLE_DATA));
    }

    public void addParameter(Class type, boolean isCompulsory) {
        this.m_parameterList.add(new DataParameter(type, ParameterSubtypeEnum.SINGLE_DATA, isCompulsory));
    }

    public void addParameter(Class type, ParameterSubtypeEnum subtype) {
        this.m_parameterList.add(new DataParameter(type, subtype));
    }

    public void addParameter(Class type, ParameterSubtypeEnum subtype, boolean isCompulsory) {
        this.m_parameterList.add(new DataParameter(type, subtype, isCompulsory));
    }

    public ArrayList<DataParameter> getParameterList() {
        return this.m_parameterList;
    }

    public void addParameter(ParameterList groupParameter) {
        for (DataParameter dataParameter : groupParameter.getParameterList()) {
            this.m_parameterList.add(dataParameter);
        }
    }

    public boolean isDataDependant(Class dataType, ParameterSubtypeEnum subtype) {
        int nbParameters = this.m_parameterList.size();
        for (int i = 0; i < nbParameters; ++i) {
            DataParameter parameter = this.m_parameterList.get(i);
            if (!parameter.equalsData(dataType, subtype)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleWithOutParameter(ArrayList<ParameterList> outParameterList) {
        int nbInParameters = this.m_parameterList.size();
        int nbOutParameters = outParameterList.size();
        for (int i = 0; i < nbInParameters; ++i) {
            DataParameter inParameter = this.m_parameterList.get(i);
            if (!inParameter.isCompulsory()) continue;
            boolean compatibleOutParameterFound = false;
            for (int j = 0; j < nbOutParameters; ++j) {
                ParameterList dataOutParameter = outParameterList.get(j);
                if (!dataOutParameter.isCompatibleWithInParameter(inParameter)) continue;
                compatibleOutParameterFound = true;
                break;
            }
            if (compatibleOutParameterFound) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatibleWithInParameter(DataParameter inParameter) {
        int nbOutParameters = this.m_parameterList.size();
        for (int i = 0; i < nbOutParameters; ++i) {
            DataParameter outParameter = this.m_parameterList.get(i);
            if (!inParameter.isCompatibleWithOutParameter(outParameter)) continue;
            return true;
        }
        return false;
    }
}

