/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.lcms.Feature;
import fr.proline.core.orm.lcms.Peak;
import fr.proline.core.orm.lcms.Peakel;
import fr.proline.core.orm.lcms.dto.DFeature;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadLcMSTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.mzscope.MzScopeInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.extradata.GraphicExtraData;
import fr.proline.studio.rsmexplorer.gui.xic.PeakTableModel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicFeaturePanel;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeakPanel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DataboxChildFeature
extends AbstractDataBox {
    private DMasterQuantPeptideIon m_masterQuantPeptideIon;
    private List<DFeature> m_childFeatureList;
    private QuantChannelInfo m_quantChannelInfo;
    private List<Boolean> m_featureHasPeak;
    private List<List<Peakel>> m_peakelList;
    private List<List<List<Peak>>> m_peakList;
    private HashSet<DFeature> m_extractedXICSet = null;
    private Boolean m_keepZoom = Boolean.FALSE;

    public DataboxChildFeature() {
        super(AbstractDataBox.DataboxType.DataboxXicChildFeature, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "XIC Features";
        this.m_description = "All Features for a Quanti. Peptide Ion";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DMasterQuantPeptideIon.class);
        inParameter.addParameter(QuantChannelInfo.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(Feature.class);
        outParameter.addParameter(DFeature.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        outParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(CrossSelectionInterface.class, ParameterSubtypeEnum.LIST_DATA);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        XicFeaturePanel p = new XicFeaturePanel(true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        this.m_extractedXICSet = null;
        DMasterQuantPeptideIon oldIon = this.m_masterQuantPeptideIon;
        this.m_masterQuantPeptideIon = (DMasterQuantPeptideIon)this.getData(DMasterQuantPeptideIon.class);
        this.m_quantChannelInfo = (QuantChannelInfo)this.getData(QuantChannelInfo.class);
        if (this.m_masterQuantPeptideIon != null && oldIon != null && this.m_masterQuantPeptideIon.equals(oldIon)) {
            return;
        }
        if (this.m_masterQuantPeptideIon == null && oldIon == null) {
            return;
        }
        if (this.m_quantChannelInfo == null) {
            ((XicFeaturePanel)this.getDataBoxPanelInterface()).setData(-1L, null, null, null, true);
            return;
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    DataboxChildFeature.this.m_peakList = new ArrayList();
                    if (DataboxChildFeature.this.m_childFeatureList != null) {
                        for (int i = 0; i < DataboxChildFeature.this.m_childFeatureList.size(); ++i) {
                            boolean hasPeak = false;
                            ArrayList<List> list = new ArrayList<List>();
                            if (DataboxChildFeature.this.m_peakelList.size() >= i + 1) {
                                for (Peakel peakel : (List)DataboxChildFeature.this.m_peakelList.get(i)) {
                                    List listPeak = peakel.getPeakList();
                                    if (listPeak.size() > 0) {
                                        hasPeak = true;
                                    }
                                    list.add(listPeak);
                                }
                            }
                            DataboxChildFeature.this.m_peakList.add(list);
                            DataboxChildFeature.this.m_featureHasPeak.add(hasPeak);
                        }
                    }
                    ((XicFeaturePanel)DataboxChildFeature.this.getDataBoxPanelInterface()).setData(taskId, DataboxChildFeature.this.m_childFeatureList, DataboxChildFeature.this.m_quantChannelInfo, DataboxChildFeature.this.m_featureHasPeak, finished);
                } else {
                    DataboxChildFeature.this.m_childFeatureList = new ArrayList();
                    DataboxChildFeature.this.m_featureHasPeak = new ArrayList();
                    DataboxChildFeature.this.m_peakelList = new ArrayList();
                    DataboxChildFeature.this.m_peakList = new ArrayList();
                    ((XicFeaturePanel)DataboxChildFeature.this.getDataBoxPanelInterface()).setData(taskId, DataboxChildFeature.this.m_childFeatureList, DataboxChildFeature.this.m_quantChannelInfo, DataboxChildFeature.this.m_featureHasPeak, finished);
                }
                DataboxChildFeature.this.setLoaded(loadingId);
                if (finished) {
                    DataboxChildFeature.this.unregisterTask(taskId);
                    DataboxChildFeature.this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.SINGLE_DATA);
                    DataboxChildFeature.this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
                    DataboxChildFeature.this.propagateDataChanged();
                }
            }
        };
        this.m_childFeatureList = new ArrayList<DFeature>();
        this.m_featureHasPeak = new ArrayList<Boolean>();
        this.m_peakelList = new ArrayList<List<Peakel>>();
        this.m_peakList = new ArrayList<List<List<Peak>>>();
        DatabaseLoadLcMSTask task = new DatabaseLoadLcMSTask(callback);
        task.initLoadChildFeatureForPeptideIonWithPeakel(this.getProjectId(), this.m_masterQuantPeptideIon, this.m_quantChannelInfo.getQuantChannels(), this.m_childFeatureList, this.m_peakelList, this.m_quantChannelInfo.getDataset());
        this.registerTask((AbstractDatabaseTask)task);
    }

    private List<XicPeakPanel> getPeakTableModelList() {
        ArrayList<XicPeakPanel> list = new ArrayList<XicPeakPanel>();
        int viewType = ((XicFeaturePanel)this.getDataBoxPanelInterface()).getGraphViewType();
        if (this.m_childFeatureList != null) {
            switch (viewType) {
                case 0: {
                    for (int i = 0; i < this.m_childFeatureList.size(); ++i) {
                        List<Peakel> peakels;
                        DFeature feature = this.m_childFeatureList.get(i);
                        Color color = this.m_quantChannelInfo.getQuantChannelColor(feature.getQuantChannelId());
                        String title = this.m_quantChannelInfo.getQuantChannels(feature.getQuantChannelId()).getName();
                        if (this.m_peakelList == null || this.m_peakelList.size() <= i || (peakels = this.m_peakelList.get(i)).size() <= 0) continue;
                        int idP = 0;
                        for (Peakel peakel : peakels) {
                            if (peakel.getIsotopeIndex() == 0 && this.m_peakList.size() > i && !this.m_peakList.get(i).isEmpty()) {
                                List<Peak> peaks = this.m_peakList.get(i).get(idP);
                                XicPeakPanel peakPanel = new XicPeakPanel();
                                peakPanel.setData(-1L, (Feature)feature, peakel, peakel.getIsotopeIndex(), peaks, color, title, true);
                                list.add(peakPanel);
                            }
                            ++idP;
                        }
                    }
                    break;
                }
                case 1: {
                    int id;
                    DFeature selectedFeature = ((XicFeaturePanel)this.getDataBoxPanelInterface()).getSelectedFeature();
                    if (selectedFeature == null || (id = this.m_childFeatureList.indexOf(selectedFeature)) == -1) break;
                    Color color = this.m_quantChannelInfo.getQuantChannelColor(selectedFeature.getQuantChannelId());
                    String title = this.m_quantChannelInfo.getQuantChannels(selectedFeature.getQuantChannelId()).getName();
                    if (this.m_peakelList == null || this.m_peakelList.size() <= id) break;
                    List<Peakel> peakels = this.m_peakelList.get(id);
                    int nbPeakel = peakels.size();
                    if (this.m_peakList.size() <= id || this.m_peakList.get(id).isEmpty()) break;
                    List<List<Peak>> listPeaks = this.m_peakList.get(id);
                    for (int p = 0; p < nbPeakel; ++p) {
                        List<Peak> peaks = listPeaks.get(p);
                        XicPeakPanel peakPanel = new XicPeakPanel();
                        peakPanel.setData(-1L, (Feature)selectedFeature, peakels.get(p), peakels.get(p).getIsotopeIndex(), peaks, color, title, true);
                        list.add(peakPanel);
                    }
                    break;
                }
            }
        }
        return list;
    }

    private void addExtractedXIC(List<ExtendedTableModelInterface> modelList) {
        if (this.m_extractedXICSet == null) {
            return;
        }
        int viewType = ((XicFeaturePanel)this.getDataBoxPanelInterface()).getGraphViewType();
        if (this.m_childFeatureList != null) {
            switch (viewType) {
                case 0: {
                    for (DFeature feature : this.m_extractedXICSet) {
                        if (!feature.hasPeaks()) continue;
                        Color color = this.m_quantChannelInfo.getQuantChannelColor(feature.getQuantChannelId());
                        String title = this.m_quantChannelInfo.getQuantChannels(feature.getQuantChannelId()).getName();
                        Peak[] peakArray = feature.getPeakArray(0);
                        if (peakArray == null) continue;
                        PeakTableModel model = new PeakTableModel(null);
                        model.setData(-1L, null, null, -1, new ArrayList<Peak>(Arrays.asList(peakArray)), color, true, title);
                        modelList.add((ExtendedTableModelInterface)model);
                    }
                    break;
                }
                case 1: {
                    DFeature selectedFeature = ((XicFeaturePanel)this.getDataBoxPanelInterface()).getSelectedFeature();
                    if (!selectedFeature.hasPeaks()) {
                        return;
                    }
                    Color color = this.m_quantChannelInfo.getQuantChannelColor(selectedFeature.getQuantChannelId());
                    String title = this.m_quantChannelInfo.getQuantChannels(selectedFeature.getQuantChannelId()).getName();
                    for (int i = 0; i < 3; ++i) {
                        Peak[] peakArray = selectedFeature.getPeakArray(i);
                        if (peakArray == null) continue;
                        PeakTableModel model = new PeakTableModel(null);
                        model.setData(-1L, null, null, -1, new ArrayList<Peak>(Arrays.asList(peakArray)), color, true, title);
                        modelList.add((ExtendedTableModelInterface)model);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_masterQuantPeptideIon = (DMasterQuantPeptideIon)data;
        this.dataChanged();
    }

    public DMasterQuantPeptideIon getMasterQuantPeptideIon() {
        return this.m_masterQuantPeptideIon;
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                if (parameterType.equals(MzScopeInterface.class)) {
                    return ((XicFeaturePanel)this.getDataBoxPanelInterface()).getMzScopeInterface();
                }
                if (parameterType.equals(Feature.class)) {
                    return ((XicFeaturePanel)this.getDataBoxPanelInterface()).getSelectedFeature();
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA) {
                if (parameterType.equals(DFeature.class)) {
                    return this.m_childFeatureList;
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return this.getCompareDataInterfaceList();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return this.getCrossSelectionInterfaceList();
                }
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Object getExtraData(Class parameterType) {
        if (parameterType.equals(ExtendedTableModelInterface.class)) {
            return new GraphicExtraData(this.m_keepZoom, null);
        }
        return super.getExtraData(parameterType);
    }

    @Override
    public String getFullName() {
        if (this.m_masterQuantPeptideIon == null) {
            return super.getFullName();
        }
        return this.m_masterQuantPeptideIon.getCharge() + " " + this.getTypeName();
    }

    private List<ExtendedTableModelInterface> getCompareDataInterfaceList() {
        ArrayList<ExtendedTableModelInterface> listCDI = new ArrayList<ExtendedTableModelInterface>();
        List<XicPeakPanel> listPeakPanel = this.getPeakTableModelList();
        for (XicPeakPanel peakPanel : listPeakPanel) {
            listCDI.add((ExtendedTableModelInterface)peakPanel.getGlobalTableModelInterface());
        }
        this.addExtractedXIC(listCDI);
        return listCDI;
    }

    private List<CrossSelectionInterface> getCrossSelectionInterfaceList() {
        ArrayList<CrossSelectionInterface> listCSI = new ArrayList<CrossSelectionInterface>();
        List<XicPeakPanel> listPeakPanel = this.getPeakTableModelList();
        for (XicPeakPanel peakPanel : listPeakPanel) {
            listCSI.add(peakPanel.getCrossSelectionInterface());
        }
        return listCSI;
    }

    public void setRetrievedXic(HashSet<DFeature> featureList) {
        if (this.m_extractedXICSet == null) {
            this.m_extractedXICSet = new HashSet();
        }
        this.m_extractedXICSet.addAll(featureList);
        this.propagateModelChangeWithoutModifyingZoom();
    }

    public void propagateModelChangeWithoutModifyingZoom() {
        this.m_keepZoom = Boolean.TRUE;
        this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.SINGLE_DATA);
        this.addDataChanged(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        this.propagateDataChanged();
        this.m_keepZoom = Boolean.FALSE;
    }
}

