/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern.xic;

import fr.proline.core.orm.msi.Peptide;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.core.orm.msi.dto.DMasterQuantPeptideIon;
import fr.proline.core.orm.msi.dto.DPeptideInstance;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.rsmexplorer.gui.xic.XicPeptideIonPanel;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.List;

public class DataboxXicPeptideIon
extends AbstractDataBox {
    private DDataset m_dataset;
    private DMasterQuantPeptide m_masterQuantPeptide;
    private List<DMasterQuantPeptideIon> m_masterQuantPeptideIonList;
    private QuantChannelInfo m_quantChannelInfo;
    private boolean m_isXICMode = true;

    public DataboxXicPeptideIon() {
        super(AbstractDataBox.DataboxType.DataboxXicPeptideIon, AbstractDataBox.DataboxStyle.STYLE_XIC);
        this.m_typeName = "Quanti. Peptides Ions";
        this.m_description = "All Peptides Ions of a Quanti. Peptide";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DDataset.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(QuantChannelInfo.class, ParameterSubtypeEnum.SINGLE_DATA, false);
        inParameter.addParameter(DMasterQuantPeptide.class);
        inParameter.addParameter(XicMode.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(DDataset.class);
        outParameter.addParameter(DMasterQuantPeptideIon.class);
        outParameter.addParameter(QuantChannelInfo.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        XicPeptideIonPanel p = new XicPeptideIonPanel();
        p.setIsAllPeptideIon(this.m_previousDataBox == null);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
        this.getDataBoxPanelInterface().addSingleValue(new XicMode(this.m_isXICMode));
    }

    @Override
    public void dataChanged() {
        final boolean allPeptides = this.m_previousDataBox == null;
        DMasterQuantPeptide oldPeptide = this.m_masterQuantPeptide;
        if (!allPeptides) {
            this.m_masterQuantPeptide = (DMasterQuantPeptide)this.m_previousDataBox.getData(DMasterQuantPeptide.class);
            this.m_dataset = (DDataset)this.m_previousDataBox.getData(DDataset.class);
            this.m_quantChannelInfo = (QuantChannelInfo)this.m_previousDataBox.getData(QuantChannelInfo.class);
            if (this.m_masterQuantPeptide == null || this.m_masterQuantPeptide.equals(oldPeptide)) {
                return;
            }
            this.m_isXICMode = ((XicMode)this.m_previousDataBox.getData(XicMode.class)).isXicMode();
        }
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (DataboxXicPeptideIon.this.m_dataset != null) {
                    DataboxXicPeptideIon.this.linkCache((TransientDataInterface)DataboxXicPeptideIon.this.m_dataset.getResultSummary());
                }
                if (subTask == null) {
                    if (!allPeptides) {
                        ((XicPeptideIonPanel)DataboxXicPeptideIon.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicPeptideIon.this.m_quantChannelInfo.getQuantChannels(), DataboxXicPeptideIon.this.m_masterQuantPeptideIonList, DataboxXicPeptideIon.this.m_isXICMode, finished);
                    } else {
                        DataboxXicPeptideIon.this.m_quantChannelInfo = new QuantChannelInfo(DataboxXicPeptideIon.this.m_dataset);
                        ((XicPeptideIonPanel)DataboxXicPeptideIon.this.getDataBoxPanelInterface()).setData(taskId, DataboxXicPeptideIon.this.m_quantChannelInfo.getQuantChannels(), DataboxXicPeptideIon.this.m_masterQuantPeptideIonList, DataboxXicPeptideIon.this.m_isXICMode, finished);
                    }
                } else {
                    ((XicPeptideIonPanel)DataboxXicPeptideIon.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataboxXicPeptideIon.this.setLoaded(loadingId);
                if (finished) {
                    DataboxXicPeptideIon.this.unregisterTask(taskId);
                    DataboxXicPeptideIon.this.addDataChanged(ExtendedTableModelInterface.class);
                    DataboxXicPeptideIon.this.propagateDataChanged();
                }
            }
        };
        this.m_masterQuantPeptideIonList = new ArrayList<DMasterQuantPeptideIon>();
        DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(callback);
        if (allPeptides) {
            task.initLoadPeptideIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptideIonList);
        } else {
            task.initLoadPeptideIons(this.getProjectId(), this.m_dataset, this.m_masterQuantPeptide, this.m_masterQuantPeptideIonList);
        }
        Long taskId = task.getId();
        this.registerTask((AbstractDatabaseTask)task);
    }

    public boolean isXICMode() {
        return this.m_isXICMode;
    }

    public void setXICMode(boolean isXICMode) {
        this.m_isXICMode = isXICMode;
        AbstractDataBox.DataboxStyle databoxStyle = this.m_style = this.m_isXICMode ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_SC;
        if (this.getDataBoxPanelInterface() != null) {
            this.getDataBoxPanelInterface().addSingleValue(new XicMode(isXICMode));
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        this.m_dataset = (DDataset)data;
        this.dataChanged();
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(ResultSummary.class)) {
                return this.m_dataset.getResultSummary();
            }
            if (parameterType.equals(DMasterQuantPeptideIon.class)) {
                return ((XicPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptideIon();
            }
            if (parameterType.equals(QuantChannelInfo.class) && this.m_quantChannelInfo != null) {
                return this.m_quantChannelInfo;
            }
            if (parameterType.equals(DPeptideMatch.class)) {
                DMasterQuantPeptideIon qpi = ((XicPeptideIonPanel)this.getDataBoxPanelInterface()).getSelectedMasterQuantPeptideIon();
                if (qpi == null) {
                    return null;
                }
                DPeptideInstance pi = qpi.getPeptideInstance();
                if (pi == null) {
                    return null;
                }
                return pi.getBestPeptideMatch();
            }
            if (parameterType.equals(DDataset.class)) {
                return this.m_dataset;
            }
            if (parameterType.equals(ExtendedTableModelInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
            }
            if (parameterType.equals(CrossSelectionInterface.class)) {
                return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
            }
            if (parameterType.equals(QuantChannelInfo.class)) {
                return this.m_quantChannelInfo;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public String getFullName() {
        if (this.m_dataset == null) {
            return super.getFullName();
        }
        return this.m_dataset.getName() + " " + this.getTypeName();
    }

    @Override
    public Class[] getImportantInParameterClass() {
        Class[] classList = new Class[]{DMasterQuantPeptideIon.class, DPeptideMatch.class};
        return classList;
    }

    @Override
    public String getImportantOutParameterValue() {
        Peptide peptide;
        DPeptideInstance peptideInstance;
        DMasterQuantPeptideIon peptideIon = (DMasterQuantPeptideIon)this.getData(DMasterQuantPeptideIon.class);
        if (peptideIon != null && (peptideInstance = peptideIon.getPeptideInstance()) != null && (peptide = peptideInstance.getPeptide()) != null) {
            return peptide.getSequence();
        }
        return null;
    }
}

