/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer;

import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.table.TableInfo;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MultiDataBoxViewerTopComponent
extends DataBoxViewerTopComponent {
    private WindowBox[] m_windowBoxes = null;

    public MultiDataBoxViewerTopComponent(WindowBox[] windowBoxes, String name) {
        super(windowBoxes[0]);
        this.m_windowBoxes = windowBoxes;
        this.removeAll();
        this.setLayout(new GridLayout());
        this.add(this.createPanel());
        this.setName(name);
    }

    private JPanel createPanel() {
        JPanel internalPanel = new JPanel(new GridLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        for (WindowBox wBox : this.m_windowBoxes) {
            ImageIcon boxIcon = null;
            if (wBox.getIcon() != null) {
                boxIcon = new ImageIcon(wBox.getIcon());
            }
            tabbedPane.addTab(wBox.getName(), boxIcon, wBox.getPanel(), null);
        }
        internalPanel.add(tabbedPane);
        return internalPanel;
    }

    @Override
    public void retrieveTableModels(ArrayList<TableInfo> list) {
        for (WindowBox wBox : this.m_windowBoxes) {
            wBox.retrieveTableModels(list);
        }
    }

    @Override
    protected void componentOpened() {
        for (WindowBox wBox : this.m_windowBoxes) {
            wBox.windowOpened();
        }
    }

    @Override
    protected void componentClosed() {
        for (WindowBox wBox : this.m_windowBoxes) {
            wBox.windowClosed();
        }
    }

    @Override
    public ParameterList getInParameters() {
        ParameterList inParameters = new ParameterList();
        for (WindowBox wBox : this.m_windowBoxes) {
            ParameterList windowInParameters = wBox.getEntryBox().getInParameters();
            inParameters.addParameter(windowInParameters);
        }
        return inParameters;
    }

    @Override
    public ParameterList getOutParameters() {
        ParameterList outParameters = new ParameterList();
        for (WindowBox wBox : this.m_windowBoxes) {
            ParameterList windowOutParameters = wBox.getEntryBox().getOutParameters();
            outParameters.addParameter(windowOutParameters);
        }
        return outParameters;
    }
}

