/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import java.util.Set;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DisplayAllRsetAction
extends AbstractRSMAction {
    public DisplayAllRsetAction(AbstractTree tree) {
        super(NbBundle.getMessage(DisplayAllRsetAction.class, (String)"CTL_DisplayAllRset"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode node = selectedNodes[0];
        IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)node.getParent();
        Project p = projectNode.getProject();
        String windowName = p.getName() + " : All Imported";
        TopComponent tc = this.findTopComponent(windowName);
        if (tc != null) {
            tc.requestActive();
        } else {
            WindowBox wbox = WindowBoxFactory.getAllResultSetWindowBox(windowName);
            wbox.setEntryData(p.getId(), p);
            DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
            win.open();
            win.requestActive();
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        this.setEnabled(true);
    }

    private TopComponent findTopComponent(String name) {
        Set openTopComponents = WindowManager.getDefault().getRegistry().getOpened();
        for (TopComponent tc : openTopComponents) {
            if (!tc.getName().startsWith(name)) continue;
            return tc;
        }
        return null;
    }
}

