/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayMSQueryForRsetAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsetPeptidesAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsetProteinMatchesAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplaySavedWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayUserWindowAction;
import fr.proline.studio.rsmexplorer.actions.identification.GenerateMSDiagReportAction;
import fr.proline.studio.rsmexplorer.actions.identification.ManageUserWindowsAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.NbBundle;

public class DisplayRsetAction
extends AbstractRSMAction {
    private DisplayRsetPeptidesAction m_displayRsetPeptidesAction;
    private DisplayUserWindowAction m_displayUserWindowAction;
    private DisplayRsetProteinMatchesAction m_displayRsetProteinMatchesAction;
    private DisplayMSQueryForRsetAction m_displayMSQueryAction;
    private GenerateMSDiagReportAction m_msDiagReportAction;
    private ManageUserWindowsAction m_manageUserWindowsAction;
    private ArrayList<DisplaySavedWindowAction> m_displaySavedWindowActionList;
    private JMenu m_menu;

    public DisplayRsetAction(AbstractTree tree) {
        super(NbBundle.getMessage(DisplayRsetAction.class, (String)"CTL_DisplayRsetAction"), tree);
    }

    @Override
    public JMenuItem getPopupPresenter() {
        this.m_menu = new JMenu((String)this.getValue("Name"));
        this.m_displayMSQueryAction = new DisplayMSQueryForRsetAction(this.getTree());
        this.m_displayRsetPeptidesAction = new DisplayRsetPeptidesAction(this.getTree());
        this.m_displayRsetProteinMatchesAction = new DisplayRsetProteinMatchesAction(this.getTree());
        this.m_msDiagReportAction = new GenerateMSDiagReportAction(this.getTree());
        this.m_manageUserWindowsAction = new ManageUserWindowsAction('1', this.getTree());
        this.m_displayUserWindowAction = new DisplayUserWindowAction('1', this.getTree());
        ArrayList<String> savedWindowsList = WindowSavedManager.readSavedWindows();
        int nb = savedWindowsList.size();
        this.m_displaySavedWindowActionList = new ArrayList();
        for (int i = 0; i < nb; ++i) {
            String wndSaved = savedWindowsList.get(i);
            if (!WindowSavedManager.hasResultSetParameter(wndSaved)) continue;
            String name = WindowSavedManager.getWindowName(wndSaved);
            this.m_displaySavedWindowActionList.add(new DisplaySavedWindowAction(name, i, this.getTree()));
        }
        JMenuItem displayMSQueryItem = new JMenuItem(this.m_displayMSQueryAction);
        JMenuItem displayRsetPeptidesItem = new JMenuItem(this.m_displayRsetPeptidesAction);
        JMenuItem displayRsetProteinMatchesItem = new JMenuItem(this.m_displayRsetProteinMatchesAction);
        JMenuItem displayMsDiagReportItem = new JMenuItem(this.m_msDiagReportAction);
        JMenuItem displayUserWindowItem = new JMenuItem(this.m_displayUserWindowAction);
        JMenuItem manageUserWindowsItem = new JMenuItem(this.m_manageUserWindowsAction);
        this.m_menu.add(displayMSQueryItem);
        this.m_menu.add(displayRsetPeptidesItem);
        this.m_menu.add(displayRsetProteinMatchesItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayMsDiagReportItem);
        this.m_menu.addSeparator();
        this.m_menu.add(displayUserWindowItem);
        this.m_menu.add(manageUserWindowsItem);
        int nbUserWindows = this.m_displaySavedWindowActionList.size();
        if (nbUserWindows > 0) {
            this.m_menu.addSeparator();
        }
        for (int i = 0; i < nbUserWindows; ++i) {
            this.m_menu.add(new JMenuItem(this.m_displaySavedWindowActionList.get(i)));
        }
        return this.m_menu;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        this.m_displayRsetPeptidesAction.updateEnabled(selectedNodes);
        this.m_displayRsetProteinMatchesAction.updateEnabled(selectedNodes);
        this.m_displayMSQueryAction.updateEnabled(selectedNodes);
        this.m_msDiagReportAction.updateEnabled(selectedNodes);
        this.m_displayUserWindowAction.updateEnabled(selectedNodes);
        this.m_manageUserWindowsAction.updateEnabled(selectedNodes);
        boolean listEnabled = false;
        for (int i = 0; i < this.m_displaySavedWindowActionList.size(); ++i) {
            this.m_displaySavedWindowActionList.get(i).updateEnabled(selectedNodes);
            listEnabled |= this.m_displaySavedWindowActionList.get(i).isEnabled();
        }
        boolean isEnabled = this.m_displayRsetPeptidesAction.isEnabled() || this.m_displayRsetProteinMatchesAction.isEnabled() || this.m_displayMSQueryAction.isEnabled() || this.m_msDiagReportAction.isEnabled() || this.m_displayUserWindowAction.isEnabled() || this.m_manageUserWindowsAction.isEnabled() || listEnabled;
        this.setEnabled(isEnabled);
        this.m_menu.setEnabled(isEnabled);
    }
}

