/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class DisplaySavedWindowAction
extends AbstractRSMAction {
    private int m_wndIndex;

    public DisplaySavedWindowAction(String name, int wndIndex, AbstractTree tree) {
        super(name, tree);
        this.m_wndIndex = wndIndex;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        ArrayList<String> savedWindowsList = WindowSavedManager.readSavedWindows();
        if (savedWindowsList.isEmpty()) {
            return;
        }
        String savedWindow = savedWindowsList.get(this.m_wndIndex);
        char windowType = WindowSavedManager.getWindowType(savedWindow);
        String windowName = WindowSavedManager.getWindowName(savedWindow);
        int nbNodes = selectedNodes.length;
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            this.actionImpl(windowName, savedWindow, dataSetNode, windowType);
        }
    }

    private void actionImpl(String windowName, String savedWindow, DataSetNode dataSetNode, char windowType) {
        DDataset ds;
        DDataset dataSet = ((DataSetData)dataSetNode.getData()).getDataset();
        long projectId = dataSet.getProject().getId();
        AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(savedWindow);
        databoxes[0].setProjectId(projectId);
        WindowBox wbox = WindowBoxFactory.getFromBoxesWindowBox(dataSet.getName() + " " + windowName, databoxes, false, dataSetNode.isQuantitation() && !dataSetNode.isQuantSC(), windowType);
        if (windowType == '2') {
            ResultSummary rsm = dataSetNode.getResultSummary();
            if (rsm == null) {
                this.loadRsmOrRsetAndDisplayWnd(dataSet, wbox, '2');
                return;
            }
        } else if (windowType == '1') {
            ResultSet rset = dataSetNode.getResultSet();
            if (rset == null) {
                this.loadRsmOrRsetAndDisplayWnd(dataSet, wbox, '1');
                return;
            }
        } else if (windowType == '3' && (ds = dataSetNode.getDataset()) == null) {
            this.loadDatasetAndDisplayWnd(dataSet, wbox);
            return;
        }
        this.displayWnd(dataSet, wbox, windowType);
    }

    private void loadRsmOrRsetAndDisplayWnd(final DDataset dataSet, final WindowBox wbox, final char windowType) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DisplaySavedWindowAction.this.displayWnd(dataSet, wbox, windowType);
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initLoadRsetAndRsm(dataSet);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void loadDatasetAndDisplayWnd(final DDataset dataSet, final WindowBox wbox) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                DisplaySavedWindowAction.this.displayWnd(dataSet, wbox, '3');
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initLoadQuantitation(dataSet.getProject(), dataSet);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    private void displayWnd(DDataset dataSet, WindowBox wbox, char windowType) {
        long projectId = dataSet.getProject().getId();
        if (windowType == '2') {
            wbox.setEntryData(projectId, dataSet.getResultSummary());
        } else if (windowType == '1') {
            wbox.setEntryData(projectId, dataSet.getResultSet());
        } else if (windowType == '3') {
            wbox.setEntryData(projectId, dataSet);
        }
        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
        win.open();
        win.requestActive();
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Preferences preferences = NbPreferences.root();
        String wndDefinition = WindowSavedManager.readSavedWindows().get(this.m_wndIndex);
        boolean needsRset = WindowSavedManager.hasResultSetParameter(wndDefinition);
        boolean needsRsm = WindowSavedManager.hasResultSummaryParameter(wndDefinition);
        boolean needsDataset = WindowSavedManager.hasQuantiParameter(wndDefinition);
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes < 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (needsRset && !dataSetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            if (needsRsm && !dataSetNode.hasResultSummary()) {
                this.setEnabled(false);
                return;
            }
            if (!needsDataset || dataSetNode.isQuantitation()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

