/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.DisplayRsmProteinSetsAction;
import fr.proline.studio.rsmexplorer.gui.dialog.DataBoxChooserDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class DisplayUserWindowAction
extends AbstractRSMAction {
    private final char m_windowType;

    public DisplayUserWindowAction(char windowType, AbstractTree tree) {
        super(NbBundle.getMessage(DisplayRsmProteinSetsAction.class, (String)"CTL_DisplayUserWindowAction"), tree);
        this.m_windowType = windowType;
    }

    private boolean forRsm() {
        return this.m_windowType == '2';
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        ParameterList outParameter;
        DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        ArrayList<ParameterList> outParameters = new ArrayList<ParameterList>();
        if (!this.forRsm() && dataSetNode.hasResultSet()) {
            outParameter = new ParameterList();
            outParameter.addParameter(ResultSet.class);
            outParameters.add(outParameter);
        }
        if (this.forRsm() && dataSetNode.hasResultSummary()) {
            outParameter = new ParameterList();
            outParameter.addParameter(ResultSummary.class);
            outParameters.add(outParameter);
        }
        if (this.m_windowType == '3' && dataSetNode.isQuantitation()) {
            outParameter = new ParameterList();
            outParameter.addParameter(DDataset.class);
            outParameters.add(outParameter);
        }
        final DDataset dataSet = ((DataSetData)dataSetNode.getData()).getDataset();
        DataBoxChooserDialog dialog = new DataBoxChooserDialog(WindowManager.getDefault().getMainWindow(), outParameters, true);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            AbstractDataBox genericDatabox = dialog.getSelectedDataBox();
            try {
                AbstractDataBox databox = (AbstractDataBox)genericDatabox.getClass().newInstance();
                final WindowBox wbox = WindowBoxFactory.getUserDefinedWindowBox(dataSet.getName(), dataSet.getName() + " " + dialog.getWndTitle(), databox, false, dataSetNode.isQuantitation() && !dataSetNode.isQuantSC(), this.m_windowType);
                if (this.forRsm()) {
                    ResultSummary rsm = dataSetNode.getResultSummary();
                    if (rsm != null) {
                        wbox.setEntryData(dataSet.getProject().getId(), rsm);
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                    } else {
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                wbox.setEntryData(dataSet.getProject().getId(), dataSet.getResultSummary());
                            }
                        };
                        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                        task.initLoadRsetAndRsm(dataSet);
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                    }
                } else if (this.m_windowType == '1') {
                    ResultSet rset = dataSetNode.getResultSet();
                    if (rset != null) {
                        wbox.setEntryData(dataSet.getProject().getId(), rset);
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                    } else {
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                wbox.setEntryData(dataSet.getProject().getId(), dataSet.getResultSet());
                            }
                        };
                        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                        task.initLoadRsetAndRsm(dataSet);
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                    }
                } else if (this.m_windowType == '3') {
                    DDataset ds = dataSetNode.getDataset();
                    if (ds != null) {
                        wbox.setEntryData(dataSet.getProject().getId(), ds);
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                    } else {
                        DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                        win.open();
                        win.requestActive();
                        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                wbox.setEntryData(dataSet.getProject().getId(), dataSet.getResultSet());
                            }
                        };
                        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                        task.initLoadQuantitation(dataSet.getProject(), dataSet);
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.getType() != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            this.setEnabled(false);
            return;
        }
        DataSetNode dataSetNode = (DataSetNode)node;
        if (dataSetNode.isFolder()) {
            this.setEnabled(false);
            return;
        }
        if (this.m_windowType == '1' && !dataSetNode.hasResultSet()) {
            this.setEnabled(false);
            return;
        }
        if (this.forRsm() && !dataSetNode.hasResultSummary()) {
            this.setEnabled(false);
            return;
        }
        if (this.m_windowType == '3' && !dataSetNode.isQuantitation()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

