/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.DownloadProcessedFileTask;
import fr.proline.studio.dpm.task.jms.ExportDatasetTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.dialog.exporter.Export2MzIdentMLDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportMzIdentMLAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public ExportMzIdentMLAction(AbstractTree tree) {
        super(NbBundle.getMessage(ExportMzIdentMLAction.class, (String)"CTL_ExportMzIdentMLAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        final Export2MzIdentMLDialog mzIdentDialog = new Export2MzIdentMLDialog(WindowManager.getDefault().getMainWindow());
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                final AbstractJMSCallback downloadCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            this.setProgress(100);
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                final ArrayList _filePath = new ArrayList();
                final ArrayList _jmsNodeId = new ArrayList();
                AbstractJMSCallback exportCallback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        if (success) {
                            String fileName = mzIdentDialog.getFileName();
                            if (!fileName.toLowerCase().endsWith(".mzid")) {
                                fileName = fileName + ".mzid";
                            }
                            if (_filePath.size() == 1) {
                                DownloadProcessedFileTask task = new DownloadProcessedFileTask(downloadCallback, fileName, (String)_filePath.get(0), (String)_jmsNodeId.get(0));
                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                            }
                        } else {
                            this.setProgress(100);
                        }
                    }
                };
                ArrayList<DDataset> dsets = new ArrayList<DDataset>();
                dsets.add(dataSetNode.getDataset());
                ExportDatasetTask task = new ExportDatasetTask(exportCallback, dsets, null, _filePath, _jmsNodeId, ExportDatasetTask.ExporterFormat.MZIDENTML, mzIdentDialog.getExportParams());
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                return null;
            }
        };
        mzIdentDialog.setTask(task);
        mzIdentDialog.setLocation(x, y);
        mzIdentDialog.setVisible(true);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.DATA_SET && node.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            this.setEnabled(false);
            return;
        }
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        DataSetNode datasetNode = (DataSetNode)node;
        if (!datasetNode.hasResultSummary()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

