/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.xic.DatabaseLoadXicMasterQuantTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.GenerateSpectrumMatchTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.GenerateSpectrumMatchesDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateSpectrumMatchesJMSAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public GenerateSpectrumMatchesJMSAction(AbstractTree tree) {
        super(NbBundle.getMessage(GenerateSpectrumMatchesJMSAction.class, (String)"CTL_GenerateSpectrumMatchesAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DefaultTreeModel treeModel = (DefaultTreeModel)this.getTree().getModel();
        int nbNodes = selectedNodes.length;
        ArrayList<DDataset> allDSs = new ArrayList<DDataset>();
        for (int i = 0; i < nbNodes; ++i) {
            DDataset ds = ((DataSetNode)selectedNodes[i]).getDataset();
            allDSs.add(ds);
            this.loadRSData(ds);
        }
        GenerateSpectrumMatchesDialog dialog = new GenerateSpectrumMatchesDialog(WindowManager.getDefault().getMainWindow(), allDSs);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            final Long frsId = dialog.getFragmentationRuleSetId();
            final Boolean forceGenerate = dialog.getDoForceGenerate();
            for (int i = 0; i < nbNodes; ++i) {
                final DataSetNode node = (DataSetNode)selectedNodes[i];
                node.setIsChanging(true);
                treeModel.nodeChanged(node);
                final AbstractJMSCallback callback = new AbstractJMSCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success) {
                        node.setIsChanging(false);
                        treeModel.nodeChanged(node);
                    }
                };
                final DDataset dataset = node.getDataset();
                final Long projectId = dataset.getProject().getId();
                final Long resultSummaryId = dataset.getResultSummaryId();
                Long resultSetId = dataset.getResultSetId();
                if (resultSetId == null && dataset.isQuantitation()) {
                    AbstractDatabaseCallback rsetIdCallback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            if (success) {
                                GenerateSpectrumMatchTask task = new GenerateSpectrumMatchTask(callback, dataset.getName(), projectId, dataset.getResultSetId(), resultSummaryId, null, frsId.longValue(), forceGenerate);
                                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                            }
                        }
                    };
                    DatabaseLoadXicMasterQuantTask task = new DatabaseLoadXicMasterQuantTask(rsetIdCallback);
                    task.initLoadQuantChannels(dataset.getProject().getId(), dataset);
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                    continue;
                }
                GenerateSpectrumMatchTask task = new GenerateSpectrumMatchTask(callback, dataset.getName(), projectId, resultSetId, resultSummaryId, null, frsId.longValue(), forceGenerate);
                AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
            }
        }
    }

    private void loadRSData(DDataset ds) {
        DatabaseDataSetTask task = new DatabaseDataSetTask(null);
        task.initLoadRsetAndRsm(ds);
        task.fetchData();
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (dataSetNode.isFolder()) {
                this.setEnabled(false);
                return;
            }
            if (dataSetNode.hasResultSet()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

