/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.DatasetToCopy;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.HourGlassNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;

public class PasteSearchResult
extends AbstractRSMAction {
    public PasteSearchResult(AbstractTree tree) {
        super("Paste Search Result", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        IdentificationTree tree = IdentificationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        DatasetToCopy copy = DatasetToCopy.getDatasetCopied();
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        final AbstractNode node = selectedNodes[0];
        node.setIsChanging(true);
        AbstractData data = (AbstractData)node.getUserObject();
        DDataset parentDataset = null;
        if (data.getDataType() == AbstractData.DataTypes.DATA_SET) {
            DataSetNode datasetNode = (DataSetNode)selectedNodes[0];
            parentDataset = datasetNode.getDataset();
        }
        final ArrayList datasetList = new ArrayList(1);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    boolean isParentAProject;
                    DDataset d = (DDataset)datasetList.get(0);
                    DataSetData data = new DataSetData(d);
                    DataSetNode datasetNode = new DataSetNode((AbstractData)data);
                    if (d.getChildrenCount() > 0) {
                        datasetNode.add(new HourGlassNode(null));
                    }
                    boolean bl = isParentAProject = node.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION;
                    if (isParentAProject) {
                        node.insert(datasetNode, node.getChildCount() - 1);
                    } else {
                        node.add(datasetNode);
                    }
                    node.setIsChanging(false);
                    treeModel.nodeStructureChanged(node);
                } else {
                    node.setIsChanging(false);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initPasteDatasets(selectedProject, parentDataset, copy, datasetList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        DatasetToCopy copy = DatasetToCopy.getDatasetCopied();
        if (copy == null) {
            this.setEnabled(false);
            return;
        }
        long cloneProjectId = copy.getProjectId();
        if (selectedNodes.length > 1) {
            this.setEnabled(false);
            return;
        }
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        if (cloneProjectId != selectedProject.getId()) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractData data = (AbstractData)node.getUserObject();
        if (data.getDataType() == AbstractData.DataTypes.PROJECT_IDENTIFICATION) {
            this.setEnabled(true);
            return;
        }
        if (data.getDataType() == AbstractData.DataTypes.DATA_SET) {
            DDataset dataset;
            DataSetData datasetData = (DataSetData)data;
            if (datasetData.getDatasetType().isIdentification() && datasetData.getDatasetType().isFolder()) {
                this.setEnabled(true);
                return;
            }
            if (datasetData.getDatasetType().isIdentification() && datasetData.getDatasetType().isAggregation() && (dataset = datasetData.getDataset()).getResultSetId() == null) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }
}

