/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.pattern.DataboxGeneric;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.GenericPanel;
import fr.proline.studio.rsmexplorer.gui.model.properties.AbstractPropertiesTableModel;
import fr.proline.studio.rsmexplorer.gui.model.properties.IdentificationPropertiesTableModel;
import fr.proline.studio.rsmexplorer.gui.model.properties.XICPropertiesTableModel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.utils.IconManager;
import java.util.ArrayList;
import org.openide.util.NbBundle;

public class PropertiesAction
extends AbstractRSMAction {
    public PropertiesAction(AbstractTree tree) {
        super(NbBundle.getMessage(PropertiesAction.class, (String)"CTL_PropertiesAction"), tree);
    }

    @Override
    public void actionPerformed(final AbstractNode[] selectedNodes, int x, int y) {
        String name = "";
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes == 1) {
            AbstractNode firstNode = selectedNodes[0];
            name = firstNode.getData().getName();
        }
        boolean identificationProperties = false;
        boolean isIdentificationTree = this.getTree() == IdentificationTree.getCurrentTree();
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode.NodeTypes type = selectedNodes[i].getType();
            if (type != AbstractNode.NodeTypes.PROJECT_IDENTIFICATION && (type != AbstractNode.NodeTypes.DATA_SET || !isIdentificationTree) && type != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) continue;
            identificationProperties = true;
        }
        AbstractPropertiesTableModel model = null;
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(name, "Properties", IconManager.IconType.DOCUMENT_LIST, true);
        model = identificationProperties ? new IdentificationPropertiesTableModel() : new XICPropertiesTableModel();
        windowBox.setEntryData(-1L, (Object)model);
        DataBoxViewerTopComponent win2 = new DataBoxViewerTopComponent(windowBox);
        win2.open();
        win2.requestActive();
        final DataboxGeneric databoxGeneric = (DataboxGeneric)windowBox.getEntryBox();
        GenericPanel genericPanel = (GenericPanel)databoxGeneric.getPanel();
        final AbstractPropertiesTableModel _model = model;
        final GenericPanel _genericPanel = genericPanel;
        final int loadingId = databoxGeneric.setLoading();
        DataLoadedCallback dataLoadedCallback = new DataLoadedCallback(selectedNodes.length){

            @Override
            public void run() {
                --this.m_nbDataToLoad;
                if (this.m_nbDataToLoad == 0) {
                    databoxGeneric.setLoaded(loadingId);
                    ArrayList<DDataset> datasetList = new ArrayList<DDataset>();
                    for (AbstractNode node : selectedNodes) {
                        if (!(node instanceof DataSetNode)) continue;
                        DDataset dataset = ((DataSetNode)node).getDataset();
                        datasetList.add(dataset);
                    }
                    if (_model != null) {
                        _model.setData(datasetList);
                        _genericPanel.setMaxLineNumber(_model.getRowCount());
                    }
                }
            }
        };
        int nbDataToLoad = selectedNodes.length;
        for (int i = 0; i < nbDataToLoad; ++i) {
            selectedNodes[i].loadDataForProperties(dataLoadedCallback);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        AbstractNode.NodeTypes currentType = null;
        boolean identificationProperties = false;
        boolean quantitationProperties = false;
        for (int i = 0; i < nbSelectedNodes; ++i) {
            DataSetNode datasetNode;
            AbstractNode node = selectedNodes[i];
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            AbstractNode.NodeTypes type = node.getType();
            if (currentType != null && currentType != type) {
                this.setEnabled(false);
                return;
            }
            if ((type != AbstractNode.NodeTypes.PROJECT_IDENTIFICATION || type != AbstractNode.NodeTypes.PROJECT_QUANTITATION) && type != AbstractNode.NodeTypes.DATA_SET && type != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(false);
                return;
            }
            if (((DataSetNode)node).isTrash() || ((DataSetNode)node).isFolder()) {
                this.setEnabled(false);
                return;
            }
            if (type == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION || type == AbstractNode.NodeTypes.DATA_SET) {
                datasetNode = (DataSetNode)node;
                identificationProperties = true;
                if (!datasetNode.hasResultSet() && !datasetNode.hasResultSummary()) {
                    this.setEnabled(false);
                    return;
                }
            }
            if (type == AbstractNode.NodeTypes.PROJECT_QUANTITATION || type == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                datasetNode = (DataSetNode)node;
                quantitationProperties = true;
                if (!datasetNode.hasResultSet() && !datasetNode.hasResultSummary()) {
                    this.setEnabled(false);
                    return;
                }
            }
            currentType = type;
        }
        if (identificationProperties && quantitationProperties) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public abstract class DataLoadedCallback
    implements Runnable {
        protected int m_nbDataToLoad = 0;

        public DataLoadedCallback(int nb) {
            this.m_nbDataToLoad = nb;
        }

        @Override
        public abstract void run();
    }
}

