/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import org.openide.util.NbBundle;

public class SetRsetNameAction
extends AbstractRSMAction {
    private static final String GENERAL_APPLICATION_SETTINGS = "General Application Settings";
    private AbstractNode[] m_selectedNodes;
    private String m_naming;
    private boolean fail = false;
    private ArrayList<DataSetNode> toRename;

    public SetRsetNameAction(AbstractTree tree, String naming, String ctlProperty) {
        super(NbBundle.getMessage(SetRsetNameAction.class, (String)ctlProperty), tree);
        this.m_naming = naming;
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        this.m_selectedNodes = selectedNodes;
        if (this.m_naming != null) {
            int i;
            int initialExpected = 0;
            this.getTree().subscribeRenamer(this);
            for (i = 0; i < selectedNodes.length; ++i) {
                if (selectedNodes[i].getType() != AbstractNode.NodeTypes.DATA_SET) continue;
                ++initialExpected;
            }
            this.getTree().setExpected(initialExpected);
            for (i = 0; i < selectedNodes.length; ++i) {
                if (selectedNodes[i].getType() != AbstractNode.NodeTypes.DATA_SET) continue;
                this.getTree().loadAllAtOnce((DataSetNode)selectedNodes[i], true);
            }
        }
    }

    public void proceedWithRenaming() {
        int i;
        this.getTree().subscribeRenamer(null);
        this.fail = false;
        this.toRename = new ArrayList();
        for (i = 0; i < this.m_selectedNodes.length; ++i) {
            if (this.m_selectedNodes[i].getType() != AbstractNode.NodeTypes.DATA_SET) continue;
            DataSetNode datasetNode = (DataSetNode)this.m_selectedNodes[i];
            this.getTree().expandNodeIfNeeded(datasetNode);
            if (datasetNode.getChildCount() > 0) {
                Enumeration<TreeNode> e = datasetNode.depthFirstEnumeration();
                while (e.hasMoreElements()) {
                    AbstractNode currentElement = (AbstractNode)e.nextElement();
                    if (currentElement.getType() == AbstractNode.NodeTypes.DATA_SET && currentElement.isLeaf() && currentElement.getChildCount() == 0) {
                        this.toRename.add((DataSetNode)currentElement);
                        continue;
                    }
                    this.getTree().expandNodeIfNeeded(currentElement);
                }
                continue;
            }
            if (!datasetNode.isLeaf()) continue;
            this.toRename.add(datasetNode);
        }
        for (i = 0; i < this.toRename.size(); ++i) {
            final DDataset dataset = this.toRename.get(i).getDataset();
            final DataSetNode node = this.toRename.get(i);
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (IdentificationTree.renameNode(dataset, SetRsetNameAction.this.m_naming, node, SetRsetNameAction.this.getTree())) {
                        SetRsetNameAction.this.fail = true;
                    }
                }
            };
            if (dataset.getResultSet() == null) {
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initLoadRsetAndRsm(dataset);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                continue;
            }
            if (!IdentificationTree.renameNode(dataset, this.m_naming, node, this.getTree())) continue;
            this.fail = true;
        }
        if (this.fail) {
            JOptionPane.showMessageDialog(null, "One or more ResultSet(s) were not renamed.", "Warning", 2);
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.DATA_SET || nodeType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (selectedNodes[i].getType() != AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

