/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.core.orm.uds.Project;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import java.awt.Window;
import javax.swing.tree.DefaultTreeModel;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RenameAction
extends AbstractRSMAction {
    public RenameAction(AbstractTree tree) {
        super(NbBundle.getMessage(RenameAction.class, (String)"CTL_RenameAction"), tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode n = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = n.getType();
        switch (nodeType) {
            case BIOLOGICAL_GROUP: 
            case BIOLOGICAL_SAMPLE: 
            case DATA_SET: {
                DataSetData data = (DataSetData)n.getData();
                String name = data.getName();
                String newName = this.showRenameDialog(name, x, y);
                if (newName == null) {
                    return;
                }
                if (name.compareTo(newName) == 0) break;
                data.setTemporaryName(newName);
                ((DefaultTreeModel)this.getTree().getModel()).nodeChanged(n);
                break;
            }
            case BIOLOGICAL_SAMPLE_ANALYSIS: {
                XICBiologicalSampleAnalysisNode bioSplAnaysisNode = (XICBiologicalSampleAnalysisNode)n;
                String qChName = bioSplAnaysisNode.getQuantChannelName();
                String qChNewName = this.showRenameDialog(qChName, x, y);
                if (qChNewName == null) {
                    return;
                }
                if (qChName.compareTo(qChNewName) == 0) break;
                bioSplAnaysisNode.setQuantChannelName(qChNewName);
                ((DefaultTreeModel)this.getTree().getModel()).nodeChanged(n);
            }
        }
    }

    private String showRenameDialog(String name, int x, int y) {
        OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Rename", null, "New Name", OptionDialog.OptionDialogType.TEXTFIELD);
        dialog.setText(name);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        String newName = null;
        if (dialog.getButtonClicked() == 0) {
            newName = dialog.getText();
        }
        if (newName != null && newName.length() > 0) {
            return newName;
        }
        return null;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.BIOLOGICAL_GROUP && nodeType != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE && nodeType != AbstractNode.NodeTypes.DATA_SET && nodeType != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

