/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class ImagePanel
extends HourglassPanel
implements DataBoxPanelInterface {
    private AbstractDataBox m_dataBox;
    private Dimension m_dimension = null;
    private Image m_img = null;
    private ImageDisplayPanel m_displayPanel;

    public ImagePanel() {
        this.setLayout(new BorderLayout());
        this.m_dimension = new Dimension(0, 0);
        this.m_img = null;
        this.m_displayPanel = new ImageDisplayPanel();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.white);
        scrollPane.setViewportView(this.m_displayPanel);
        this.add(scrollPane, "Center");
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
    }

    public final JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        ExportButton exportImageButton = new ExportButton("Graphic", (JPanel)this.m_displayPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setImage(Image img) {
        this.m_img = img;
        this.m_dimension.width = img.getWidth(null);
        this.m_dimension.height = img.getHeight(null);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private class ImageDisplayPanel
    extends JPanel {
        private ImageDisplayPanel() {
        }

        @Override
        public Dimension getPreferredSize() {
            return ImagePanel.this.m_dimension;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (ImagePanel.this.m_img == null) {
                return;
            }
            g.drawImage(ImagePanel.this.m_img, 0, 0, this);
        }
    }
}

