/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.msfiles.MzdbDownloadBatch;
import fr.proline.studio.rsmexplorer.MzdbFilesTopComponent;
import fr.proline.studio.rsmexplorer.gui.FilesTransferable;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserPanel;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.Exceptions;

public class LocalFileSystemTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ArrayList<File> transferableFiles = new ArrayList<File>();
        if (c instanceof JTree) {
            TreePath[] paths;
            JTree tree = (JTree)c;
            for (TreePath path : paths = tree.getSelectionPaths()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                File file = (File)node.getUserObject();
                String url = file.getAbsolutePath().toLowerCase();
                if (!url.endsWith(".mzdb") && !url.endsWith(".raw") && !url.endsWith(".wiff") && !url.endsWith(".dat")) continue;
                transferableFiles.add(file);
            }
            if (transferableFiles.isEmpty()) {
                return null;
            }
            return new FilesTransferable(transferableFiles, FilesTransferable.SourceFileSystem.SOURCE_LOCAL_FILE_SYSTEM);
        }
        return null;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        support.setShowDropLocation(true);
        if (support.isDataFlavorSupported(FilesTransferable.Files_FLAVOR)) {
            TransferHandler.DropLocation dropLocation = support.getDropLocation();
            if (dropLocation instanceof JTree.DropLocation) {
                try {
                    FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
                    if (transferable.getSource() == FilesTransferable.SourceFileSystem.SOURCE_LOCAL_FILE_SYSTEM) {
                        return false;
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
                return true;
            }
            if (support.getComponent() instanceof TreeFileChooserPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            FilesTransferable transferable = (FilesTransferable)support.getTransferable().getTransferData(FilesTransferable.Files_FLAVOR);
            ArrayList<File> filesToTransfer = transferable.getFiles();
            if (support.getComponent() instanceof JTree) {
                JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
                TreePath dropPath = dropLocation.getPath();
                File dropFile = this.pathToFile(MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().getSelectedRoot(), dropPath);
                if (dropFile.isFile()) {
                    dropPath = dropPath.getParentPath();
                }
                MzdbDownloadBatch downloadBatch = new MzdbDownloadBatch(filesToTransfer, dropPath, MzdbFilesTopComponent.getExplorer().getLocalFileSystemView().getSelectedRoot());
                Thread downloadThread = new Thread(downloadBatch);
                downloadThread.start();
                return true;
            }
            if (support.getComponent() instanceof TreeFileChooserPanel) {
                return true;
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private File pathToFile(String root, TreePath pathToExpand) {
        StringBuilder localURL = new StringBuilder();
        localURL.append(root);
        Object[] elements = pathToExpand.getPath();
        int n = elements.length;
        for (int i = 0; i < n; ++i) {
            localURL.append(elements[i]).append("\\");
        }
        File f = new File(localURL.toString());
        return f;
    }
}

