/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.SaveDataBoxActionListener;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.ProteinsOfPeptideMatchTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.URLCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.windows.TopComponent;

public class RsetProteinsPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private long m_peptideMatchCurId = -1L;
    private JScrollPane m_proteinScrollPane;
    private ProteinTable m_proteinTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private JButton m_decoyButton;
    private final boolean m_startingPanel;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;

    public RsetProteinsPanel(boolean startingPanel) {
        this.m_startingPanel = startingPanel;
        this.setLayout(new BorderLayout());
        final JPanel proteinPanel = this.createProteinPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), new Integer(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JPanel createProteinPanel() {
        JPanel proteinPanel = new JPanel();
        proteinPanel.setBounds(0, 0, 500, 400);
        proteinPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.initComponents();
        proteinPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        proteinPanel.add((Component)toolbar, "West");
        return proteinPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        if (this.m_startingPanel) {
            IconManager.IconType iconType = IconManager.IconType.DATASET_RSET_DECOY;
            this.m_decoyButton = new JButton(IconManager.getIcon((IconManager.IconType)iconType));
            this.m_decoyButton.setToolTipText("Display Decoy Data");
            this.m_decoyButton.setEnabled(false);
            this.m_decoyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResultSet rset = (ResultSet)RsetProteinsPanel.this.m_dataBox.getData(ResultSet.class);
                    ResultSet decoyRset = rset.getDecoyResultSet();
                    if (decoyRset == null) {
                        return;
                    }
                    String windowSaved = SaveDataBoxActionListener.saveParentContainer("tmp", RsetProteinsPanel.this.m_decoyButton);
                    AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(windowSaved);
                    WindowBox wbox = WindowBoxFactory.getFromBoxesWindowBox("Decoy " + RsetProteinsPanel.this.getTopComponentName(), databoxes, true, false, '1');
                    wbox.setEntryData(RsetProteinsPanel.this.m_dataBox.getProjectId(), decoyRset);
                    DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                    win.open();
                    win.requestActive();
                }
            });
        }
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_proteinTable.getModel(), (SettingsInterface)this.m_proteinTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_proteinTable, (JXTable)this.m_proteinTable, (FilterTableModelInterface)((CompoundTableModel)this.m_proteinTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_proteinTable.getModel())){

            protected void filteringDone() {
                RsetProteinsPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsetProteinsPanel.this.m_dataBox.propagateDataChanged();
                RsetProteinsPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_proteinTable.getModel()), "Peptide Match", (JXTable)this.m_proteinTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_proteinTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsetProteinsPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsetProteinsPanel.this.m_dataBox.getId(), RsetProteinsPanel.this.m_dataBox.getUserName(), RsetProteinsPanel.this.m_dataBox.getDataName(), RsetProteinsPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsetProteinsPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_proteinTable, (InfoInterface)this.m_proteinTable);
        if (this.m_startingPanel) {
            toolbar.add(this.m_decoyButton);
        }
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private String getTopComponentName() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof TopComponent); c = c.getParent()) {
        }
        if (c != null && c instanceof TopComponent) {
            return ((TopComponent)c).getName();
        }
        return "";
    }

    public DProteinMatch getSelectedProteinMatch() {
        int selectedRow = this.m_proteinTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_proteinTable.getModel();
        selectedRow = this.m_proteinTable.convertRowIndexToModel(selectedRow);
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        ProteinsOfPeptideMatchTableModel tableModel = (ProteinsOfPeptideMatchTableModel)compoundTableModel.getBaseModel();
        return tableModel.getProteinMatch(selectedRow);
    }

    public void setDataProteinMatchArray(DProteinMatch[] proteinMatchArray, boolean finished) {
        ((ProteinsOfPeptideMatchTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).setData(proteinMatchArray);
        if (proteinMatchArray != null && proteinMatchArray.length > 0) {
            this.m_proteinTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.m_infoToggleButton.updateInfo();
        if (proteinMatchArray != null) {
            this.m_markerContainerPanel.setMaxLineNumber(proteinMatchArray.length);
            if (!this.m_startingPanel) {
                this.m_markerContainerPanel.removeAllMarkers();
            }
        }
        ResultSet rset = (ResultSet)this.m_dataBox.getData(ResultSet.class);
        if (this.m_decoyButton != null && rset != null) {
            this.m_decoyButton.setEnabled(rset.getDecoyResultSet() != null);
        }
        if (finished) {
            this.m_proteinTable.setSortable(true);
        }
    }

    public void setDataPeptideMatch(DPeptideMatch peptideMatch) {
        if (peptideMatch == null) {
            this.clearData();
            this.m_peptideMatchCurId = -1L;
            return;
        }
        if (this.m_peptideMatchCurId != -1L && peptideMatch.getId() == this.m_peptideMatchCurId) {
            return;
        }
        this.m_peptideMatchCurId = peptideMatch.getId();
        DProteinMatch[] proteinMatchArray = peptideMatch.getProteinMatches();
        ((ProteinsOfPeptideMatchTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).setData(proteinMatchArray);
        this.m_proteinTable.getSelectionModel().setSelectionInterval(0, 0);
        this.m_infoToggleButton.updateInfo();
        if (proteinMatchArray != null) {
            this.m_markerContainerPanel.setMaxLineNumber(proteinMatchArray.length);
            if (!this.m_startingPanel) {
                this.m_markerContainerPanel.removeAllMarkers();
            }
        }
        this.m_proteinTable.setSortable(true);
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_proteinTable.dataUpdated(subTask, finished);
    }

    private void clearData() {
        ((ProteinsOfPeptideMatchTableModel)((CompoundTableModel)this.m_proteinTable.getModel()).getBaseModel()).setData(null);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_proteinTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_proteinTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private JPanel initComponents() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_proteinScrollPane = new JScrollPane();
        this.m_proteinTable = new ProteinTable();
        CompoundTableModel model = new CompoundTableModel((GlobalTableModelInterface)new ProteinsOfPeptideMatchTableModel(this.m_proteinTable), true);
        this.m_proteinTable.setModel((TableModel)model);
        URLCellRenderer renderer = (URLCellRenderer)model.getRenderer(0, 1);
        this.m_proteinTable.addMouseListener((MouseListener)renderer);
        this.m_proteinTable.addMouseMotionListener((MouseMotionListener)renderer);
        this.m_proteinTable.getColumnExt(this.m_proteinTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_proteinScrollPane, (MarkerComponentInterface)this.m_proteinTable);
        this.m_proteinScrollPane.setViewportView((Component)((Object)this.m_proteinTable));
        this.m_proteinTable.setFillsViewportHeight(true);
        this.m_proteinTable.setViewport(this.m_proteinScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_proteinTable;
    }

    private class ProteinTable
    extends LazyTable
    implements InfoInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public ProteinTable() {
            super(RsetProteinsPanel.this.m_proteinScrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsetProteinsPanel.this.m_dataBox.addDataChanged(DProteinMatch.class);
            RsetProteinsPanel.this.m_dataBox.propagateDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((ProteinsOfPeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public boolean selectProteinMatch(Long proteinMatchId, String searchText) {
            ProteinsOfPeptideMatchTableModel tableModel = (ProteinsOfPeptideMatchTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(proteinMatchId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return RsetProteinsPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return RsetProteinsPanel.this.m_dataBox.isLoaded();
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(RsetProteinsPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            return count + (count > 1 ? " Proteins" : " Protein");
        }
    }
}

