/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.PeptideInstance;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.SaveDataBoxActionListener;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.dialog.CalcDialog;
import fr.proline.studio.rsmexplorer.gui.model.PeptideInstanceTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class RsmPeptidesPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private PeptideInstanceTable m_peptideInstanceTable;
    private JScrollPane m_scrollPane;
    private MarkerContainerPanel m_markerContainerPanel;
    private JButton m_decoyButton;
    private InfoToggleButton m_infoToggleButton;
    private SearchToggleButton m_searchToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private JButton m_calcButton;

    public RsmPeptidesPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel peptidesPanel = this.createPeptidesPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                peptidesPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)peptidesPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), new Integer(JLayeredPane.PALETTE_LAYER + 1));
    }

    private String getTopComponentName() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof TopComponent); c = c.getParent()) {
        }
        if (c != null && c instanceof TopComponent) {
            return ((TopComponent)c).getName();
        }
        return "";
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_decoyButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DATASET_RSM_DECOY));
        this.m_decoyButton.setToolTipText("Display Decoy Data");
        this.m_decoyButton.setEnabled(false);
        this.m_decoyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultSummary rsm = (ResultSummary)RsmPeptidesPanel.this.m_dataBox.getData(ResultSummary.class);
                ResultSummary decoyRsm = rsm.getDecoyResultSummary();
                if (decoyRsm == null) {
                    return;
                }
                String savedWindow = SaveDataBoxActionListener.saveParentContainer("tmp", RsmPeptidesPanel.this.m_decoyButton);
                AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(savedWindow);
                WindowBox wbox = WindowBoxFactory.getFromBoxesWindowBox("Decoy " + RsmPeptidesPanel.this.getTopComponentName(), databoxes, true, false, '2');
                wbox.setEntryData(RsmPeptidesPanel.this.m_dataBox.getProjectId(), decoyRsm);
                DataBoxViewerTopComponent win = new DataBoxViewerTopComponent(wbox);
                win.open();
                win.requestActive();
            }
        });
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_peptideInstanceTable.getModel(), (SettingsInterface)this.m_peptideInstanceTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_peptideInstanceTable, (JXTable)this.m_peptideInstanceTable, (FilterTableModelInterface)((CompoundTableModel)this.m_peptideInstanceTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_peptideInstanceTable.getModel())){

            protected void filteringDone() {
                RsmPeptidesPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsmPeptidesPanel.this.m_dataBox.propagateDataChanged();
                RsmPeptidesPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_peptideInstanceTable.getModel()), "Peptide Instances", (JXTable)this.m_peptideInstanceTable);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_peptideInstanceTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsmPeptidesPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsmPeptidesPanel.this.m_dataBox.getId(), RsmPeptidesPanel.this.m_dataBox.getUserName(), RsmPeptidesPanel.this.m_dataBox.getDataName(), RsmPeptidesPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsmPeptidesPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        this.m_calcButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CALCULATOR));
        this.m_calcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalcDialog dialog = CalcDialog.getCalcDialog(WindowManager.getDefault().getMainWindow(), (JXTable)RsmPeptidesPanel.this.m_peptideInstanceTable);
                dialog.centerToWindow(WindowManager.getDefault().getMainWindow());
                dialog.setVisible(true);
            }
        });
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_peptideInstanceTable, (InfoInterface)this.m_peptideInstanceTable);
        toolbar.add(this.m_decoyButton);
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        toolbar.add(this.m_calcButton);
        return toolbar;
    }

    private JPanel createPeptidesPanel() {
        JPanel peptidesPanel = new JPanel();
        peptidesPanel.setBounds(0, 0, 500, 400);
        peptidesPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        peptidesPanel.add((Component)internalPanel, "Center");
        JToolBar toolbar = this.initToolbar();
        peptidesPanel.add((Component)toolbar, "West");
        return peptidesPanel;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_peptideInstanceTable = new PeptideInstanceTable();
        this.m_peptideInstanceTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new PeptideInstanceTableModel(this.m_peptideInstanceTable), true));
        this.m_peptideInstanceTable.getColumnExt(this.m_peptideInstanceTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_peptideInstanceTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_peptideInstanceTable));
        this.m_peptideInstanceTable.setFillsViewportHeight(true);
        this.m_peptideInstanceTable.setViewport(this.m_scrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_peptideInstanceTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_peptideInstanceTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_peptideInstanceTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void setData(long taskId, PeptideInstance[] peptideInstances, boolean finished) {
        ResultSummary rsm = (ResultSummary)this.m_dataBox.getData(ResultSummary.class);
        if (rsm != null) {
            this.m_decoyButton.setEnabled(rsm.getDecoyResultSummary() != null);
        }
        ((PeptideInstanceTableModel)((CompoundTableModel)this.m_peptideInstanceTable.getModel()).getBaseModel()).setData(taskId, peptideInstances);
        if (peptideInstances != null && peptideInstances.length > 0) {
            this.m_peptideInstanceTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(peptideInstances.length);
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_peptideInstanceTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_peptideInstanceTable.dataUpdated(subTask, finished);
    }

    public PeptideInstance getSelectedPeptideInstance() {
        int selectedRow = this.m_peptideInstanceTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_peptideInstanceTable.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_peptideInstanceTable.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        PeptideInstanceTableModel tableModel = (PeptideInstanceTableModel)compoundTableModel.getBaseModel();
        return tableModel.getPeptideInstance(selectedRow);
    }

    private class PeptideInstanceTable
    extends LazyTable
    implements InfoInterface {
        String searchTextBeingDone;
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public PeptideInstanceTable() {
            super(RsmPeptidesPanel.this.m_scrollPane.getVerticalScrollBar());
            this.searchTextBeingDone = null;
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsmPeptidesPanel.this.m_dataBox.addDataChanged(PeptideInstance.class);
            RsmPeptidesPanel.this.m_dataBox.addDataChanged(DPeptideMatch.class);
            RsmPeptidesPanel.this.m_dataBox.propagateDataChanged();
        }

        public boolean selectPeptideInstance(Long peptideInstanceId, String searchText) {
            PeptideInstanceTableModel tableModel = (PeptideInstanceTableModel)((CompoundTableModel)this.getModel()).getBaseModel();
            int row = tableModel.findRow(peptideInstanceId);
            if (row == -1) {
                return false;
            }
            row = ((CompoundTableModel)this.getModel()).convertBaseModelRowToCompoundRow(row);
            if (row == -1) {
                return false;
            }
            this.searchTextBeingDone = searchText;
            row = this.convertRowIndexToView(row);
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRowToVisible(row);
            this.searchTextBeingDone = null;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PeptideInstanceTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        RsmPeptidesPanel.this.m_peptideInstanceTable.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        @Override
        public void sortingChanged(int col) {
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return RsmPeptidesPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return RsmPeptidesPanel.this.m_dataBox.isLoaded();
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(RsmPeptidesPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            return count + (count > 1 ? " Peptides" : " Peptide");
        }
    }
}

