/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.msfiles.FileToTransfer;
import fr.proline.studio.msfiles.MsFilesExplorer;
import fr.proline.studio.rsmexplorer.gui.IconCellRenderer;
import fr.proline.studio.rsmexplorer.gui.IconData;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooser;
import fr.proline.studio.rsmexplorer.gui.TreeFileChooserTransferHandler;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeFileChooserPanel
extends JPanel {
    protected TreeFileChooser m_tree;
    protected DefaultTreeModel m_model;
    private DefaultMutableTreeNode m_top;
    private FileSystemView m_fileSystemView;
    private TreeFileChooserTransferHandler m_transferHandler;
    private boolean m_showUpdateButton;
    private TreeUtils.TreeType m_treeType;
    private MsFilesExplorer.FileSelectionInterface m_fileSelectionInterface = null;

    public TreeFileChooserPanel(FileSystemView fileSystemView, TreeFileChooserTransferHandler transferHandler) {
        this.m_fileSystemView = fileSystemView;
        this.m_transferHandler = transferHandler;
        this.m_showUpdateButton = true;
        this.m_treeType = TreeUtils.TreeType.XIC;
    }

    public TreeFileChooserPanel(FileSystemView fileSystemView, TreeFileChooserTransferHandler transferHandler, boolean showUpdateButton) {
        this(fileSystemView, transferHandler);
        this.m_showUpdateButton = showUpdateButton;
        this.m_treeType = TreeUtils.TreeType.SERVER;
    }

    public void restoreTree(TreeUtils.TreeType type) {
        if (this.m_tree != null) {
            TreeUtils.setExpansionState(TreeUtils.loadExpansionState(type, null), this.m_tree, (DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), type, null);
        }
    }

    public void initTree() {
        this.setLayout(new GridBagLayout());
        this.m_top = new DefaultMutableTreeNode(new IconData(IconManager.getIcon((IconManager.IconType)IconManager.IconType.COMPUTER_NETWORK), null, "Server"));
        File[] roots = this.m_fileSystemView.getRoots();
        for (int k = 0; k < roots.length; ++k) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER), IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER_EXPANDED), new FileNode(roots[k])));
            this.m_top.add(node);
            node.add(new DefaultMutableTreeNode(Boolean.TRUE));
        }
        this.m_model = new DefaultTreeModel(this.m_top);
        this.m_tree = new TreeFileChooser(this.m_model);
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(TreeFileChooserPanel.this.m_tree, TreeFileChooserPanel.this.m_treeType, null);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(TreeFileChooserPanel.this.m_tree, TreeFileChooserPanel.this.m_treeType, null);
            }
        });
        if (this.m_transferHandler != null) {
            this.m_tree.setTransferHandler(this.m_transferHandler);
        } else {
            this.m_tree.setTransferHandler(new TreeFileChooserTransferHandler());
        }
        this.m_tree.setDragEnabled(true);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        IconCellRenderer renderer = new IconCellRenderer();
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.addTreeExpansionListener(new DirExpansionListener());
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (TreeFileChooserPanel.this.m_fileSelectionInterface == null) {
                    return;
                }
                ArrayList<FileToTransfer> files = new ArrayList<FileToTransfer>();
                ArrayList<FileToTransfer> directories = new ArrayList<FileToTransfer>();
                ArrayList<FileToTransfer> parentDirectory = new ArrayList<FileToTransfer>();
                TreeFileChooserPanel.this.getSelectedFilesAndDirectories(files, directories, parentDirectory);
                TreeFileChooserPanel.this.m_fileSelectionInterface.downSelectionChanged(files, directories, parentDirectory);
            }
        });
        this.m_tree.getSelectionModel().setSelectionMode(4);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.m_tree);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (this.m_showUpdateButton) {
            JButton updateButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFRESH));
            updateButton.setFocusPainted(false);
            updateButton.setOpaque(true);
            updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreeFileChooserPanel.this.updateTree();
                }
            });
            JToolBar toolbar = new JToolBar();
            toolbar.setFloatable(false);
            toolbar.add(updateButton);
            this.add((Component)toolbar, c);
            ++c.gridy;
            this.add((Component)Box.createVerticalBox(), c);
            c.gridy = 0;
            c.gridheight = 2;
            ++c.gridx;
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)scrollPane, c);
    }

    public void setFileSelectionListener(MsFilesExplorer.FileSelectionInterface fileSelectionInterface) {
        this.m_fileSelectionInterface = fileSelectionInterface;
    }

    public void updateTree() {
        HashSet<String> expandedPaths = TreeUtils.getExpansionState(this.m_tree);
        this.m_top.removeAllChildren();
        this.m_model.reload(this.m_top);
        File[] roots = this.m_fileSystemView.getRoots();
        for (int k = 0; k < roots.length; ++k) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new IconData(IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER), IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER_EXPANDED), new FileNode(roots[k])));
            this.m_top.add(node);
            node.add(new DefaultMutableTreeNode(Boolean.TRUE));
        }
        this.m_model.reload();
        TreeUtils.setExpansionState(expandedPaths, this.m_tree, (DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), TreeUtils.TreeType.SERVER, null);
    }

    public static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (treeNode != null) {
            nodes.add(treeNode);
            for (treeNode = treeNode.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                nodes.add(0, treeNode);
            }
        }
        return nodes.isEmpty() ? null : new TreePath(nodes.toArray());
    }

    public void expandTreePath(TreePath path) {
        this.m_tree.expandPath(path);
    }

    public void expandMultipleTreePath(final HashSet<String> directories, String pathLabel) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.m_model.getRoot();
        Enumeration<TreeNode> totalNodes = root.depthFirstEnumeration();
        while (totalNodes.hasMoreElements()) {
            final DefaultMutableTreeNode node = (DefaultMutableTreeNode)totalNodes.nextElement();
            TreePath nodePath = new TreePath(node.getPath());
            if (!node.toString().toLowerCase().equalsIgnoreCase(pathLabel)) continue;
            this.m_tree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent tme) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent tme) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent tme) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent tme) {
                    Enumeration<TreeNode> mountingPointChildren = node.children();
                    while (mountingPointChildren.hasMoreElements()) {
                        DefaultMutableTreeNode child = (DefaultMutableTreeNode)mountingPointChildren.nextElement();
                        if (!directories.contains(child.toString())) continue;
                        TreeFileChooserPanel.this.m_tree.expandPath(new TreePath(child.getPath()));
                    }
                }
            });
            this.m_tree.expandPath(nodePath);
            break;
        }
    }

    public JTree getTree() {
        return this.m_tree;
    }

    DefaultMutableTreeNode getTreeNode(TreePath path) {
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public static FileNode getFileNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        Object obj = node.getUserObject();
        if (obj instanceof IconData) {
            obj = ((IconData)obj).getObject();
        }
        if (obj instanceof FileNode) {
            return (FileNode)obj;
        }
        return null;
    }

    private void getSelectedFilesAndDirectories(ArrayList<FileToTransfer> files, ArrayList<FileToTransfer> directories, ArrayList<FileToTransfer> parentDirectory) {
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            File f;
            Object extraData;
            Object data;
            DefaultMutableTreeNode node;
            for (TreePath path : paths) {
                node = (DefaultMutableTreeNode)path.getLastPathComponent();
                data = node.getUserObject();
                if (!(data instanceof IconData)) continue;
                extraData = ((IconData)data).getObject();
                if (extraData instanceof FileNode) {
                    f = ((FileNode)extraData).getFile();
                    if (f.isFile()) {
                        files.add(new FileToTransfer(f, path));
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    directories.add(new FileToTransfer(f, path));
                    continue;
                }
                files.clear();
                directories.clear();
                return;
            }
            if (directories.isEmpty() && files.size() == 1) {
                for (TreePath path : paths) {
                    Object parentExtraData;
                    TreePath parentPath;
                    DefaultMutableTreeNode parentNode;
                    Object parentData;
                    node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    data = node.getUserObject();
                    if (!(data instanceof IconData) || !((extraData = ((IconData)data).getObject()) instanceof FileNode) || !(f = ((FileNode)extraData).getFile()).isFile() || !((parentData = (parentNode = (DefaultMutableTreeNode)(parentPath = path.getParentPath()).getLastPathComponent()).getUserObject()) instanceof IconData) || !((parentExtraData = ((IconData)parentData).getObject()) instanceof FileNode)) continue;
                    File parentFile = ((FileNode)parentExtraData).getFile();
                    parentDirectory.add(new FileToTransfer(parentFile, parentPath));
                    break;
                }
            }
        }
    }

    public class FileNode {
        protected File m_file;

        public FileNode(File file) {
            this.m_file = file;
        }

        public File getFile() {
            return this.m_file;
        }

        public String toString() {
            return this.m_file.getName().length() > 0 ? this.m_file.getName() : this.m_file.getPath();
        }

        public boolean expand(DefaultMutableTreeNode parent) {
            DefaultMutableTreeNode flag = (DefaultMutableTreeNode)parent.getFirstChild();
            if (flag == null) {
                return false;
            }
            Object obj = flag.getUserObject();
            if (!(obj instanceof Boolean)) {
                return false;
            }
            parent.removeAllChildren();
            File[] files = this.m_file.listFiles();
            if (files == null) {
                return true;
            }
            ArrayList<FileNode> v = new ArrayList<FileNode>();
            for (int k = 0; k < files.length; ++k) {
                File f = files[k];
                FileNode newNode = new FileNode(f);
                boolean isAdded = false;
                for (int i = 0; i < v.size(); ++i) {
                    FileNode nd = (FileNode)v.get(i);
                    if (newNode.compareTo(nd) >= 0) continue;
                    v.add(i, newNode);
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                v.add(newNode);
            }
            for (int i = 0; i < v.size(); ++i) {
                FileNode nd = (FileNode)v.get(i);
                boolean isDirectory = nd.getFile().isDirectory();
                IconData idata = new IconData(IconManager.getIcon((IconManager.IconType)(isDirectory ? IconManager.IconType.FOLDER : IconManager.IconType.FILE)), isDirectory ? IconManager.getIcon((IconManager.IconType)IconManager.IconType.FOLDER_EXPANDED) : null, nd);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(idata);
                parent.add(node);
                if (!nd.hasSubDirs()) continue;
                node.add(new DefaultMutableTreeNode(Boolean.TRUE));
            }
            return true;
        }

        public boolean hasSubDirs() {
            return this.m_file.isDirectory();
        }

        public int compareTo(FileNode toCompare) {
            return this.m_file.getName().compareToIgnoreCase(toCompare.m_file.getName());
        }
    }

    class DirExpansionListener
    implements TreeExpansionListener {
        DirExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            final DefaultMutableTreeNode node = TreeFileChooserPanel.this.getTreeNode(event.getPath());
            final FileNode fnode = TreeFileChooserPanel.getFileNode(node);
            Thread runner = new Thread(){

                @Override
                public void run() {
                    if (fnode != null && fnode.expand(node)) {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                TreeFileChooserPanel.this.m_model.reload(node);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            };
            runner.start();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

