/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbPreferences;

public class TreeUtils {
    public static Preferences m_preferences = NbPreferences.root();

    public static void saveExpansionState(JTree tree, TreeType type, String rootSuffix) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> set = TreeUtils.getExpansionState(tree);
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            builder.append(";");
        }
        if (type == TreeType.SERVER) {
            m_preferences.put("TreeStateUtil.Server_tree", builder.toString());
        } else if (type == TreeType.LOCAL) {
            m_preferences.put("TreeStateUtil.Local_tree." + rootSuffix, builder.toString());
        } else if (type == TreeType.XIC) {
            m_preferences.put("TreeStateUtil.XIC_tree", builder.toString());
        } else if (type == TreeType.WORKING_SET) {
            m_preferences.put("TreeStateUtil.Working_Set_tree", builder.toString());
        }
    }

    public static HashSet<String> loadExpansionState(TreeType type, String rootSuffix) {
        HashSet<String> retrievedSet = new HashSet<String>();
        String s = type == TreeType.SERVER ? m_preferences.get("TreeStateUtil.Server_tree", null) : (type == TreeType.LOCAL ? m_preferences.get("TreeStateUtil.Local_tree." + rootSuffix, null) : (type == TreeType.XIC ? m_preferences.get("TreeStateUtil.XIC_tree", null) : (type == TreeType.WORKING_SET ? m_preferences.get("TreeStateUtil.Working_Set_tree", null) : null)));
        if (s == null) {
            return retrievedSet;
        }
        StringTokenizer tokenizer = new StringTokenizer(s, ";");
        while (tokenizer.hasMoreTokens()) {
            retrievedSet.add(tokenizer.nextToken());
        }
        return retrievedSet;
    }

    public static HashSet<String> getExpansionState(JTree tree) {
        HashSet<String> expandedPaths = new HashSet<String>();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath tp = tree.getPathForRow(i);
            if (!tree.isExpanded(i)) continue;
            expandedPaths.add(tp.toString());
        }
        return expandedPaths;
    }

    public static void setExpansionState(final HashSet<String> previouslyExpandedPaths, final JTree tree, final DefaultMutableTreeNode root, final TreeType type, final String rootSuffix) {
        if (previouslyExpandedPaths == null || previouslyExpandedPaths.isEmpty()) {
            return;
        }
        if (type == TreeType.LOCAL || type == TreeType.WORKING_SET) {
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent tee) {
                    tree.removeTreeExpansionListener(this);
                    TreeUtils.setExpansionState(previouslyExpandedPaths, tree, root, type, rootSuffix);
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent tee) {
                }
            });
        } else {
            tree.getModel().addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent tme) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent tme) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent tme) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent tme) {
                    tree.getModel().removeTreeModelListener(this);
                    TreePath triggerPath = new TreePath(tme.getPath());
                    if (!tree.isExpanded(triggerPath)) {
                        tree.expandPath(triggerPath);
                    }
                    TreeUtils.setExpansionState(previouslyExpandedPaths, tree, root, type, rootSuffix);
                }
            });
        }
        Enumeration<TreeNode> totalNodes = root.preorderEnumeration();
        while (totalNodes.hasMoreElements() && !previouslyExpandedPaths.isEmpty()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)totalNodes.nextElement();
            TreePath tp = new TreePath(currentNode.getPath());
            if (!previouslyExpandedPaths.contains(tp.toString())) continue;
            previouslyExpandedPaths.remove(tp.toString());
            tree.expandPath(tp);
        }
    }

    public static void expandTree(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtils.expandAll(tree, new TreePath(root), expand);
    }

    public static void expandAll(JTree tree, TreePath path, boolean expand) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                TreeNode n = enumeration.nextElement();
                TreePath p = path.pathByAddingChild(n);
                TreeUtils.expandAll(tree, p, expand);
            }
        }
        if (expand) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    public static enum TreeType {
        SERVER,
        LOCAL,
        XIC,
        WORKING_SET;

    }
}

