/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.core.orm.uds.PeaklistSoftware;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseAdminTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.rsmexplorer.gui.admin.PeakListSoftwareDialog;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class PeaklistSoftwarePanel
extends JPanel {
    private JDialog m_dialogOwner = null;
    private Boolean m_isEditable = true;
    private PeaklistSoftwareTable m_peaklistSoftwareTable;

    public PeaklistSoftwarePanel(JDialog dialog, Boolean editable) {
        this.m_isEditable = editable;
        this.m_dialogOwner = dialog;
        this.setBorder(BorderFactory.createTitledBorder("Peaklist Softwares"));
        this.setLayout(new GridBagLayout());
        this.initInternalPanel();
    }

    private void initInternalPanel() {
        JScrollPane tableScrollPane = new JScrollPane();
        this.m_peaklistSoftwareTable = new PeaklistSoftwareTable();
        tableScrollPane.setViewportView((Component)((Object)this.m_peaklistSoftwareTable));
        this.m_peaklistSoftwareTable.setFillsViewportHeight(true);
        JButton addPeaklistButton = new JButton("Add Peaklist Software");
        addPeaklistButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS_16X16));
        addPeaklistButton.setEnabled(this.m_isEditable);
        String buttonTitle = "View Peaklist Software";
        if (this.m_isEditable.booleanValue()) {
            buttonTitle = "Modify Peaklist Software";
        }
        JButton modifyPeaklistButton = new JButton(buttonTitle);
        modifyPeaklistButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROPERTIES));
        JPanel testPanel = this.createTestPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)tableScrollPane, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)testPanel, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        this.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)addPeaklistButton, c);
        ++c.gridx;
        this.add((Component)modifyPeaklistButton, c);
        addPeaklistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeakListSoftwareDialog peaklistSoftwareDialog = PeakListSoftwareDialog.getDialog(PeaklistSoftwarePanel.this.m_dialogOwner, PeakListSoftwareDialog.DialogMode.CREATE_USER);
                peaklistSoftwareDialog.setLocationRelativeTo(PeaklistSoftwarePanel.this.m_dialogOwner);
                peaklistSoftwareDialog.setVisible(true);
                if (peaklistSoftwareDialog.getButtonClicked() == 0) {
                    AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            if (success) {
                                PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.updatePeaklistSoftwares();
                            }
                        }
                    };
                    DatabaseAdminTask task = new DatabaseAdminTask(callback);
                    task.initAddPeakListSoftware(peaklistSoftwareDialog.getPeaklistSoftwareName(), peaklistSoftwareDialog.getVersion(), peaklistSoftwareDialog.getSpectrumTitleParsingRule());
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                }
            }
        });
        modifyPeaklistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                PeakListSoftwareDialog peaklistSoftwareDialog = PeaklistSoftwarePanel.this.m_isEditable != false ? PeakListSoftwareDialog.getDialog(PeaklistSoftwarePanel.this.m_dialogOwner, PeakListSoftwareDialog.DialogMode.MODIFY_USER) : PeakListSoftwareDialog.getDialog(PeaklistSoftwarePanel.this.m_dialogOwner, PeakListSoftwareDialog.DialogMode.VIEW_USER);
                peaklistSoftwareDialog.setLocationRelativeTo(PeaklistSoftwarePanel.this.m_dialogOwner);
                PeaklistSoftwareTableModel model = (PeaklistSoftwareTableModel)((Object)PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.getModel());
                PeaklistSoftware peaklistSoftware = model.getPeaklistSoftware(PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.convertRowIndexToModel(selectedRow));
                peaklistSoftwareDialog.setPeaklistSoftwareInfo(peaklistSoftware.getName(), peaklistSoftware.getVersion(), peaklistSoftware.getSpecTitleParsingRule());
                peaklistSoftwareDialog.setVisible(true);
                if (peaklistSoftwareDialog.getButtonClicked() == 0) {
                    String name = peaklistSoftwareDialog.getPeaklistSoftwareName();
                    String version = peaklistSoftwareDialog.getVersion();
                    if (name.compareTo(peaklistSoftware.getName()) != 0 || version.compareTo(peaklistSoftware.getVersion()) != 0) {
                        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                                if (success) {
                                    PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.updatePeaklistSoftwares();
                                }
                            }
                        };
                        DatabaseAdminTask task = new DatabaseAdminTask(callback);
                        task.initModifyPeakListSoftware(peaklistSoftware.getId(), peaklistSoftwareDialog.getPeaklistSoftwareName(), peaklistSoftwareDialog.getVersion());
                        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                    }
                }
            }
        });
    }

    private JPanel createTestPanel() {
        JPanel testPanel = new JPanel(new GridBagLayout());
        testPanel.setLayout(new GridBagLayout());
        testPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Title Parsing Test"));
        JLabel spectrumTitleLabel = new JLabel("Spectrum Title:");
        final JTextField spectrumTitleTextField = new JTextField(30);
        JButton testButton = new JButton("Test", IconManager.getIcon((IconManager.IconType)IconManager.IconType.TEST));
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                String spectrumTitle = spectrumTitleTextField.getText().trim();
                int rowSelected = PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.getSelectedRow();
                PeaklistSoftware selectedPS = ((PeaklistSoftwareTableModel)((Object)PeaklistSoftwarePanel.this.m_peaklistSoftwareTable.getModel())).getPeaklistSoftware(rowSelected);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getRawFileIdentifier(), (CharSequence)""), "Raw File Identifier :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getFirstCycle(), (CharSequence)""), "First Cycle :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getLastCycle(), (CharSequence)""), "Last Cycle :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getFirstScan(), (CharSequence)""), "First Scan :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getLastScan(), (CharSequence)""), "Last Scan :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getFirstTime(), (CharSequence)""), "First Time :", spectrumTitle);
                PeaklistSoftwarePanel.parse(sb, (String)StringUtils.defaultIfEmpty((CharSequence)selectedPS.getSpecTitleParsingRule().getLastTime(), (CharSequence)""), "Last Time :", spectrumTitle);
                InfoDialog parseResultDialog = new InfoDialog((Window)PeaklistSoftwarePanel.this.m_dialogOwner, InfoDialog.InfoType.NO_ICON, "Spectrum Title Parsing Result", sb.toString());
                parseResultDialog.setButtonVisible(0, false);
                parseResultDialog.setButtonName(1, "Close");
                parseResultDialog.centerToWindow((Window)PeaklistSoftwarePanel.this.m_dialogOwner);
                parseResultDialog.setVisible(true);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        testPanel.add((Component)spectrumTitleLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        testPanel.add((Component)spectrumTitleTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        testPanel.add((Component)testButton, c);
        return testPanel;
    }

    protected static void parse(StringBuilder sb, String rule, String fieldName, String stringToParse) {
        String[] ruleList;
        sb.append(fieldName);
        for (String element : ruleList = rule.split("\\|\\|")) {
            Pattern pattern;
            Matcher match;
            boolean findAMatch;
            if (element.isEmpty() || !(findAMatch = (match = (pattern = Pattern.compile(element)).matcher(stringToParse)).find())) continue;
            String firstMatch = match.group(1);
            sb.append(firstMatch);
            break;
        }
        sb.append('\n');
    }

    public class PeaklistSoftwareTableModel
    extends DecoratedTableModel {
        private ArrayList<PeaklistSoftware> m_peaklistSoftwareArray = null;
        public static final int COLTYPE_NAME = 0;
        public static final int COLTYPE_VERSION = 1;
        private final String[] m_columnNames = new String[]{"Peaklist Software", "Version"};
        private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

        public PeaklistSoftwareTableModel(PeaklistSoftware[] peaklistSoftwareArray) {
            this.m_peaklistSoftwareArray = new ArrayList(peaklistSoftwareArray.length);
            this.m_peaklistSoftwareArray.addAll(Arrays.asList(peaklistSoftwareArray));
        }

        public int findPeakListSoftware(long id) {
            for (int row = 0; row < this.m_peaklistSoftwareArray.size(); ++row) {
                PeaklistSoftware peaklistSoftware = this.m_peaklistSoftwareArray.get(row);
                if (peaklistSoftware.getId() != id) continue;
                return row;
            }
            return -1;
        }

        public void setPeaklistSoftwares(PeaklistSoftware[] peaklistSoftwareArray) {
            this.m_peaklistSoftwareArray.clear();
            this.m_peaklistSoftwareArray.addAll(Arrays.asList(peaklistSoftwareArray));
            this.fireTableDataChanged();
        }

        public PeaklistSoftware getPeaklistSoftware(int row) {
            if (this.m_peaklistSoftwareArray == null) {
                return null;
            }
            return this.m_peaklistSoftwareArray.get(row);
        }

        public String getColumnName(int col) {
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public int getRowCount() {
            if (this.m_peaklistSoftwareArray == null) {
                return 0;
            }
            return this.m_peaklistSoftwareArray.size();
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            PeaklistSoftware peaklistSoftware = this.m_peaklistSoftwareArray.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return peaklistSoftware.getName();
                }
                case 1: {
                    return peaklistSoftware.getVersion();
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return null;
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            if (this.m_rendererMap.containsKey(col)) {
                return this.m_rendererMap.get(col);
            }
            DefaultLeftAlignRenderer renderer = null;
            switch (col) {
                case 0: {
                    renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                    break;
                }
                case 1: {
                    renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                }
            }
            this.m_rendererMap.put(col, (TableCellRenderer)renderer);
            return renderer;
        }
    }

    public class PeaklistSoftwareTable
    extends DecoratedTable {
        public PeaklistSoftwareTable() {
            this.initData();
        }

        private void initData() {
            PeaklistSoftware[] peaklistSoftwares = DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresArray();
            PeaklistSoftwareTableModel tableModel = new PeaklistSoftwareTableModel(peaklistSoftwares);
            this.setModel((TableModel)((Object)tableModel));
            this.setRowSelectionInterval(0, 0);
        }

        public void updatePeaklistSoftwares() {
            int row;
            int selectedRow = this.getSelectedRow();
            PeaklistSoftwareTableModel tableModel = (PeaklistSoftwareTableModel)((Object)this.getModel());
            long previouslySelectedId = -1L;
            if (selectedRow != -1) {
                selectedRow = this.convertRowIndexToModel(selectedRow);
                PeaklistSoftware peakListSoftware = tableModel.getPeaklistSoftware(selectedRow);
                previouslySelectedId = peakListSoftware.getId();
            }
            PeaklistSoftware[] peaklistSoftwares = DatabaseDataManager.getDatabaseDataManager().getPeaklistSoftwaresArray();
            tableModel.setPeaklistSoftwares(peaklistSoftwares);
            if (previouslySelectedId != -1L && (row = tableModel.findPeakListSoftware(previouslySelectedId)) != -1) {
                row = this.convertRowIndexToView(row);
                this.setRowSelectionInterval(row, row);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

