/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.core.orm.uds.UserAccount;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ChangeUserGroupTask;
import fr.proline.studio.dpm.task.jms.CreateUserAccountTask;
import fr.proline.studio.dpm.task.jms.ResetPasswordTask;
import fr.proline.studio.rsmexplorer.gui.admin.UserAccountDialog;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class UserAccountsPanel
extends JPanel {
    private JDialog m_dialogOwner = null;
    private Boolean m_isEditable = true;
    private UserAccountsTable m_userAccountsTable;

    public UserAccountsPanel(JDialog dialog, Boolean editable) {
        this.m_isEditable = editable;
        this.m_dialogOwner = dialog;
        this.setBorder(BorderFactory.createTitledBorder("User Accounts"));
        this.setLayout(new GridBagLayout());
        JScrollPane tableScrollPane = new JScrollPane();
        this.m_userAccountsTable = new UserAccountsTable();
        tableScrollPane.setViewportView((Component)((Object)this.m_userAccountsTable));
        this.m_userAccountsTable.setFillsViewportHeight(true);
        JButton addUserButton = new JButton("Add User Account");
        addUserButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS_16X16));
        addUserButton.setEnabled(this.m_isEditable);
        JButton propertiesButton = new JButton("Modify User Account");
        propertiesButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROPERTIES));
        propertiesButton.setEnabled(this.m_isEditable);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)tableScrollPane, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        this.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)addUserButton, c);
        ++c.gridx;
        this.add((Component)propertiesButton, c);
        addUserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserAccountDialog userAccountDialog = UserAccountDialog.getDialog(UserAccountsPanel.this.m_dialogOwner, UserAccountDialog.DialogMode.CREATE_USER);
                userAccountDialog.setLocationRelativeTo(UserAccountsPanel.this.m_dialogOwner);
                userAccountDialog.setVisible(true);
                if (userAccountDialog.getButtonClicked() == 0) {
                    AbstractJMSCallback callback = new AbstractJMSCallback(){

                        public boolean mustBeCalledInAWT() {
                            return false;
                        }

                        public void run(boolean success) {
                            if (success) {
                                UserAccountsPanel.this.m_userAccountsTable.updateAccounts();
                            }
                        }
                    };
                    CreateUserAccountTask task = new CreateUserAccountTask(callback, userAccountDialog.getLogin(), userAccountDialog.getPassword(), userAccountDialog.isAdmin());
                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                }
            }
        });
        propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = UserAccountsPanel.this.m_userAccountsTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                UserAccountDialog userAccountDialog = UserAccountDialog.getDialog(UserAccountsPanel.this.m_dialogOwner, UserAccountDialog.DialogMode.MODIFY_USER);
                userAccountDialog.setLocationRelativeTo(UserAccountsPanel.this.m_dialogOwner);
                UserAccountsTableModel model = (UserAccountsTableModel)((Object)UserAccountsPanel.this.m_userAccountsTable.getModel());
                UserAccount user = model.getUserAccount(UserAccountsPanel.this.m_userAccountsTable.convertRowIndexToModel(selectedRow));
                userAccountDialog.setUserAccountInfo(user.getLogin(), DatabaseDataManager.isAdmin((UserAccount)user));
                userAccountDialog.setVisible(true);
                if (userAccountDialog.getButtonClicked() == 0) {
                    ChangeUserGroupTask task;
                    AbstractJMSCallback callback;
                    if (userAccountDialog.userGroupChanged()) {
                        callback = new AbstractJMSCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success) {
                                if (success) {
                                    UserAccountsPanel.this.m_userAccountsTable.updateAccounts();
                                }
                            }
                        };
                        task = new ChangeUserGroupTask(callback, userAccountDialog.getLogin(), Long.valueOf(user.getId()), userAccountDialog.isAdmin());
                        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                    }
                    if (userAccountDialog.passwordChanged()) {
                        callback = new AbstractJMSCallback(){

                            public boolean mustBeCalledInAWT() {
                                return true;
                            }

                            public void run(boolean success) {
                                if (success) {
                                    UserAccountsPanel.this.m_userAccountsTable.updateAccounts();
                                }
                            }
                        };
                        task = new ResetPasswordTask(callback, userAccountDialog.getLogin(), Long.valueOf(user.getId()), userAccountDialog.getPassword());
                        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                    }
                }
            }
        });
    }

    public class UserAccountRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            UserAccount userAccount = (UserAccount)value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setHorizontalAlignment(2);
            if (userAccount == null) {
                label.setIcon(null);
                label.setText("");
                return label;
            }
            label.setText(userAccount.getLogin());
            boolean isAdmin = DatabaseDataManager.isAdmin((UserAccount)userAccount);
            label.setIcon(IconManager.getIcon((IconManager.IconType)(isAdmin ? IconManager.IconType.USER_ADMIN : IconManager.IconType.USER)));
            return label;
        }
    }

    public class UserAccountsTableModel
    extends DecoratedTableModel {
        private ArrayList<UserAccount> m_userAccountArray = null;
        public static final int COLTYPE_NAME = 0;
        public static final int COLTYPE_GROUP = 1;
        private final String[] m_columnNames = new String[]{"User", "Group"};
        private final HashMap<Integer, TableCellRenderer> m_rendererMap = new HashMap();

        public UserAccountsTableModel(UserAccount[] userAccountArray) {
            this.m_userAccountArray = new ArrayList(userAccountArray.length);
            for (UserAccount user : userAccountArray) {
                this.m_userAccountArray.add(user);
            }
        }

        public int findUserAccount(long id) {
            for (int row = 0; row < this.m_userAccountArray.size(); ++row) {
                UserAccount userAccount = this.m_userAccountArray.get(row);
                if (userAccount.getId() != id) continue;
                return row;
            }
            return -1;
        }

        public void setAccounts(UserAccount[] userAccountArray) {
            this.m_userAccountArray.clear();
            for (UserAccount user : userAccountArray) {
                this.m_userAccountArray.add(user);
            }
            this.fireTableDataChanged();
        }

        public UserAccount getUserAccount(int row) {
            if (this.m_userAccountArray == null) {
                return null;
            }
            return this.m_userAccountArray.get(row);
        }

        public String getColumnName(int col) {
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public int getRowCount() {
            if (this.m_userAccountArray == null) {
                return 0;
            }
            return this.m_userAccountArray.size();
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            UserAccount user = this.m_userAccountArray.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return user.getLogin();
                }
                case 1: {
                    return DatabaseDataManager.isAdmin((UserAccount)user) ? "Admin" : "User";
                }
            }
            return null;
        }

        public String getToolTipForHeader(int col) {
            return null;
        }

        public String getTootlTipValue(int row, int col) {
            return null;
        }

        public TableCellRenderer getRenderer(int row, int col) {
            if (this.m_rendererMap.containsKey(col)) {
                return this.m_rendererMap.get(col);
            }
            UserAccountRenderer renderer = null;
            switch (col) {
                case 0: {
                    renderer = new UserAccountRenderer();
                    break;
                }
                case 1: {
                    renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
                }
            }
            this.m_rendererMap.put(col, renderer);
            return renderer;
        }
    }

    public class UserAccountsTable
    extends DecoratedTable {
        public UserAccountsTable() {
            this.initAccounts();
        }

        private void initAccounts() {
            UserAccount[] accounts = DatabaseDataManager.getDatabaseDataManager().getProjectUsersArray();
            UserAccountsTableModel tableModel = new UserAccountsTableModel(accounts);
            this.setModel((TableModel)((Object)tableModel));
            this.setRowSelectionInterval(0, 0);
        }

        public void updateAccounts() {
            int row;
            int selectedRow = this.getSelectedRow();
            UserAccountsTableModel tableModel = (UserAccountsTableModel)((Object)this.getModel());
            long previouslySelectedId = -1L;
            if (selectedRow != -1) {
                selectedRow = this.convertRowIndexToModel(selectedRow);
                UserAccount userAccount = tableModel.getUserAccount(selectedRow);
                previouslySelectedId = userAccount.getId();
            }
            UserAccount[] accounts = DatabaseDataManager.getDatabaseDataManager().getProjectUsersArray();
            tableModel.setAccounts(accounts);
            if (previouslySelectedId != -1L && (row = tableModel.findUserAccount(previouslySelectedId)) != -1) {
                row = this.convertRowIndexToView(row);
                this.setRowSelectionInterval(row, row);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

