/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoFloatingPanel;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.rsmexplorer.gui.calc.DataTree;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngine;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngineInfo;
import fr.proline.studio.rsmexplorer.gui.calc.UserMacroParser;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.DataGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.macros.AbstractMacro;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public class DataAnalyzerPanel
extends JPanel
implements DataBoxPanelInterface,
RServerManager.RAvailableInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane graphScrollPane;
    private GraphPanel m_graphPanel;
    private InfoFloatingPanel m_RSearchFloatingPanel;
    private DataAnalyzerTree m_dataAnalyzerTree;
    private ActionListener m_actionForRetry = null;
    private ProcessEngineInfo m_WillDisplayProcessEngineInfo = null;

    public DataAnalyzerPanel() {
        this.setLayout(new BorderLayout());
        this.setBounds(0, 0, 500, 400);
        this.setBackground(Color.white);
        JPanel internalPanel = this.initComponents();
        this.add((Component)internalPanel, "Center");
        KeyStroke stroke = KeyStroke.getKeyStroke(127, 0);
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataAnalyzerPanel.this.m_graphPanel.deleteAllSelected();
            }
        };
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(stroke, "DELETE");
        this.getActionMap().put("DELETE", actionListener);
    }

    private JPanel initComponents() {
        JPanel internalPanel = new JPanel();
        internalPanel.setBackground(Color.white);
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel treePanel = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 18;
        c2.fill = 1;
        c2.insets = new Insets(5, 5, 5, 5);
        JScrollPane treeScrollPane = new JScrollPane();
        this.m_dataAnalyzerTree = new DataAnalyzerTree();
        treeScrollPane.setViewportView(this.m_dataAnalyzerTree);
        treeScrollPane.setMinimumSize(new Dimension(180, 50));
        JButton refreshButton = new JButton("Refresh Data", IconManager.getIcon((IconManager.IconType)IconManager.IconType.REFRESH));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataAnalyzerPanel.this.m_dataAnalyzerTree.updataDataNodes();
            }
        });
        c2.gridx = 0;
        c2.gridy = 0;
        treePanel.add((Component)refreshButton, c2);
        ++c2.gridx;
        c.weightx = 1.0;
        treePanel.add(Box.createHorizontalGlue(), c2);
        c2.gridx = 0;
        ++c2.gridy;
        c2.gridwidth = 2;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        treePanel.add((Component)treeScrollPane, c2);
        JSplitPane splitPane = new JSplitPane(1, treePanel, this.createGraphZonePanel());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        internalPanel.add((Component)splitPane, c);
        return internalPanel;
    }

    private JPanel createGraphZonePanel() {
        JPanel graphZonePanel = new JPanel();
        graphZonePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        final JButton playButton = new JButton("Process Graph", IconManager.getIcon((IconManager.IconType)IconManager.IconType.CONTROL_PLAY));
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                playButton.setEnabled(false);
                ProcessEngine.getProcessEngine().run(DataAnalyzerPanel.this.m_graphPanel.getNodes(), DataAnalyzerPanel.this.m_graphPanel, playButton);
            }
        });
        this.m_graphPanel = new GraphPanel(this);
        this.m_RSearchFloatingPanel = new InfoFloatingPanel();
        this.m_RSearchFloatingPanel.switchToHourGlass();
        this.m_RSearchFloatingPanel.setInfo("Look for R");
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                DataAnalyzerPanel.this.m_graphPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                int PAD = 10;
                DataAnalyzerPanel.this.m_RSearchFloatingPanel.setLocation(10, c.getHeight() - 10 - DataAnalyzerPanel.this.m_RSearchFloatingPanel.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add((Component)layeredPane, "Center");
        layeredPane.add((Component)this.m_graphPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_RSearchFloatingPanel, JLayeredPane.PALETTE_LAYER);
        this.graphScrollPane = new JScrollPane();
        this.graphScrollPane.setBackground(Color.white);
        this.graphScrollPane.setViewportView(layeredPane);
        c.gridx = 0;
        c.gridy = 0;
        graphZonePanel.add((Component)playButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        graphZonePanel.add(Box.createHorizontalGlue(), c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        graphZonePanel.add((Component)this.graphScrollPane, c);
        graphZonePanel.setBackground(playButton.getBackground());
        this.m_RSearchFloatingPanel.setVisible(true);
        RServerManager.getRServerManager().checkRAvailability((RServerManager.RAvailableInterface)this);
        return graphZonePanel;
    }

    public DataAnalyzerTree getDataAnalyzerTree() {
        return this.m_dataAnalyzerTree;
    }

    public void clearDataAnalyzerPanel() {
        this.m_graphPanel.removeAllGraphNodes();
    }

    public void resetViewpoint() {
        if (this.graphScrollPane != null) {
            this.graphScrollPane.getViewport().setViewPosition(this.m_graphPanel.getViewportProperPoint());
        }
    }

    public void addTableInfoToGraph(TableInfo tableInfo) {
        DataGraphNode graphNode = new DataGraphNode(tableInfo, this.m_graphPanel);
        this.m_graphPanel.addGraphNode(graphNode);
    }

    public void addFunctionToGraph(AbstractFunction function) {
        FunctionGraphNode graphNode = new FunctionGraphNode(function, this.m_graphPanel);
        this.m_graphPanel.addGraphNode(graphNode);
    }

    public void addGraphicToGraph(AbstractGraphic graphic) {
        GraphicGraphNode graphNode = new GraphicGraphNode(this.m_graphPanel, graphic);
        this.m_graphPanel.addGraphNode(graphNode);
    }

    public void addMacroToGraph(AbstractMacro macro) {
        this.m_graphPanel.addMacroToGraph(macro, null);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
    }

    @Override
    public void setLoading(int id) {
    }

    @Override
    public void setLoading(int id, boolean calculating) {
    }

    @Override
    public void setLoaded(int id) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    public void available(boolean rIsAvailable) {
        if (rIsAvailable) {
            this.m_RSearchFloatingPanel.setVisible(false);
            this.m_dataAnalyzerTree.repaint();
        } else {
            if (this.m_actionForRetry == null) {
                final DataAnalyzerPanel _this = this;
                this.m_actionForRetry = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DataAnalyzerPanel.this.m_RSearchFloatingPanel.switchToHourGlass();
                        DataAnalyzerPanel.this.m_RSearchFloatingPanel.setInfo("Look for R");
                        RServerManager.getRServerManager().checkRAvailability((RServerManager.RAvailableInterface)_this);
                    }
                };
                this.m_RSearchFloatingPanel.switchToRetry(this.m_actionForRetry);
            } else {
                this.m_RSearchFloatingPanel.switchToRetry(null);
            }
            this.m_RSearchFloatingPanel.setInfo("R is not available, Retry ?");
        }
    }

    public void displayBelow(GraphNode node, boolean inNewTab, String name, ArrayList<SplittedPanelContainer.PanelLayout> layout, int index) {
        this.m_WillDisplayProcessEngineInfo = new ProcessEngineInfo(node, inNewTab, name, layout, index);
        this.m_dataBox.addDataChanged(ProcessEngineInfo.class);
        this.m_dataBox.propagateDataChanged();
    }

    public ProcessEngineInfo getProcessEngineInfoToDisplay() {
        ProcessEngineInfo processEngineInfo = this.m_WillDisplayProcessEngineInfo;
        this.m_WillDisplayProcessEngineInfo = null;
        return processEngineInfo;
    }

    public class DataAnalyzerTree
    extends DataTree {
        public DataAnalyzerTree() {
            super(new DataTree.RootDataAnalyzerNode(), false, DataAnalyzerPanel.this.m_graphPanel);
        }

        @Override
        public void action(DataTree.DataNode node) {
            switch (node.getType()) {
                case VIEW_DATA: {
                    TableInfo tableInfo = ((DataTree.ViewDataNode)node).getTableInfo();
                    DataAnalyzerPanel.this.addTableInfoToGraph(tableInfo);
                    break;
                }
                case FUNCTION: {
                    AbstractFunction function = ((DataTree.FunctionNode)node).getFunction().cloneFunction(DataAnalyzerPanel.this.m_graphPanel);
                    DataAnalyzerPanel.this.addFunctionToGraph(function);
                    break;
                }
                case GRAPHIC: {
                    AbstractGraphic graphic = ((DataTree.GraphicNode)node).getGraphic().cloneGraphic(DataAnalyzerPanel.this.m_graphPanel);
                    DataAnalyzerPanel.this.addGraphicToGraph(graphic);
                    break;
                }
                case MACRO: {
                    AbstractMacro macro = ((DataTree.MacroNode)node).getMacro();
                    DataAnalyzerPanel.this.addMacroToGraph(macro);
                    break;
                }
                case USERMACRO: {
                    String macroXML = ((DataTree.UserMacroNode)node).getXMLMacro();
                    try {
                        UserMacroParser.getGraphFileManager().parseFile(macroXML, DataAnalyzerPanel.this.m_graphPanel);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
    }
}

