/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.rserver.RServerManager;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopComponent;
import fr.proline.studio.rsmexplorer.gui.calc.DataTreeTransferHandler;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AdjustPFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ColumnFilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ComputeFDRFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.DiffAnalysisFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.DiffFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ExpressionFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.FilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.ImportTSVFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.JoinFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.LogFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.MissingValuesImputationFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.NormalizationFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.QuantiFilterFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.SCDiffAnalysisFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.BoxPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.CalibrationPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.DensityPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.ParallelCoordinatesGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.ScatterOrHistogramGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.VarianceDistPlotGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.VennDiagramGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.macros.AbstractMacro;
import fr.proline.studio.rsmexplorer.gui.calc.macros.MacroSavedManager;
import fr.proline.studio.rsmexplorer.gui.calc.macros.ProStarMacro;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.openide.windows.TopComponent;

public abstract class DataTree
extends JTree {
    private ParentDataNode m_parentDataNode = null;
    private ParentMacrosNode m_parentMacrosNode = null;
    private ParentFunctionNode m_parentFunctionNode = null;
    private ParentGraphicNode m_parentGraphicNode = null;

    protected DataTree(DataNode root, boolean tableOnly, GraphPanel graphPanel) {
        super(root);
        if (tableOnly) {
            this.m_parentDataNode = (ParentDataNode)root;
            this.fillDataNodes(this.m_parentDataNode);
        } else {
            this.m_parentDataNode = new ParentDataNode();
            this.fillDataNodes(this.m_parentDataNode);
            root.add(this.m_parentDataNode);
            this.m_parentMacrosNode = new ParentMacrosNode();
            this.fillMacrosNodes(this.m_parentMacrosNode);
            root.add(this.m_parentMacrosNode);
            this.m_parentFunctionNode = new ParentFunctionNode();
            this.fillFunctionNodes(this.m_parentFunctionNode);
            root.add(this.m_parentFunctionNode);
            this.m_parentGraphicNode = new ParentGraphicNode();
            this.fillGraphicNodes(this.m_parentGraphicNode);
            root.add(this.m_parentGraphicNode);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.nodeStructureChanged(root);
            this.setDragEnabled(true);
            this.setTransferHandler(new DataTreeTransferHandler(graphPanel));
        }
        this.setToggleClickCount(0);
        this.setCellRenderer(new DataAnalyzerTreeRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    DataTree.this.triggerPopup(e);
                } else if (e.getClickCount() == 2) {
                    boolean actionNotAllowed;
                    TreePath path = DataTree.this.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    DataNode node = (DataNode)path.getLastPathComponent();
                    boolean bl = actionNotAllowed = node.isRNeeded() && !RServerManager.getRServerManager().isRStarted();
                    if (actionNotAllowed) {
                        return;
                    }
                    DataTree.this.action(node);
                    DataTree.this.clearSelection();
                }
            }
        });
        DefaultMutableTreeNode currentNode = root.getNextNode();
        do {
            if (currentNode.getLevel() != 1) continue;
            this.expandPath(new TreePath(currentNode.getPath()));
        } while ((currentNode = currentNode.getNextNode()) != null);
    }

    private void triggerPopup(MouseEvent e) {
        DataNode[] selectedNodes = this.getSelectedNodes();
        int nbNodes = selectedNodes.length;
        if (nbNodes == 0) {
            return;
        }
        for (int i = 0; i < nbNodes; ++i) {
            DataNode n = selectedNodes[i];
            if (n.getType() == DataNode.DataNodeType.USERMACRO) continue;
            return;
        }
        JPopupMenu userMacroPopup = new JPopupMenu();
        final DataTree _tree = this;
        userMacroPopup.add(new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultTreeModel model = (DefaultTreeModel)_tree.getModel();
                TreePath[] paths = _tree.getSelectionPaths();
                for (int i = 0; i < paths.length; ++i) {
                    UserMacroNode node = (UserMacroNode)paths[i].getLastPathComponent();
                    String macroName = node.toString();
                    model.removeNodeFromParent(node);
                    MacroSavedManager.removeSavedMacro(macroName);
                }
            }
        });
        userMacroPopup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    public void updataDataNodes() {
        this.fillDataNodes(this.m_parentDataNode);
    }

    public void addUserMacro(String xmlMacro) {
        UserMacroNode node = new UserMacroNode(xmlMacro);
        this.m_parentMacrosNode.add(node);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(this.m_parentMacrosNode);
    }

    public abstract void action(DataNode var1);

    private void fillDataNodes(ParentDataNode parentNode) {
        parentNode.removeAllChildren();
        HashMap<Integer, JXTable> tableMap = new HashMap<Integer, JXTable>();
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Set tcs = TopComponent.getRegistry().getOpened();
        for (TopComponent topComponent : tcs) {
            if (!(topComponent instanceof DataBoxViewerTopComponent)) continue;
            list.clear();
            DataBoxViewerTopComponent databoxViewerTopComponent = (DataBoxViewerTopComponent)topComponent;
            databoxViewerTopComponent.retrieveTableModels(list);
            int nb = list.size();
            if (nb <= 0) continue;
            WindowDataNode windowDataNode = new WindowDataNode(list.get(0));
            parentNode.add(windowDataNode);
            for (int i = 0; i < nb; ++i) {
                TableInfo tableInfo = list.get(i);
                ViewDataNode viewNode = new ViewDataNode(tableInfo);
                windowDataNode.add(viewNode);
                viewNode.fillColumns();
                tableMap.put(tableInfo.getId(), tableInfo.getTable());
            }
        }
        Table.setTables(tableMap);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(parentNode);
    }

    private void fillMacrosNodes(ParentMacrosNode parentMacrosNode) {
        ProStarMacro proStar = new ProStarMacro();
        parentMacrosNode.add(new MacroNode(proStar, true));
        ArrayList<String> macros = MacroSavedManager.readSavedMacros();
        if (macros != null) {
            for (String xmlMacro : macros) {
                UserMacroNode node = new UserMacroNode(xmlMacro);
                parentMacrosNode.add(node);
            }
        }
    }

    private void fillFunctionNodes(ParentFunctionNode parentFunctionNode) {
        ParentFunctionNode tableFonctionsNode = new ParentFunctionNode("Table");
        parentFunctionNode.add(tableFonctionsNode);
        FunctionNode tsvFunction = new FunctionNode(new ImportTSVFunction(null), false);
        tableFonctionsNode.add(tsvFunction);
        FunctionNode columnFilterFunction = new FunctionNode(new ColumnFilterFunction(null), false);
        tableFonctionsNode.add(columnFilterFunction);
        FunctionNode filterFunction = new FunctionNode(new FilterFunction(null), false);
        tableFonctionsNode.add(filterFunction);
        FunctionNode expressionFunction = new FunctionNode(new ExpressionFunction(null), false);
        tableFonctionsNode.add(expressionFunction);
        FunctionNode logFunction = new FunctionNode(new LogFunction(null, false), false);
        tableFonctionsNode.add(logFunction);
        FunctionNode log10Function = new FunctionNode(new LogFunction(null, true), false);
        tableFonctionsNode.add(log10Function);
        FunctionNode diffFunction = new FunctionNode(new DiffFunction(null), false);
        tableFonctionsNode.add(diffFunction);
        FunctionNode joinFunction = new FunctionNode(new JoinFunction(null), false);
        tableFonctionsNode.add(joinFunction);
        ParentFunctionNode statsFonctionsNode = new ParentFunctionNode("Statistics");
        parentFunctionNode.add(statsFonctionsNode);
        FunctionNode quantiFilterFunction = new FunctionNode(new QuantiFilterFunction(null), false);
        statsFonctionsNode.add(quantiFilterFunction);
        FunctionNode missingValuesImputationFunction = new FunctionNode(new MissingValuesImputationFunction(null), true);
        statsFonctionsNode.add(missingValuesImputationFunction);
        FunctionNode normalizationFunction = new FunctionNode(new NormalizationFunction(null), true);
        statsFonctionsNode.add(normalizationFunction);
        FunctionNode bbinomialFunction = new FunctionNode(new SCDiffAnalysisFunction(null), true);
        statsFonctionsNode.add(bbinomialFunction);
        FunctionNode diffAnalysisFunction = new FunctionNode(new DiffAnalysisFunction(null), true);
        statsFonctionsNode.add(diffAnalysisFunction);
        FunctionNode adjustPFunction = new FunctionNode(new AdjustPFunction(null), true);
        statsFonctionsNode.add(adjustPFunction);
        FunctionNode computeFDRFunction = new FunctionNode(new ComputeFDRFunction(null), true);
        statsFonctionsNode.add(computeFDRFunction);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(parentFunctionNode);
    }

    private void fillGraphicNodes(ParentGraphicNode parentGraphicNode) {
        GraphicNode node = new GraphicNode(new BoxPlotGraphic(null), true);
        parentGraphicNode.add(node);
        node = new GraphicNode(new CalibrationPlotGraphic(null), true);
        parentGraphicNode.add(node);
        node = new GraphicNode(new DensityPlotGraphic(null), true);
        parentGraphicNode.add(node);
        node = new GraphicNode(new ParallelCoordinatesGraphic(null), false);
        parentGraphicNode.add(node);
        node = new GraphicNode(new ScatterOrHistogramGraphic(null, PlotType.HISTOGRAM_PLOT), false);
        parentGraphicNode.add(node);
        node = new GraphicNode(new ScatterOrHistogramGraphic(null, PlotType.SCATTER_PLOT), false);
        parentGraphicNode.add(node);
        node = new GraphicNode(new VarianceDistPlotGraphic(null), true);
        parentGraphicNode.add(node);
        node = new GraphicNode(new VennDiagramGraphic(null), false);
        parentGraphicNode.add(node);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(parentGraphicNode);
    }

    public DataNode[] getSelectedNodes() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        int nbPath = paths.length;
        DataNode[] nodes = new DataNode[nbPath];
        for (int i = 0; i < nbPath; ++i) {
            nodes[i] = (DataNode)paths[i].getLastPathComponent();
        }
        return nodes;
    }

    private class DataAnalyzerTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean grayed;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DataNode node = (DataNode)value;
            boolean bl = grayed = !node.isVisible() || node.isRNeeded() && !RServerManager.getRServerManager().isRStarted();
            if (grayed) {
                this.setForeground(Color.gray);
            } else {
                this.setForeground(Color.black);
            }
            ImageIcon icon = node.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            }
            return this;
        }
    }

    public class ColumnDataNode
    extends DataNode {
        private final int m_columnIndex;
        private final boolean m_visible;

        public ColumnDataNode(TableInfo tableInfo, int columnIndex, boolean visible) {
            super(DataNode.DataNodeType.COLUMN_DATA, tableInfo, false);
            this.m_columnIndex = columnIndex;
            this.m_visible = visible;
        }

        public int getColumnIndex() {
            return this.m_columnIndex;
        }

        @Override
        public boolean isVisible() {
            return this.m_visible;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.COLUMN);
        }

        @Override
        public String toString() {
            TableInfo tableInfo = this.getTableInfo();
            GlobalTableModelInterface model = tableInfo.getModel();
            return this.m_columnIndex + ": " + model.getExportColumnName(this.m_columnIndex - 1);
        }
    }

    public class ViewDataNode
    extends DataNode {
        public ViewDataNode(TableInfo tableInfo) {
            super(DataNode.DataNodeType.VIEW_DATA, tableInfo, false);
        }

        public void fillColumns() {
            TableInfo tableInfo = this.getTableInfo();
            JXTable table = tableInfo.getTable();
            List tableColumnList = table.getColumns(true);
            for (TableColumn c : tableColumnList) {
                TableColumnExt tableColumn = (TableColumnExt)c;
                boolean visible = tableColumn.isVisible();
                int modelIndex = tableColumn.getModelIndex();
                ColumnDataNode colNode = new ColumnDataNode(tableInfo, modelIndex + 1, visible);
                this.add(colNode);
            }
        }

        public int getTableIndex() {
            TableInfo tableInfo = this.getTableInfo();
            return tableInfo.getId();
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLE);
        }

        @Override
        public String toString() {
            TableInfo tableInfo = this.getTableInfo();
            return tableInfo.getNameWithId();
        }
    }

    private class WindowDataNode
    extends DataNode {
        public WindowDataNode(TableInfo tableInfo) {
            super(DataNode.DataNodeType.WINDOW_DATA, tableInfo, false);
        }

        @Override
        public ImageIcon getIcon() {
            TableInfo tableInfo = this.getTableInfo();
            return tableInfo.getIcon();
        }

        @Override
        public String toString() {
            TableInfo tableInfo = this.getTableInfo();
            return tableInfo.getFullName();
        }
    }

    public static class GraphicNode
    extends DataNode {
        private AbstractGraphic m_graphic = null;

        public GraphicNode(AbstractGraphic function, boolean needsR) {
            super(DataNode.DataNodeType.GRAPHIC, needsR);
            this.m_graphic = function;
        }

        public AbstractGraphic getGraphic() {
            return this.m_graphic;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.WAVE);
        }

        @Override
        public String toString() {
            return this.m_graphic.getName();
        }
    }

    public static class FunctionNode
    extends DataNode {
        private AbstractFunction m_function = null;

        public FunctionNode(AbstractFunction function, boolean needsR) {
            super(DataNode.DataNodeType.FUNCTION, needsR);
            this.m_function = function;
        }

        public AbstractFunction getFunction() {
            return this.m_function;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.FUNCTION);
        }

        @Override
        public String toString() {
            return this.m_function.getName();
        }
    }

    public static class UserMacroNode
    extends DataNode {
        private String m_xmlMacro = null;
        private String m_name = "";

        public UserMacroNode(String xmlMacro) {
            super(DataNode.DataNodeType.USERMACRO, false);
            int indexEndName;
            this.m_xmlMacro = xmlMacro;
            String ID_DATAANALYZER_XML = "<dataanalyzer name=\"";
            int indexStartName = xmlMacro.indexOf("<dataanalyzer name=\"");
            if (indexStartName != -1 && (indexEndName = xmlMacro.indexOf("\"", (indexStartName += "<dataanalyzer name=\"".length()) + 1)) != -1) {
                this.m_name = this.m_xmlMacro.substring(indexStartName, indexEndName);
            }
        }

        public String getXMLMacro() {
            return this.m_xmlMacro;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.GEAR);
        }

        @Override
        public String toString() {
            return this.m_name;
        }
    }

    public static class MacroNode
    extends DataNode {
        private AbstractMacro m_macro = null;

        public MacroNode(AbstractMacro macro, boolean needsR) {
            super(DataNode.DataNodeType.MACRO, needsR);
            this.m_macro = macro;
        }

        public AbstractMacro getMacro() {
            return this.m_macro;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.GEAR);
        }

        @Override
        public String toString() {
            return this.m_macro.getName();
        }
    }

    public static class ParentGraphicNode
    extends DataNode {
        public ParentGraphicNode() {
            super(DataNode.DataNodeType.PARENT_GRAPHIC, false);
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.WAVE);
        }

        @Override
        public String toString() {
            return "Graphics";
        }
    }

    public static class ParentFunctionNode
    extends DataNode {
        String name;

        public ParentFunctionNode() {
            this("Functions");
        }

        public ParentFunctionNode(String label) {
            super(DataNode.DataNodeType.PARENT_FUNCTION, false);
            this.name = label;
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.FUNCTION);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class ParentMacrosNode
    extends DataNode {
        public ParentMacrosNode() {
            super(DataNode.DataNodeType.PARENT_MACROS, false);
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.GEAR);
        }

        @Override
        public String toString() {
            return "Macros";
        }
    }

    public static class ParentDataNode
    extends DataNode {
        public ParentDataNode() {
            super(DataNode.DataNodeType.PARENT_DATA, false);
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TABLES);
        }

        @Override
        public String toString() {
            return "Data Windows";
        }
    }

    public static class RootDataAnalyzerNode
    extends DataNode {
        public RootDataAnalyzerNode() {
            super(DataNode.DataNodeType.ROOT_DATA_ANALYZER, false);
        }

        @Override
        public ImageIcon getIcon() {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.DATA_ANALYZER);
        }

        @Override
        public String toString() {
            return "Data Analyzer";
        }
    }

    public static abstract class DataNode
    extends DefaultMutableTreeNode {
        private DataNodeType m_type;
        private boolean m_needsR;

        public DataNode(DataNodeType type, boolean needsR) {
            this.m_type = type;
            this.m_needsR = needsR;
        }

        public DataNode(DataNodeType type, TableInfo tableInfo, boolean needsR) {
            this.m_type = type;
            this.m_needsR = needsR;
            this.setUserObject(tableInfo);
        }

        public boolean isRNeeded() {
            return this.m_needsR;
        }

        public DataNodeType getType() {
            return this.m_type;
        }

        public TableInfo getTableInfo() {
            return (TableInfo)this.getUserObject();
        }

        public boolean isVisible() {
            return true;
        }

        public abstract ImageIcon getIcon();

        public static enum DataNodeType {
            ROOT_DATA_ANALYZER,
            PARENT_DATA,
            PARENT_MACROS,
            PARENT_FUNCTION,
            FUNCTION,
            MACRO,
            USERMACRO,
            PARENT_GRAPHIC,
            GRAPHIC,
            WINDOW_DATA,
            VIEW_DATA,
            COLUMN_DATA;

        }
    }
}

