/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.graphics.SelectionGestureSquare;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.rsmexplorer.gui.calc.DataAnalyzerPanel;
import fr.proline.studio.rsmexplorer.gui.calc.DataTree;
import fr.proline.studio.rsmexplorer.gui.calc.DataTreeTransferHandler;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractConnectedGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.AbstractGraphObject;
import fr.proline.studio.rsmexplorer.gui.calc.graph.DataGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphGroup;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphLink;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.rsmexplorer.gui.calc.macros.AbstractMacro;
import fr.proline.studio.rsmexplorer.gui.calc.macros.MacroSavedManager;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.openide.windows.WindowManager;

public class GraphPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private static final int DEFAULT_PANEL_WIDTH = 400;
    private static final int DEFAULT_PANEL_HEIGHT = 400;
    private final LinkedList<GraphNode> m_graphNodeArray = new LinkedList();
    private final DataAnalyzerPanel m_dataAnalyzerPanel;
    private int m_mouseDragX;
    private int m_mouseDragY;
    private final ArrayList<AbstractConnectedGraphObject> m_selectedObjectsArray = new ArrayList();
    private AbstractConnectedGraphObject m_overObject = null;
    private GraphConnector m_selectedConnector = null;
    private GraphLink m_selectedLink = null;
    private final SelectionGestureSquare m_selectionGesture = new SelectionGestureSquare();
    private boolean m_actionOnRelease = false;
    private boolean m_deselectionIfNoMoveNoPopup = false;
    private boolean m_hasMovedOrPopup = false;
    private int m_curMoveCursor = 0;
    private final Dimension m_preferredSize = new Dimension(400, 400);
    private Timer m_timer;
    private final HashSet<GraphGroup> m_paintedGroups = new HashSet();
    private boolean m_mousePressed = false;

    public GraphPanel(DataAnalyzerPanel dataAnalyzerPanel) {
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setTransferHandler(new DataTreeTransferHandler(this));
        this.m_timer = new Timer(20, this);
        this.m_timer.setInitialDelay(200);
        this.m_timer.start();
        this.m_dataAnalyzerPanel = dataAnalyzerPanel;
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
    }

    public void displayBelow(GraphNode node, boolean newTab, String name, ArrayList<SplittedPanelContainer.PanelLayout> layout, int index) {
        this.m_dataAnalyzerPanel.displayBelow(node, newTab, name, layout, index);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_preferredSize;
    }

    public LinkedList<GraphNode> getNodes() {
        return this.m_graphNodeArray;
    }

    public Point getNextGraphNodePosition(GraphNode graphNode) {
        int posX = 0;
        int posY = 120;
        if (!this.m_graphNodeArray.isEmpty()) {
            GraphNode lastGraphNode = this.m_graphNodeArray.getLast();
            posX = lastGraphNode.getCenterX();
            posY = lastGraphNode.getCenterY() + 120;
            int height = this.getHeight();
            if (height > 60 && posY > height - 60) {
                posY = height - 60;
            }
            if (lastGraphNode instanceof DataGraphNode && graphNode != null && graphNode instanceof FunctionGraphNode) {
                posX = (int)((double)posX + 132.0);
                posY = lastGraphNode.getCenterY();
            }
        }
        return new Point(posX, posY);
    }

    public void addGraphNodes(ArrayList<GraphNode> graphNodes) {
        for (GraphNode node : graphNodes) {
            this.addGraphNode(node);
        }
    }

    public void addGraphNode(GraphNode graphNode) {
        Point position = this.getNextGraphNodePosition(graphNode);
        this.addGraphNode(graphNode, position.x, position.y);
    }

    public void addGraphNode(GraphNode graphNode, int x, int y) {
        graphNode.setCenter(x, y);
        this.m_graphNodeArray.add(graphNode);
        int newPanelWidth = Math.max(x + 140, this.m_preferredSize.width);
        int newPanelHeight = Math.max(y + 140, this.m_preferredSize.height);
        if (newPanelWidth > this.m_preferredSize.width || newPanelHeight > this.m_preferredSize.height) {
            this.m_preferredSize.width = newPanelWidth;
            this.m_preferredSize.height = newPanelHeight;
            this.revalidate();
        }
        this.repaint();
    }

    public void addMacroToGraph(AbstractMacro macro, int x, int y) {
        this.addMacroToGraph(macro, new Point(x, y));
    }

    public void addMacroToGraph(AbstractMacro macro, Point position) {
        GraphGroup group = new GraphGroup(macro.getName());
        ArrayList<DataTree.DataNode> nodes = macro.getNodes();
        HashMap<DataTree.DataNode, DataGraphNode> graphNodeMap = new HashMap<DataTree.DataNode, DataGraphNode>();
        boolean firstNode = true;
        for (DataTree.DataNode node : nodes) {
            DataTree.DataNode.DataNodeType type = node.getType();
            int levelX = macro.getLevelX(node);
            int levelY = macro.getLevelY(node);
            GraphNode graphNode = null;
            switch (type) {
                case VIEW_DATA: {
                    DataTree.ViewDataNode dataNode = (DataTree.ViewDataNode)node;
                    TableInfo tableInfo = dataNode.getTableInfo();
                    graphNode = new DataGraphNode(tableInfo, this);
                    break;
                }
                case FUNCTION: {
                    DataTree.FunctionNode functionNode = (DataTree.FunctionNode)node;
                    AbstractFunction function = functionNode.getFunction().cloneFunction(this);
                    graphNode = new FunctionGraphNode(function, this);
                    break;
                }
                case GRAPHIC: {
                    DataTree.GraphicNode graphicNode = (DataTree.GraphicNode)node;
                    AbstractGraphic graphic = graphicNode.getGraphic().cloneGraphic(this);
                    graphNode = new GraphicGraphNode(this, graphic);
                    break;
                }
            }
            if (firstNode && position == null) {
                position = new Point();
                firstNode = false;
                position = this.getNextGraphNodePosition(graphNode);
                if ((double)position.x < 84.0) {
                    position.x = 84;
                }
                if ((double)position.y < 84.0) {
                    position.y = 84;
                }
            }
            graphNodeMap.put(node, (DataGraphNode)graphNode);
            this.addGraphNode(graphNode, position.x + (int)((double)(levelX * 60) * 2.2), position.y + levelY * 60 * 2);
            group.addObject(graphNode);
        }
        for (DataTree.DataNode node : nodes) {
            GraphNode nodeOut = (GraphNode)graphNodeMap.get(node);
            ArrayList<DataTree.DataNode> links = macro.getLinks(node);
            if (links == null) continue;
            for (DataTree.DataNode linkedNode : links) {
                GraphNode nodeIn = (GraphNode)graphNodeMap.get(linkedNode);
                nodeOut.connectTo(nodeIn, 0);
            }
        }
    }

    public void bringToFront(GraphNode graphObject) {
        this.m_graphNodeArray.remove(graphObject);
        this.m_graphNodeArray.add(graphObject);
    }

    public void removeGraphNode(GraphNode graphObject) {
        this.m_graphNodeArray.remove(graphObject);
        this.recalculatePanelDimension();
        this.repaint();
    }

    public void removeAllGraphNodes() {
        while (!this.m_graphNodeArray.isEmpty()) {
            this.m_graphNodeArray.removeLast();
        }
        this.recalculatePanelDimension();
    }

    private void recalculatePanelDimension() {
        if (this.m_graphNodeArray.isEmpty()) {
            this.m_preferredSize.width = 400;
            this.m_preferredSize.height = 400;
            this.revalidate();
        } else {
            int maxX = 0;
            int maxY = 0;
            for (GraphNode node : this.m_graphNodeArray) {
                int x = node.getX();
                int y = node.getY();
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
            int newPanelWidth = maxX + 140;
            int newPanelHeight = maxY + 140;
            if (newPanelWidth != this.m_preferredSize.width || newPanelHeight != this.m_preferredSize.height) {
                this.m_preferredSize.width = newPanelWidth;
                this.m_preferredSize.height = newPanelHeight;
                this.revalidate();
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (AbstractConnectedGraphObject abstractConnectedGraphObject : this.m_graphNodeArray) {
            GraphGroup group = abstractConnectedGraphObject.getGroup();
            if (group != null && !this.m_paintedGroups.contains(group)) {
                this.m_paintedGroups.add(group);
                group.draw(g);
            }
            abstractConnectedGraphObject.draw(g);
        }
        this.m_paintedGroups.clear();
        if (this.m_selectedConnector != null) {
            int x = this.m_selectedConnector.getXConnection();
            int n = this.m_selectedConnector.getYConnection();
            g.setColor(Color.black);
            g.drawLine(x, n, this.m_mouseDragX, this.m_mouseDragY);
        }
        this.paintComponents(g);
        this.m_selectionGesture.paint(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        boolean noOverObject = true;
        this.m_mousePressed = true;
        Iterator<GraphNode> it = this.m_graphNodeArray.descendingIterator();
        while (it.hasNext()) {
            GraphNode graphNode = it.next();
            AbstractGraphObject overObject = graphNode.inside(x, y);
            if (overObject == null) continue;
            noOverObject = false;
            AbstractGraphObject.TypeGraphObject type = overObject.getType();
            switch (type) {
                case GRAPH_NODE: {
                    int modifiers = e.getModifiers();
                    this.m_deselectionIfNoMoveNoPopup = false;
                    if (!overObject.isSelected()) {
                        if ((modifiers & 2) == 0 && (modifiers & 1) == 0) {
                            this.clearGraphNodeSelection();
                        }
                        this.m_selectedObjectsArray.add((AbstractConnectedGraphObject)overObject);
                        overObject.setSelected(true);
                    } else {
                        this.m_deselectionIfNoMoveNoPopup = true;
                        this.m_hasMovedOrPopup = false;
                    }
                    if (!this.m_selectedObjectsArray.contains(overObject)) {
                        this.m_selectedObjectsArray.add((AbstractConnectedGraphObject)overObject);
                        overObject.setSelected(true);
                    }
                    this.m_overObject = (AbstractConnectedGraphObject)overObject;
                    this.bringToFront((GraphNode)overObject);
                    this.m_mouseDragX = x;
                    this.m_mouseDragY = y;
                    if (SwingUtilities.isLeftMouseButton(e) || SwingUtilities.isMiddleMouseButton(e)) {
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    }
                    this.repaint();
                    break;
                }
                case CONNECTOR: {
                    this.clearGraphNodeSelection();
                    this.m_selectedConnector = (GraphConnector)overObject;
                    this.m_mouseDragX = x;
                    this.m_mouseDragY = y;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.repaint();
                    break;
                }
                case LINK: {
                    this.clearGraphNodeSelection();
                    this.m_selectedLink = (GraphLink)overObject;
                    this.m_selectedLink.setSelected(true);
                    this.m_mouseDragX = x;
                    this.m_mouseDragY = y;
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.repaint();
                    break;
                }
                case GRAPH_NODE_ACTION: {
                    this.m_overObject = graphNode;
                    this.m_actionOnRelease = true;
                    break;
                }
                default: {
                    this.clearGraphNodeSelection();
                    break;
                }
            }
            break;
        }
        if (noOverObject) {
            this.clearGraphNodeSelection();
            this.m_selectionGesture.startSelection(x, y);
        }
    }

    private void clearGraphNodeSelection() {
        int nbObjectSelected = this.m_selectedObjectsArray.size();
        for (int i = 0; i < nbObjectSelected; ++i) {
            this.m_selectedObjectsArray.get(i).setSelected(false);
        }
        this.m_selectedObjectsArray.clear();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean mousePressed = this.m_mousePressed;
        this.m_mousePressed = false;
        if (e.isPopupTrigger()) {
            if (!mousePressed) {
                this.mousePressed(e);
            }
            this.m_hasMovedOrPopup = true;
            if (!this.m_selectedObjectsArray.isEmpty()) {
                if (this.m_selectedObjectsArray.size() == 1) {
                    JPopupMenu popup = this.m_selectedObjectsArray.get(0).createPopup(this);
                    if (popup != null) {
                        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                    }
                } else {
                    JPopupMenu popup = this.createNodePopup();
                    popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
                this.m_overObject = null;
            } else if (this.m_selectedConnector != null) {
                JPopupMenu popup = this.m_selectedConnector.createPopup(this);
                if (popup != null) {
                    popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
                this.m_selectedConnector = null;
            } else if (this.m_selectedLink != null) {
                JPopupMenu popup = this.m_selectedLink.createPopup(this);
                if (popup != null) {
                    popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
                this.m_selectedLink = null;
            } else if (this.m_selectedObjectsArray.isEmpty() && this.m_selectedConnector == null && this.m_selectedLink == null) {
                JPopupMenu popup = this.createPanelPopup();
                popup.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        } else if (this.m_selectedConnector != null) {
            int x = e.getX();
            int y = e.getY();
            Iterator<GraphNode> it = this.m_graphNodeArray.descendingIterator();
            while (it.hasNext()) {
                GraphNode inGraphNode;
                GraphConnector connector;
                GraphNode graphNode = it.next();
                AbstractGraphObject overObject = graphNode.inside(x, y);
                if (overObject == null) continue;
                if (overObject.getType() != AbstractGraphObject.TypeGraphObject.CONNECTOR || !this.m_selectedConnector.canBeLinked(connector = (GraphConnector)overObject)) break;
                this.m_selectedConnector.addConnection(connector);
                connector.addConnection(this.m_selectedConnector);
                GraphNode graphNode2 = inGraphNode = connector.isOutConnector() ? this.m_selectedConnector.getGraphNode() : connector.getGraphNode();
                if (inGraphNode.getFirstFreeConnector() != null || !inGraphNode.canAddConnector()) break;
                inGraphNode.addFreeConnector();
                break;
            }
            this.m_selectedConnector = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        } else if (this.m_selectedLink != null) {
            this.m_selectedLink.setSelected(false);
            this.m_selectedLink = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        } else if (this.m_selectionGesture.isSelecting()) {
            this.m_selectionGesture.stopSelection(e.getX(), e.getY());
            int action = this.m_selectionGesture.getAction();
            if (action == 2) {
                boolean isCtrlOrShiftDown;
                Path2D.Double selectionShape = this.m_selectionGesture.getSelectionPath();
                int modifier = e.getModifiers();
                boolean bl = isCtrlOrShiftDown = (modifier & 3) != 0;
                if (!isCtrlOrShiftDown) {
                    this.clearGraphNodeSelection();
                }
                for (GraphNode node : this.m_graphNodeArray) {
                    int y2;
                    int x2;
                    int y1;
                    int x1;
                    if (node.isSelected() || !selectionShape.contains(x1 = node.getX(), y1 = node.getY(), (x2 = node.getXEnd()) - x1, (y2 = node.getYEnd()) - y1)) continue;
                    this.m_selectedObjectsArray.add(node);
                    node.setSelected(true);
                }
            } else if (this.m_overObject == null && !this.m_selectedObjectsArray.isEmpty()) {
                this.clearGraphNodeSelection();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.repaint();
        } else if (this.m_overObject != null && this.m_actionOnRelease) {
            ((GraphNode)this.m_overObject).doAction(e.getX(), e.getY());
            this.repaint();
            ((GraphNode)this.m_overObject).hideAction();
        } else if (this.m_overObject != null) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (this.m_deselectionIfNoMoveNoPopup && !this.m_hasMovedOrPopup) {
                this.clearGraphNodeSelection();
                this.m_selectedObjectsArray.add(this.m_overObject);
                this.m_overObject.setSelected(true);
            }
        } else {
            this.clearGraphNodeSelection();
        }
        this.m_overObject = null;
        this.m_actionOnRelease = false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        if (this.m_actionOnRelease) {
            boolean noOverActionObject = true;
            Iterator<GraphNode> it = this.m_graphNodeArray.descendingIterator();
            while (it.hasNext()) {
                AbstractGraphObject.TypeGraphObject type;
                int y;
                int x;
                GraphNode graphNode = it.next();
                AbstractGraphObject overObject = graphNode.inside(x = e.getX(), y = e.getY());
                if (overObject == null || (type = overObject.getType()) != AbstractGraphObject.TypeGraphObject.GRAPH_NODE_ACTION) continue;
                noOverActionObject = false;
            }
            if (noOverActionObject) {
                this.m_overObject = null;
                this.m_actionOnRelease = false;
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.repaint();
            }
            return;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.m_overObject != null) {
            int i;
            this.m_hasMovedOrPopup = true;
            int nbObjectSelected = this.m_selectedObjectsArray.size();
            int deltaX = x - this.m_mouseDragX;
            int deltaY = y - this.m_mouseDragY;
            for (i = 0; i < nbObjectSelected; ++i) {
                deltaX = this.m_selectedObjectsArray.get(i).correctMoveX(deltaX);
                deltaY = this.m_selectedObjectsArray.get(i).correctMoveY(deltaY);
            }
            for (i = 0; i < nbObjectSelected; ++i) {
                this.m_selectedObjectsArray.get(i).move(deltaX, deltaY);
            }
            this.m_mouseDragX = x;
            this.m_mouseDragY = y;
            this.recalculatePanelDimension();
            this.repaint();
        } else if (this.m_selectedConnector != null) {
            this.m_mouseDragX = x;
            this.m_mouseDragY = y;
            this.repaint();
        } else if (this.m_selectionGesture.isSelecting()) {
            this.m_selectionGesture.continueSelection(x, y);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean needRepaint = false;
        int x = e.getX();
        int y = e.getY();
        int newCursor = 0;
        Iterator<GraphNode> it = this.m_graphNodeArray.descendingIterator();
        while (it.hasNext()) {
            GraphNode graphNode = it.next();
            needRepaint |= graphNode.hideAction();
            if (graphNode.inside(x, y) == null) continue;
            newCursor = 12;
        }
        if (newCursor != this.m_curMoveCursor) {
            this.m_curMoveCursor = newCursor;
            this.setCursor(Cursor.getPredefinedCursor(newCursor));
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    public void deleteAllSelected() {
        int nbObjectSelected = this.m_selectedObjectsArray.size();
        for (int i = 0; i < nbObjectSelected; ++i) {
            this.m_selectedObjectsArray.get(i).deleteAction();
        }
        this.m_selectedObjectsArray.clear();
    }

    public Point getViewportProperPoint() {
        int x = 0;
        int y = 0;
        if (!this.m_graphNodeArray.isEmpty()) {
            x = this.m_graphNodeArray.get(0).getXEnd();
            y = this.m_graphNodeArray.get(0).getYEnd();
        }
        for (int i = 0; i < this.m_graphNodeArray.size(); ++i) {
            if (this.m_graphNodeArray.get(i).getXEnd() > x) {
                x = this.m_graphNodeArray.get(i).getXEnd();
                continue;
            }
            if (this.m_graphNodeArray.get(i).getYEnd() <= y) continue;
            y = this.m_graphNodeArray.get(i).getYEnd();
        }
        return new Point(x, y);
    }

    private JPopupMenu createNodePopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new SaveAsAction());
        popup.addSeparator();
        popup.add(new DeleteAction());
        return popup;
    }

    private JPopupMenu createPanelPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new SelectAllAction());
        popup.add(new ClearAllAction());
        popup.addSeparator();
        popup.add(new SaveAsAllAction());
        return popup;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaint();
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Iterator<GraphNode> it = this.m_graphNodeArray.descendingIterator();
        while (it.hasNext()) {
            GraphNode graphNode = it.next();
            AbstractGraphObject overObject = graphNode.inside(x, y);
            if (overObject == null) continue;
            return overObject.getTooltip(x, y);
        }
        return null;
    }

    public void saveGraph(boolean onlySelectedNodes) {
        if (onlySelectedNodes) {
            LinkedList<GraphNode> graphNodeSelectedArray = new LinkedList<GraphNode>();
            for (GraphNode node : this.m_graphNodeArray) {
                if (!node.isSelected()) continue;
                graphNodeSelectedArray.add(node);
            }
            this.saveGraph(graphNodeSelectedArray);
        } else {
            this.saveGraph(this.m_graphNodeArray);
        }
    }

    public void saveGraph(LinkedList<GraphNode> graphNodeArray) {
        OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Select Macro Name", null, "Macro Name", OptionDialog.OptionDialogType.TEXTFIELD);
        dialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        String macroName = null;
        if (dialog.getButtonClicked() == 0) {
            macroName = dialog.getText().trim();
        }
        if (macroName != null && macroName.length() > 0) {
            String macro = this.saveGraphImpl(graphNodeArray, macroName);
            MacroSavedManager.addSavedMacro(macro);
            this.m_dataAnalyzerPanel.getDataAnalyzerTree().addUserMacro(macro);
        }
    }

    private String saveGraphImpl(LinkedList<GraphNode> graphNodeArray, String macroName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<dataanalyzer name=\"");
        sb.append(macroName);
        sb.append("\">");
        for (GraphNode node : graphNodeArray) {
            node.saveGraph(sb);
        }
        sb.append("</dataanalyzer>");
        return sb.toString();
    }

    public int getNbGraphNodesSelected() {
        int nbGraphNodesSelected = 0;
        for (GraphNode node : this.m_graphNodeArray) {
            if (!node.isSelected()) continue;
            ++nbGraphNodesSelected;
        }
        return nbGraphNodesSelected;
    }

    public GraphPanel getGraph() {
        return this;
    }

    public class SaveAsAllAction
    extends AbstractAction {
        public SaveAsAllAction() {
            super("Save As Macro", IconManager.getIcon((IconManager.IconType)IconManager.IconType.SAVE_SETTINGS));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GraphPanel.this.saveGraph(false);
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            super("Select All", IconManager.getIcon((IconManager.IconType)IconManager.IconType.SELECT_ALL));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int i;
            for (i = 0; i < GraphPanel.this.m_graphNodeArray.size(); ++i) {
                GraphPanel.this.m_selectedObjectsArray.add(GraphPanel.this.m_graphNodeArray.get(i));
            }
            for (i = 0; i < GraphPanel.this.m_selectedObjectsArray.size(); ++i) {
                ((AbstractConnectedGraphObject)GraphPanel.this.m_selectedObjectsArray.get(i)).setSelected(true);
            }
        }
    }

    public class ClearAllAction
    extends AbstractAction {
        public ClearAllAction() {
            super("Clear All", IconManager.getIcon((IconManager.IconType)IconManager.IconType.CLEAR_ALL));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int reply = JOptionPane.showConfirmDialog(null, "Are you sure you want to clear the graph?", "Warning", 0);
            if (reply == 0) {
                while (GraphPanel.this.m_graphNodeArray.size() > 0) {
                    ((GraphNode)GraphPanel.this.m_graphNodeArray.get(GraphPanel.this.m_graphNodeArray.size() - 1)).deleteAction();
                }
            }
        }
    }

    public class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphPanel.this.deleteAllSelected();
        }
    }

    public class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("Save As Macro");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GraphPanel.this.saveGraph(true);
        }
    }
}

