/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.core.orm.uds.BiologicalGroup;
import fr.proline.core.orm.uds.GroupSetup;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.JCheckBoxList;
import fr.proline.studio.gui.JCheckBoxListPanel;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.types.GroupSelection;
import fr.proline.studio.types.QuantitationType;
import fr.proline.studio.types.XicGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbPreferences;
import org.python.core.PyObject;

public abstract class AbstractOnExperienceDesignFunction
extends AbstractFunction {
    private static final String NBGROUPS_KEY = "NBGROUPS";
    private static final String QUANTITATIONTYPE_KEY = "QUANTITATIONTYPE";
    private static final String SEL_COLS_PREFIX = "SEL_COLS";
    private ObjectParameter m_nbGroupsParameter = null;
    private ObjectParameter m_quantitationTypeParameter = null;
    private MultiObjectParameter[] m_columnsParameterArray = null;
    private ParameterList m_extraParameterList = null;
    private final ArrayList<String> m_functionName;
    private final ArrayList<String> m_resultName;
    private final ArrayList<String> m_pythonCall;
    private final ArrayList<Object> m_colExtraInfo;
    private final ArrayList<String> m_outInfo;
    private final ArrayList<String> m_groupNames = new ArrayList();

    public AbstractOnExperienceDesignFunction(GraphPanel panel, AbstractFunction.FUNCTION_TYPE type, String functionName, String resultName, String pythonCall, String outInfo, Object colExtraInfo) {
        super(panel, type);
        this.m_functionName = new ArrayList();
        this.m_resultName = new ArrayList();
        this.m_pythonCall = new ArrayList();
        this.m_colExtraInfo = new ArrayList();
        this.m_outInfo = new ArrayList();
        this.addCalculationTodo(functionName, resultName, pythonCall, outInfo, colExtraInfo);
    }

    public void addCalculationTodo(String functionName, String resultName, String pythonCall, String outInfo, Object colExtraInfo) {
        this.m_resultName.add(resultName);
        this.m_functionName.add(functionName);
        this.m_pythonCall.add(pythonCall);
        this.m_outInfo.add(outInfo);
        this.m_colExtraInfo.add(colExtraInfo);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_nbGroupsParameter = null;
        this.m_quantitationTypeParameter = null;
        this.m_columnsParameterArray = null;
    }

    public abstract int getMinGroups();

    public abstract int getMaxGroups();

    @Override
    public String getName(int index) {
        if (index > 0) {
            return this.m_functionName.get(index);
        }
        return this.m_functionName.get(0);
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return this.m_functionName.size();
    }

    @Override
    public String getOutTooltip(int index) {
        if (this.getNumberOfOutParameters() == 1) {
            return null;
        }
        return this.m_outInfo.get(index);
    }

    @Override
    public void process(GraphConnector[] graphObjects, FunctionGraphNode functionGraphNode, ProcessCallbackInterface callback) {
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        this.setInError(false, null);
        if (this.m_columnsParameterArray == null) {
            callback.finished(functionGraphNode);
            return;
        }
        GroupSelection groupSelection = new GroupSelection();
        int nbColList = (Integer)this.m_nbGroupsParameter.getAssociatedObjectValue();
        int nbCols = 0;
        for (int i = 0; i < nbColList; ++i) {
            ArrayList colList = (ArrayList)this.m_columnsParameterArray[i].getAssociatedValues(true);
            if (colList == null || colList.isEmpty()) {
                callback.finished(functionGraphNode);
                return;
            }
            groupSelection.addGroup(colList);
            nbCols += colList.size();
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            Table sourceTable = new Table(srcModel);
            ResultVariable[] extraVariables = this.getExtraVariables(sourceTable);
            int nbExtraVariables = extraVariables == null ? 0 : extraVariables.length;
            ResultVariable[] parameters = new ResultVariable[nbCols + nbExtraVariables];
            int nbSizeDone = 0;
            for (int j = 0; j < nbColList; ++j) {
                List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
                for (int i = 0; i < colList.size(); ++i) {
                    Integer colIndex = (Integer)colList.get(i);
                    ColRef col = sourceTable.getCol(colIndex.intValue());
                    parameters[i + nbSizeDone] = new ResultVariable((PyObject)col);
                }
                nbSizeDone += colList.size();
            }
            for (int i = 0; i < nbExtraVariables; ++i) {
                parameters[nbSizeDone + i] = extraVariables[i];
            }
            int nbCalculations = this.m_functionName.size();
            this.doCalculation(0, nbCalculations, nbSizeDone, nbColList, parameters, sourceTable, groupSelection, callback, functionGraphNode);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    private void doCalculation(final int calculationIndex, final int nbCalculations, final int nbSizeDone, final int nbColList, final ResultVariable[] parameters, final Table sourceTable, final GroupSelection groupSelection, final ProcessCallbackInterface callback, final FunctionGraphNode functionGraphNode) {
        String pythonCode = this.createCode(calculationIndex, nbSizeDone, nbColList, parameters);
        CalcCallback calcCallback = new CalcCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ArrayList<ResultVariable> variables, CalcError error) {
                boolean problemEncountered = false;
                try {
                    if (variables != null) {
                        for (ResultVariable var : variables) {
                            if (var.getName().compareTo((String)AbstractOnExperienceDesignFunction.this.m_resultName.get(calculationIndex)) != 0) continue;
                            GlobalTableModelInterface model = null;
                            PyObject res = var.getValue();
                            if (res instanceof ColDoubleData) {
                                ColDoubleData col = (ColDoubleData)var.getValue();
                                sourceTable.addColumn((Col)col, (Object)AbstractOnExperienceDesignFunction.this.m_colExtraInfo, (TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true));
                                model = sourceTable.getModel();
                            } else if (res instanceof Table) {
                                Table t = (Table)var.getValue();
                                model = t.getModel();
                            }
                            model.addSingleValue((Object)groupSelection);
                            AbstractOnExperienceDesignFunction.this.addModel(model);
                            if (AbstractOnExperienceDesignFunction.this.m_extraParameterList == null) continue;
                            AbstractOnExperienceDesignFunction.this.m_extraParameterList.saveParameters(NbPreferences.root());
                        }
                    } else if (error != null) {
                        problemEncountered = true;
                        if (AbstractOnExperienceDesignFunction.this.m_extraParameterList != null) {
                            AbstractOnExperienceDesignFunction.this.m_extraParameterList.saveParameters(NbPreferences.root());
                        }
                        AbstractOnExperienceDesignFunction.this.setInError(error);
                    }
                    if (calculationIndex + 1 == nbCalculations || problemEncountered) {
                        AbstractOnExperienceDesignFunction.this.setCalculating(false);
                    } else {
                        AbstractOnExperienceDesignFunction.this.doCalculation(calculationIndex + 1, nbCalculations, nbSizeDone, nbColList, parameters, sourceTable, groupSelection, callback, functionGraphNode);
                    }
                }
                finally {
                    if (calculationIndex + 1 == nbCalculations || problemEncountered) {
                        callback.finished(functionGraphNode);
                    }
                }
            }
        };
        CalcInterpreterTask task = new CalcInterpreterTask(pythonCode, parameters, calcCallback);
        CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
    }

    private String createCode(int index, int nbSizeDone, int nbColList, ResultVariable[] parameters) {
        String extraValues;
        StringBuilder codeSB = new StringBuilder();
        codeSB.append(this.m_resultName.get(index)).append("=Stats.").append(this.m_pythonCall.get(index)).append("((");
        nbSizeDone = 0;
        for (int j = 0; j < nbColList; ++j) {
            codeSB.append('(');
            List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
            for (int i = 0; i < colList.size(); ++i) {
                codeSB.append(parameters[i + nbSizeDone].getName());
                if (i >= colList.size() - 1) continue;
                codeSB.append(',');
            }
            nbSizeDone += colList.size();
            codeSB.append(')');
            if (j >= nbColList - 1) continue;
            codeSB.append(',');
        }
        codeSB.append(')');
        if (this.addLabelParameter()) {
            codeSB.append(",(");
            boolean first = true;
            for (int j = 0; j < nbColList; ++j) {
                List colList = (List)this.m_columnsParameterArray[j].getAssociatedValues(true);
                for (int i = 0; i < colList.size(); ++i) {
                    if (first) {
                        first = false;
                    } else {
                        codeSB.append(',');
                    }
                    if (this.m_groupNames.size() == nbColList) {
                        codeSB.append("\"").append(this.m_groupNames.get(j)).append("\"");
                        continue;
                    }
                    codeSB.append("\"group").append(j).append("\"");
                }
            }
            codeSB.append(")");
        }
        if ((extraValues = this.getExtraValuesForFunctionCall()) != null) {
            codeSB.append(extraValues);
        }
        codeSB.append(')');
        return codeSB.toString();
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null) {
            return false;
        }
        if (this.m_columnsParameterArray == null) {
            return false;
        }
        int nbColList = (Integer)this.m_nbGroupsParameter.getAssociatedObjectValue();
        for (int i = 0; i < nbColList; ++i) {
            List colList = (List)this.m_columnsParameterArray[i].getAssociatedValues(true);
            if (colList != null && !colList.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        final GlobalTableModelInterface sourceModel = graphObjects[0].getGlobalTableModelInterface();
        boolean hasQuantitationTypeParameter = false;
        int nbGroupsFound = -1;
        int nbGroups = this.getMinGroups();
        GroupSelection groupSelection = (GroupSelection)sourceModel.getSingleValue(GroupSelection.class);
        if (groupSelection != null) {
            nbGroups = nbGroupsFound = groupSelection.getNumberOfGroups();
            Object[] groupArray = new String[]{nbGroupsFound + "group(s)"};
            Object[] groupAssociatedArray = new Object[]{nbGroupsFound};
            this.m_nbGroupsParameter = new ObjectParameter(NBGROUPS_KEY, "Number of Groups", null, groupArray, groupAssociatedArray, nbGroupsFound == 2 ? 0 : 1, null);
            this.m_columnsParameterArray = new MultiObjectParameter[nbGroupsFound];
            for (int i = 0; i < nbGroupsFound; ++i) {
                ArrayList selectedCols = groupSelection.getGroup(i);
                Object[] selectedColsObject = selectedCols.toArray();
                boolean[] selection = new boolean[selectedCols.size()];
                for (int j = 0; j < selection.length; ++j) {
                    selection[j] = true;
                }
                this.m_columnsParameterArray[i] = new MultiObjectParameter(SEL_COLS_PREFIX + i, "group " + i, null, selectedColsObject, selectedColsObject, selection, true);
                this.m_columnsParameterArray[i].setCompulsory(2);
            }
            this.m_extraParameterList = this.getExtraParameterList();
            if (this.m_extraParameterList != null) {
                this.m_extraParameterList.loadParameters(NbPreferences.root());
            }
            int nbExtraParameterList = this.m_extraParameterList == null ? 0 : 1;
            this.m_parameters = new ParameterList[nbExtraParameterList];
            if (this.m_extraParameterList != null) {
                this.m_parameters[0] = this.m_extraParameterList;
            }
        } else {
            int i;
            int i2;
            GroupSetup groupSetup;
            boolean[][] selection;
            int i3;
            int nbColumns = sourceModel.getColumnCount();
            final ArrayList<Integer> columnKept = new ArrayList<Integer>();
            HashSet<QuantitationType> m_quantitationsSet = new HashSet<QuantitationType>();
            for (i3 = 0; i3 < nbColumns; ++i3) {
                QuantitationType quantitationType = (QuantitationType)sourceModel.getColValue(QuantitationType.class, i3);
                if (quantitationType == null) continue;
                columnKept.add(i3);
                m_quantitationsSet.add(quantitationType);
            }
            boolean bl = hasQuantitationTypeParameter = !m_quantitationsSet.isEmpty();
            if (!hasQuantitationTypeParameter) {
                for (i3 = 0; i3 < nbColumns; ++i3) {
                    Class c = sourceModel.getDataColumnClass(i3);
                    if (!c.equals(Float.class) && !c.equals(Double.class) && !c.equals(Integer.class) && !c.equals(Long.class)) continue;
                    columnKept.add(i3);
                }
            }
            final int nbColumnsKept = columnKept.size();
            Object[] objectArray1 = new Object[nbColumnsKept];
            Object[] associatedObjectArray1 = new Object[nbColumnsKept];
            for (int i4 = 0; i4 < nbColumnsKept; ++i4) {
                objectArray1[i4] = sourceModel.getColumnName(((Integer)columnKept.get(i4)).intValue()).replaceAll("<br/>", " ");
                associatedObjectArray1[i4] = (Integer)columnKept.get(i4) + 1;
            }
            String[] groupNameList = new String[]{"First Group", "Second Group", "Third Group", "Fourth Group", "Fifth Group", "Sixth Group", "Seventh Group", "Eighth Group"};
            for (boolean[] row : selection = new boolean[this.getMaxGroups()][nbColumnsKept]) {
                Arrays.fill(row, false);
            }
            DDataset dataset = (DDataset)sourceModel.getSingleValue(DDataset.class);
            if (dataset != null && (groupSetup = dataset.getGroupSetup()) != null) {
                List listBiologicalGroups = groupSetup.getBiologicalGroups();
                nbGroups = listBiologicalGroups.size();
                if (nbGroups >= this.getMinGroups() && nbGroups <= this.getMaxGroups()) {
                    nbGroupsFound = nbGroups;
                    for (int i5 = 0; i5 < nbGroups; ++i5) {
                        groupNameList[i5] = ((BiologicalGroup)listBiologicalGroups.get(i5)).getName() + " Group";
                    }
                    if (hasQuantitationTypeParameter) {
                        this.m_groupNames.clear();
                        HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>();
                        for (i2 = 0; i2 < nbColumnsKept; ++i2) {
                            XicGroup group;
                            QuantitationType quantitationType = (QuantitationType)sourceModel.getColValue(QuantitationType.class, ((Integer)columnKept.get(i2)).intValue());
                            if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || groupMap.containsKey((group = (XicGroup)sourceModel.getColValue(XicGroup.class, ((Integer)columnKept.get(i2)).intValue())).getId())) continue;
                            groupMap.put(group.getId(), groupMap.size());
                            String name = group.getName();
                            if (name == null) continue;
                            this.m_groupNames.add(group.getName());
                        }
                        if (groupMap.size() == nbGroups) {
                            for (int j = 0; j < nbGroups; ++j) {
                                for (int i6 = 0; i6 < nbColumnsKept; ++i6) {
                                    QuantitationType quantitationType = (QuantitationType)sourceModel.getColValue(QuantitationType.class, ((Integer)columnKept.get(i6)).intValue());
                                    XicGroup group = (XicGroup)sourceModel.getColValue(XicGroup.class, ((Integer)columnKept.get(i6)).intValue());
                                    if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || (Integer)groupMap.get(group.getId()) != j) continue;
                                    selection[j][i6] = true;
                                }
                            }
                        }
                    }
                } else {
                    nbGroups = this.getMinGroups();
                }
            }
            int nbGroupChoices = this.getMaxGroups() - this.getMinGroups() + 1;
            Object[] groupArray = new String[nbGroupChoices];
            Object[] groupAssociatedArray = new Object[nbGroupChoices];
            for (i2 = 0; i2 < nbGroupChoices; ++i2) {
                groupArray[i2] = String.valueOf(this.getMinGroups() + i2) + " Groups";
                groupAssociatedArray[i2] = this.getMinGroups() + i2;
            }
            this.m_nbGroupsParameter = new ObjectParameter(NBGROUPS_KEY, "Number of Groups", null, groupArray, groupAssociatedArray, nbGroups == 2 ? 0 : 1, null);
            Object[] quantitationArray = m_quantitationsSet.toArray(new QuantitationType[0]);
            Object[] quantitationTypeArray = new Integer[quantitationArray.length];
            int quantitationSelected = -1;
            for (i = 0; i < quantitationArray.length; ++i) {
                quantitationTypeArray[i] = quantitationArray[i].getType();
                if (quantitationTypeArray[i] != 4 && (Integer)quantitationTypeArray[i] != 0) continue;
                quantitationSelected = i;
            }
            if (hasQuantitationTypeParameter) {
                this.m_quantitationTypeParameter = new ObjectParameter(QUANTITATIONTYPE_KEY, "Quantitation Type", null, quantitationArray, quantitationTypeArray, quantitationSelected, null);
            }
            this.m_columnsParameterArray = new MultiObjectParameter[this.getMaxGroups()];
            for (i = 0; i < this.getMaxGroups(); ++i) {
                this.m_columnsParameterArray[i] = new MultiObjectParameter(SEL_COLS_PREFIX + i, groupNameList[i], null, objectArray1, associatedObjectArray1, selection[i], true);
                this.m_columnsParameterArray[i].setCompulsory(2);
            }
            this.m_extraParameterList = this.getExtraParameterList();
            if (this.m_extraParameterList != null) {
                this.m_extraParameterList.loadParameters(NbPreferences.root());
            }
            int nbExtraParameterList = this.m_extraParameterList == null ? 0 : 1;
            this.m_parameters = new ParameterList[this.getMaxGroups() + 1 + nbExtraParameterList];
            this.m_parameters[0] = new ParameterList("group and quantitation");
            this.m_parameters[0].add((Object)this.m_nbGroupsParameter);
            if (hasQuantitationTypeParameter) {
                this.m_parameters[0].add((Object)this.m_quantitationTypeParameter);
            }
            this.m_parameters[0].getPanel();
            for (int i7 = 0; i7 < this.getMaxGroups(); ++i7) {
                this.m_parameters[i7 + 1] = new ParameterList("bbinomial" + i7);
                this.m_parameters[i7 + 1].add((Object)this.m_columnsParameterArray[i7]);
            }
            if (this.m_extraParameterList != null) {
                this.m_parameters[this.m_parameters.length - 1] = this.m_extraParameterList;
            }
            final int _nbGroupsFound = nbGroupsFound;
            if (this.getMaxGroups() >= 3) {
                for (int i8 = 3; i8 < this.getMaxGroups() + 1; ++i8) {
                    final Integer number = i8;
                    AbstractLinkedParameters nbGroupslinkedParameters = new AbstractLinkedParameters(this.m_parameters[i8]){

                        public void valueChanged(String value, Object associatedValue) {
                            this.enableList((Integer)associatedValue >= number);
                        }
                    };
                    this.m_nbGroupsParameter.addLinkedParameters(nbGroupslinkedParameters);
                }
            }
            AbstractLinkedParameters quantitationVisibilityParameters = new AbstractLinkedParameters(this.m_parameters[0]){

                public void valueChanged(String value, Object associatedValue) {
                    if (AbstractOnExperienceDesignFunction.this.m_quantitationTypeParameter != null) {
                        this.showParameter((AbstractParameter)AbstractOnExperienceDesignFunction.this.m_quantitationTypeParameter, (Integer)associatedValue == _nbGroupsFound);
                    }
                }
            };
            this.m_nbGroupsParameter.addLinkedParameters(quantitationVisibilityParameters);
            if (hasQuantitationTypeParameter) {
                final int _nbGroups = nbGroups;
                for (int i9 = 0; i9 < this.getMaxGroups(); ++i9) {
                    final int _groudIndex = i9;
                    AbstractLinkedParameters quantitationTypelinkedParameters = new AbstractLinkedParameters(this.m_parameters[i9]){
                        private boolean doingValueChanged;
                        {
                            super(x0);
                            this.doingValueChanged = false;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void valueChanged(String value, Object associatedValue) {
                            if (this.doingValueChanged) {
                                return;
                            }
                            try {
                                XicGroup group;
                                QuantitationType quantitationType;
                                int i;
                                this.doingValueChanged = true;
                                JCheckBoxList cb = ((JCheckBoxListPanel)AbstractOnExperienceDesignFunction.this.m_columnsParameterArray[_groudIndex].getComponent()).getCheckBoxList();
                                cb.reinitSelection();
                                Integer quantitationChoosen = (Integer)associatedValue;
                                HashMap<Long, Integer> groupMap = new HashMap<Long, Integer>();
                                for (i = 0; i < nbColumnsKept; ++i) {
                                    quantitationType = (QuantitationType)sourceModel.getColValue(QuantitationType.class, ((Integer)columnKept.get(i)).intValue());
                                    if (quantitationType.getType() != 4 && quantitationType.getType() != 0 || groupMap.containsKey((group = (XicGroup)sourceModel.getColValue(XicGroup.class, ((Integer)columnKept.get(i)).intValue())).getId())) continue;
                                    groupMap.put(group.getId(), groupMap.size());
                                }
                                if (groupMap.size() == _nbGroups) {
                                    for (i = 0; i < nbColumnsKept; ++i) {
                                        quantitationType = (QuantitationType)sourceModel.getColValue(QuantitationType.class, ((Integer)columnKept.get(i)).intValue());
                                        group = (XicGroup)sourceModel.getColValue(XicGroup.class, ((Integer)columnKept.get(i)).intValue());
                                        if (quantitationType.getType() != quantitationChoosen.intValue() || (Integer)groupMap.get(group.getId()) != _groudIndex) continue;
                                        cb.selectItem(i);
                                    }
                                }
                            }
                            finally {
                                this.doingValueChanged = false;
                            }
                        }
                    };
                    this.m_quantitationTypeParameter.addLinkedParameters(quantitationTypelinkedParameters);
                }
            }
        }
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    public ParameterList getExtraParameterList() {
        return null;
    }

    public String getExtraValuesForFunctionCall() {
        return null;
    }

    public ResultVariable[] getExtraVariables(Table sourceTable) {
        return null;
    }

    public boolean addLabelParameter() {
        return false;
    }
}

