/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.parameter.MultiObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.python.model.ExprTableModel;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import java.util.ArrayList;
import org.python.core.PyObject;

public class LogFunction
extends AbstractFunction {
    private static final String SEL_COL1 = "SEL_COL1";
    private MultiObjectParameter m_columnsParameter = null;
    private final boolean m_log10;

    public LogFunction(GraphPanel panel, boolean log10) {
        super(panel, log10 ? AbstractFunction.FUNCTION_TYPE.Log10Function : AbstractFunction.FUNCTION_TYPE.Log2Function);
        this.m_log10 = log10;
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_columnsParameter = null;
    }

    @Override
    public String getName(int index) {
        if (this.m_log10) {
            return "Log10";
        }
        return "Log2";
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public void process(GraphConnector[] graphObjects, final FunctionGraphNode functionGraphNode, final ProcessCallbackInterface callback) {
        this.setInError(false, null);
        if (this.m_parameters == null) {
            callback.finished(functionGraphNode);
            return;
        }
        ArrayList colList = (ArrayList)this.m_columnsParameter.getAssociatedValues(true);
        if (colList == null) {
            callback.finished(functionGraphNode);
            return;
        }
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        if (colList.isEmpty()) {
            this.addModel((GlobalTableModelInterface)new ExprTableModel(graphObjects[0].getGlobalTableModelInterface()));
            callback.finished(functionGraphNode);
            return;
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            Table sourceTable = new Table(srcModel);
            int nbCols = colList.size();
            ResultVariable[] parameters = new ResultVariable[nbCols + 1];
            for (int i = 0; i < nbCols; ++i) {
                ColRef col = sourceTable.getCol(((Integer)colList.get(i)).intValue());
                parameters[i] = new ResultVariable((PyObject)col);
            }
            parameters[nbCols] = new ResultVariable((PyObject)sourceTable);
            StringBuilder codeSB = new StringBuilder();
            if (this.m_log10) {
                codeSB.append("logColumn=Stats.log10(");
            } else {
                codeSB.append("logColumn=Stats.log2(");
            }
            codeSB.append(parameters[nbCols].getName());
            int nbColsToLog = parameters.length - 1;
            if (nbColsToLog > 1) {
                codeSB.append(",(");
                for (int i = 0; i < parameters.length - 1; ++i) {
                    codeSB.append(parameters[i].getName());
                    if (i >= parameters.length - 2) continue;
                    codeSB.append(",");
                }
                codeSB.append(")");
            } else {
                codeSB.append(",");
                codeSB.append(parameters[0].getName());
            }
            codeSB.append(')');
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("logColumn") != 0) continue;
                                Table resTable = (Table)var.getValue();
                                LogFunction.this.addModel(resTable.getModel());
                            }
                        } else if (error != null) {
                            LogFunction.this.setInError(error);
                        }
                        LogFunction.this.setCalculating(false);
                    }
                    finally {
                        callback.finished(functionGraphNode);
                    }
                }
            };
            CalcInterpreterTask task = new CalcInterpreterTask(codeSB.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        int nbColumns = model1.getColumnCount();
        int nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class) && !c.equals(Long.class) && !c.equals(Integer.class)) continue;
            ++nbColumnsKept;
        }
        Object[] objectArray1 = new Object[nbColumnsKept];
        Object[] associatedObjectArray1 = new Object[nbColumnsKept];
        int iKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class) && !c.equals(Long.class) && !c.equals(Integer.class)) continue;
            objectArray1[iKept] = model1.getColumnName(i).replaceAll("<br/>", " ");
            associatedObjectArray1[iKept] = i + 1;
            ++iKept;
        }
        ParameterList parameterList1 = new ParameterList("param1");
        this.m_columnsParameter = new MultiObjectParameter(SEL_COL1, "Columns to log", null, objectArray1, associatedObjectArray1, null, true);
        this.m_columnsParameter.setCompulsory(false);
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterList1;
        parameterList1.add((Object)this.m_columnsParameter);
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        LogFunction clone = new LogFunction(p, this.m_log10);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null) {
            return false;
        }
        if (this.m_columnsParameter == null) {
            return false;
        }
        ArrayList colList = (ArrayList)this.m_columnsParameter.getAssociatedValues(true);
        return colList != null;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }
}

