/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graph;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessEngine;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class GraphicGraphNode
extends GraphNode {
    private static final Color FRAME_COLOR = new Color(240, 160, 40);
    private final AbstractGraphic m_graphic;

    public GraphicGraphNode(GraphPanel panel, AbstractGraphic graphic) {
        super(panel);
        this.m_outConnector = null;
        this.m_graphic = graphic;
        this.m_inConnectors = new LinkedList();
        this.m_inConnectors.add(new GraphConnector(this, false, 0, panel));
    }

    @Override
    public String getFullName() {
        String dataName = this.getDataName();
        if (dataName == null) {
            return this.m_graphic.getName();
        }
        return dataName + ' ' + this.m_graphic.getName();
    }

    @Override
    public String getDataName() {
        return this.getPreviousDataName();
    }

    @Override
    public String getTypeName() {
        return this.m_graphic.getName();
    }

    @Override
    public String getErrorMessage() {
        return this.m_graphic.getErrorMessage();
    }

    @Override
    public Color getFrameColor() {
        return FRAME_COLOR;
    }

    @Override
    public ImageIcon getIcon() {
        return this.m_graphic.getIcon();
    }

    @Override
    public ImageIcon getStatusIcon() {
        if (!this.isConnected(false)) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.WARNING);
        }
        if (!this.isConnected(true)) {
            return null;
        }
        if (!this.settingsDone()) {
            if (this.canSetSettings()) {
                return IconManager.getIcon((IconManager.IconType)IconManager.IconType.SETTINGS);
            }
            return null;
        }
        if (this.m_graphic.isCalculating()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS);
        }
        if (this.m_graphic.inError()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.EXCLAMATION);
        }
        if (this.m_graphic.calculationDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.TICK_CIRCLE);
        }
        if (this.m_graphic.isSettingsBeingDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.SETTINGS);
        }
        return IconManager.getIcon((IconManager.IconType)IconManager.IconType.CONTROL_PLAY);
    }

    @Override
    public ImageIcon getDisplayIcon() {
        if (this.m_graphic.calculationDone()) {
            return IconManager.getIcon((IconManager.IconType)IconManager.IconType.WAVE);
        }
        return null;
    }

    @Override
    public GraphNode.NodeAction possibleAction() {
        if (!this.isConnected(true)) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        if (!this.settingsDone()) {
            return this.canSetSettings() ? GraphNode.NodeAction.STEP_ACTION : GraphNode.NodeAction.NO_ACTION;
        }
        if (this.m_graphic.isCalculating()) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        if (this.m_graphic.inError()) {
            return GraphNode.NodeAction.ERROR_ACTION;
        }
        if (this.m_graphic.calculationDone()) {
            return GraphNode.NodeAction.RESULT_ACTION;
        }
        if (this.m_graphic.isSettingsBeingDone()) {
            return GraphNode.NodeAction.NO_ACTION;
        }
        return GraphNode.NodeAction.STEP_ACTION;
    }

    @Override
    public void doAction(int x, int y) {
        if (this.m_graphNodeAction.isHighlighted()) {
            this.m_graphNodeAction.setHighlighted(false);
            if (!this.settingsDone()) {
                int nbConnections = this.m_inConnectors == null ? 0 : this.m_inConnectors.size();
                new GraphNode.SettingsAction(this, nbConnections).actionPerformed(null);
                return;
            }
            if (this.m_graphic.inError()) {
                new GraphNode.ErrorAction(this).actionPerformed(null);
                return;
            }
            if (this.m_graphic.calculationDone()) {
                new GraphNode.DisplayInNewWindowAction(this, 0, null).actionPerformed(null);
                return;
            }
            new GraphNode.ProcessAction(this).actionPerformed(null);
        } else if (this.m_menuAction.isHighlighted()) {
            this.m_menuAction.setHighlighted(false);
            JPopupMenu popup = this.createPopup(this.m_graphPanel);
            if (popup != null) {
                popup.show(this.m_graphPanel, x, y);
            }
        }
    }

    @Override
    public boolean canBeProcessed() {
        return this.isConnected(true) && this.settingsDone() && !this.m_graphic.isCalculating() && !this.m_graphic.inError() && !this.m_graphic.calculationDone() && !this.m_graphic.isSettingsBeingDone();
    }

    @Override
    public void propagateSourceChanged() {
        this.m_graphic.inLinkDeleted();
        super.propagateSourceChanged();
    }

    @Override
    public boolean isConnected(boolean recursive) {
        return ((GraphConnector)this.m_inConnectors.get(0)).isConnected(recursive);
    }

    @Override
    public boolean canSetSettings() {
        GraphNode graphNode;
        if (!this.isConnected(true)) {
            return false;
        }
        GraphConnector connector = (GraphConnector)this.m_inConnectors.get(0);
        return connector.isConnected(true) && (graphNode = connector.getLinkedSourceGraphConnector().getGraphNode()).settingsDone() && graphNode.calculationDone();
    }

    @Override
    public boolean settingsDone() {
        return this.m_graphic.settingsDone();
    }

    @Override
    public boolean calculationDone() {
        if (!this.isConnected(true)) {
            return false;
        }
        if (!this.settingsDone()) {
            return false;
        }
        return this.m_graphic.calculationDone();
    }

    @Override
    public void process(ProcessCallbackInterface callback) {
        if (!this.isConnected(true)) {
            callback.finished(this);
            return;
        }
        if (!this.settingsDone()) {
            boolean settingsDone = this.settings();
            this.m_graphPanel.repaint();
            if (!settingsDone) {
                callback.stopped(this);
            } else {
                callback.reprocess(this);
            }
            return;
        }
        GraphConnector[] graphObjectArray = new GraphConnector[this.m_inConnectors.size()];
        int i = 0;
        for (GraphConnector connector : this.m_inConnectors) {
            GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
            graphObjectArray[i++] = srcConnector;
        }
        this.m_graphic.process(graphObjectArray, this, callback);
    }

    @Override
    public void askDisplay(int index) {
        String dataName = "";
        if (this.m_inConnectors.size() > 0) {
            GraphNode graphNode = ((GraphConnector)this.m_inConnectors.get(0)).getLinkedSourceGraphConnector().getGraphNode();
            dataName = graphNode.getDataName();
        }
        this.m_graphic.display(dataName);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(int index) {
        String dataName = "";
        if (this.m_inConnectors.size() > 0) {
            GraphNode graphNode = ((GraphConnector)this.m_inConnectors.get(0)).getLinkedSourceGraphConnector().getGraphNode();
            dataName = graphNode.getDataName();
        }
        ArrayList<WindowBox> windowBoxList = new ArrayList<WindowBox>(1);
        windowBoxList.add(this.m_graphic.getDisplayWindowBox(dataName));
        return windowBoxList;
    }

    @Override
    public ArrayList<SplittedPanelContainer.PanelLayout> getAutoDisplayLayoutDuringProcess() {
        return this.m_graphic.getAutoDisplayLayoutDuringProcess();
    }

    @Override
    public boolean settings() {
        GraphConnector[] graphObjectArray = new GraphConnector[this.m_inConnectors.size()];
        int i = 0;
        for (GraphConnector connector : this.m_inConnectors) {
            GraphConnector srcConnector = connector.getLinkedSourceGraphConnector();
            graphObjectArray[i++] = srcConnector;
        }
        boolean settingsChanged = this.m_graphic.settings(graphObjectArray, this);
        if (settingsChanged) {
            super.propagateSourceChanged();
            if (!ProcessEngine.getProcessEngine().isRunAll()) {
                ProcessEngine.getProcessEngine().runANode(this, this.m_graphPanel);
            }
        }
        return settingsChanged;
    }

    @Override
    public GlobalTableModelInterface getGlobalTableModelInterface(int index) {
        return null;
    }

    @Override
    public String getOutTooltip(int index) {
        return null;
    }

    @Override
    public String getTooltip(int x, int y) {
        return null;
    }

    @Override
    public void saveGraph(StringBuilder sb) {
        sb.append("<graphnode id=\"").append(this.m_id).append("\" x=\"").append(this.getCenterX()).append("\" y=\"").append(this.getCenterY()).append("\" type=\"Graphic\"").append(" subtype=\"").append(this.m_graphic.getTypeId()).append('\"').append(">");
        sb.append("</graphnode>");
        if (this.m_outConnector != null) {
            for (GraphConnector connector : this.m_outConnector) {
                connector.saveGraph(sb);
            }
        }
    }
}

